/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.notice;

import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PFundAccntService;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.datatype.message.PQuote;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.datatype.message.PSecAccntService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.refdata.PRefDataService;
import cms.tmx.datatype.proto.strategy.PHedge;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.datatype.proto.unify_risk.PUnifyRiskService;
import cms.tmx.datatype.proto.user.PUser;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.notice.AlgorithmStatusNoticeReport;
import cms.tmx.entity.notice.AssetReport;
import cms.tmx.entity.notice.BankAccountFandRecordReport;
import cms.tmx.entity.notice.BankAccountFundReport;
import cms.tmx.entity.notice.BankAccountReport;
import cms.tmx.entity.notice.BusinessRejectReport;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.CashPushReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.FutureStrategyReport;
import cms.tmx.entity.notice.HedgeTaskReport;
import cms.tmx.entity.notice.HkwolunRateReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.ListExecuteReport;
import cms.tmx.entity.notice.ListStatusReport;
import cms.tmx.entity.notice.LogReport;
import cms.tmx.entity.notice.LogoutReport;
import cms.tmx.entity.notice.MarketStatusReport;
import cms.tmx.entity.notice.ModifyPasswdReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.notice.OpStatusReport;
import cms.tmx.entity.notice.QuoteAutoReport;
import cms.tmx.entity.notice.RefDataReport;
import cms.tmx.entity.notice.ResourceReport;
import cms.tmx.entity.notice.RiskMonitorReport;
import cms.tmx.entity.notice.SessionStatusReport;
import cms.tmx.entity.notice.StaticRiskReport;
import cms.tmx.entity.notice.StrategyNoticeReport;
import cms.tmx.entity.notice.SynExtFundAccntResp;
import cms.tmx.entity.notice.SyncExtSecAccntsResp;
import cms.tmx.entity.notice.TopSpeedInstructionReport;
import cms.tmx.entity.notice.TradeCaptureReport;
import cms.tmx.entity.notice.TransferFundReport;
import cms.tmx.entity.notice.TransferPositionReport;
import cms.tmx.entity.notice.UserAuthenticateReport;
import com.google.protobuf.Any;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NoticeFactory {
    private static final Logger logger = LogManager.getLogger(NoticeFactory.class);
    private static final String EXECUTION_REPORT = "on push type: execution_report";

    public MxNotice createNotice(PMisc.Notice notice) {
        MxNotice report = null;
        Any any = notice.getObject();
        if (any.is(PMessage.ExecutionReport.class)) {
            report = new ExecutionReport();
        } else if (any.is(PMessage.OrderCancelReject.class)) {
            report = new CancelRejectReport();
        } else if (any.is(PAssetService.AssetDistribution.class)) {
            report = new AssetReport();
        } else if (any.is(PQuote.Quote.class)) {
            report = new QuoteAutoReport();
        } else if (any.is(PMainTenance.LogReportPush.class)) {
            report = new LogReport();
        } else if (any.is(PMessage.BusinessReject.class)) {
            report = new BusinessRejectReport();
        } else if (any.is(POrderService.ListStatusReport.class)) {
            report = new ListStatusReport();
        } else if (any.is(POrderService.ListExecuteReport.class)) {
            report = new ListExecuteReport();
        } else if (any.is(PMainTenance.SessionStatusReport.class)) {
            report = new SessionStatusReport();
        } else if (any.is(PInstructionManagement.InstructionReport.class)) {
            report = notice.getEventCode() == 603 ? new TopSpeedInstructionReport() : new InstructionReport();
        } else if (any.is(PPostTrade.TradeCaptureReport.class)) {
            report = new TradeCaptureReport();
        } else if (any.is(PRefDataService.RefDataVersionResp.class)) {
            report = new RefDataReport();
        } else if (any.is(PUnifyRiskService.RiskMonitorResp.class)) {
            report = new RiskMonitorReport();
        } else if (any.is(PUnifyRiskService.GetStaticRiskPush.class)) {
            report = new StaticRiskReport();
        } else if (any.is(PStrategy.StrategyNotice.class)) {
            report = new StrategyNoticeReport();
        } else if (any.is(PHedge.HedgeTaskInfo.class)) {
            report = new HedgeTaskReport();
        } else if (any.is(PMainTenance.CashPush.class)) {
            report = new CashPushReport();
        } else if (any.is(PBase.OpStatus.class)) {
            report = new OpStatusReport();
        } else if (any.is(PMainTenance.GetTransferFundReport.class)) {
            report = new TransferFundReport();
        } else if (any.is(PMainTenance.GetTransferPositionReport.class)) {
            report = new TransferPositionReport();
        } else if (any.is(PMainTenance.BankAccountReport.class)) {
            report = new BankAccountReport();
        } else if (any.is(PMainTenance.BankAccountFundReport.class)) {
            report = new BankAccountFundReport();
        } else if (any.is(PMainTenance.GetTransferBankAccountFundRecordReport.class)) {
            report = new BankAccountFandRecordReport();
        } else if (any.is(PUser.LogoutReq.class)) {
            report = new LogoutReport();
        } else if (any.is(PMainTenance.UserAuthenticateReport.class)) {
            report = new UserAuthenticateReport();
        } else if (any.is(PStrategy.ContextSettings.class)) {
            report = new FutureStrategyReport();
        } else if (any.is(PSecAccntService.SyncExtSecAccntsResp.class)) {
            report = new SyncExtSecAccntsResp();
        } else if (any.is(PMainTenance.ModifyPasswdReport.class)) {
            report = new ModifyPasswdReport();
        } else if (any.is(PRefData.MarketStatusReport.class)) {
            report = new MarketStatusReport();
        } else if (any.is(PResource.Resource.class)) {
            report = new ResourceReport();
        } else if (any.is(PFundAccntService.SyncExtFundAccntResp.class)) {
            report = new SynExtFundAccntResp();
        } else if (any.is(PAlgorithmTrade.AlgorithmStatusNotice.class)) {
            report = new AlgorithmStatusNoticeReport();
        } else if (any.is(PCcsRefdata.HKStockRefRate.class)) {
            report = new HkwolunRateReport();
        }
        if (report != null) {
            ((MxNotice)report).update(notice);
        }
        if (any.is(PMessage.ExecutionReport.class)) {
            logger.info(EXECUTION_REPORT);
        } else {
            logger.info("on push type :" + report);
        }
        return report;
    }
}

