/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.factory;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.CcsRepoPortfPosition;
import cms.tmx.entity.trade.CcsRepoPosition;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PositionFactory {
    private MxNode marketNode;
    private MxNode posiDirectionNode;
    private MxNode shFlagNode;
    private MxNode sideNode;
    @Inject
    protected MObjFactory of;

    @PostConstruct
    public void init() {
        this.marketNode = MxNodeFactory.create((String)"market_code", (String)"");
        this.posiDirectionNode = MxNodeFactory.create((String)"posi_direction", (String)"");
        this.shFlagNode = MxNodeFactory.create((String)"sh_flag", (String)"");
        this.sideNode = MxNodeFactory.create((String)"repo_side", (String)"");
    }

    public Position create(PPositionService.ExtPosition pPosition) {
        String market = pPosition.getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        Position item = this.create(marketGroup);
        if (item != null) {
            item.update((Object)pPosition);
        }
        return item;
    }

    public Position create(PPositionService.ExtPosition pPosition, String type) {
        String market = pPosition.getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        Position item = this.create(marketGroup, type);
        if (item != null) {
            item.update((Object)pPosition);
        }
        return item;
    }

    public CcsPortfPosition create(PPositionService.SubPosition pPosition) {
        CcsPortfPosition item = this.createCcsPortfolio();
        item.update((Object)pPosition);
        return item;
    }

    public CcsRepoPortfPosition createRepo(PPositionService.SubPosition pPosition) {
        CcsRepoPortfPosition item = this.createCcsrepoPortfolio();
        item.update((Object)pPosition);
        return item;
    }

    public Position create(String marketGroup) {
        Position item = null;
        if (marketGroup.equals("CCS")) {
            item = this.createCcs();
        } else if (marketGroup.equals("FUTURES")) {
            item = this.createCtp();
        }
        return item;
    }

    public Position create(String marketGroup, String type) {
        Position item = null;
        if (marketGroup.equals("CCS") && type.equals("REPO")) {
            item = this.createCcsRepo();
        }
        return item;
    }

    private Position createCcsRepo() {
        CcsRepoPosition item = new CcsRepoPosition();
        item.setMarket(this.marketNode.clone());
        item.setSide(this.sideNode.clone());
        return item;
    }

    public Position createCcs() {
        CcsPosition item = new CcsPosition();
        item.setMarket(this.marketNode.clone());
        return item;
    }

    private Position createCtp() {
        CtpPosition item = new CtpPosition();
        item.setMarket(this.marketNode.clone());
        item.setHedgeFlag(this.shFlagNode.clone());
        item.setPosiDirection(this.posiDirectionNode.clone());
        return item;
    }

    public CcsPortfPosition createCcsPortfolio() {
        CcsPortfPosition item = new CcsPortfPosition();
        item.setMarket(this.marketNode.clone());
        return item;
    }

    public CcsRepoPortfPosition createCcsrepoPortfolio() {
        CcsRepoPortfPosition item = new CcsRepoPortfPosition();
        item.setMarket(this.marketNode.clone());
        item.setSide(this.sideNode.clone());
        return item;
    }
}

