/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.factory;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.factory.InstrumentFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OrderFactory {
    private MxNode sideNode;
    private MxNode ordStatusNode;
    private MxNode legModeNode;
    private MxNode ocFlagNode;
    private MxNode shFlagNode;
    @Inject
    protected InstrumentFactory fInstrument;
    @Inject
    protected MObjFactory of;

    @PostConstruct
    public void init() {
        this.sideNode = MxNodeFactory.create((String)"side", (String)"");
        this.ordStatusNode = MxNodeFactory.create((String)"ord_status", (String)"");
        this.legModeNode = MxNodeFactory.create((String)"leg_mode", (String)"");
        this.ocFlagNode = MxNodeFactory.create((String)"oc_flag", (String)"");
        this.shFlagNode = MxNodeFactory.create((String)"sh_flag", (String)"");
    }

    public Order create(String marketGroup) {
        Order order = null;
        if (marketGroup.equals("CCS")) {
            order = this.createCcsOrder();
        } else if (marketGroup.equals("FUTURES")) {
            order = this.createCtpOrder();
        }
        return order;
    }

    public Order create(ExecutionReport pReport) {
        String market = pReport.getReport().getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        Order order = this.create(marketGroup);
        if (order != null) {
            order.update((Object)order);
        }
        return order;
    }

    public Order create(POrderService.SingleOrder pOrder) {
        String market = pOrder.getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        Order order = this.create(marketGroup);
        if (order != null) {
            order.update((Object)pOrder);
        }
        return order;
    }

    public Order create(PStrategy.SingleOrder pOrder) {
        String market = pOrder.getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        Order order = this.create(marketGroup);
        if (order != null) {
            order.update(pOrder);
        }
        return order;
    }

    public CcsOrder createCcsOrder() {
        CcsOrder item = new CcsOrder();
        item.setInstrument(this.fInstrument.create());
        item.setSide(this.sideNode.clone());
        item.setOrdStatus(this.ordStatusNode.clone());
        item.setLegMode(this.legModeNode.clone());
        return item;
    }

    public CtpOrder createCtpOrder() {
        CtpOrder item = new CtpOrder();
        item.setInstrument(this.fInstrument.create());
        item.setSide(this.sideNode.clone());
        item.setOrdStatus(this.ordStatusNode.clone());
        item.setOcFlag(this.ocFlagNode.clone());
        item.setShFlag(this.shFlagNode.clone());
        item.setLegMode(this.legModeNode.clone());
        return item;
    }
}

