/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.factory;

import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.MarginFundAccount;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FundAccountFactory {
    private MxNode nodeStatus;
    @Inject
    private MObjFactory of;

    @PostConstruct
    public void init() {
        this.nodeStatus = MxNodeFactory.create((String)"accnt_status", (String)"1");
    }

    public FundAccount createFundAccount(String marketGroup) {
        FundAccount acc = null;
        if (marketGroup.equals("CCS") || marketGroup.equals("OTC")) {
            acc = this.createCCS();
        } else if (marketGroup.equals("FUTURES")) {
            acc = this.createCTP();
        } else if (marketGroup.equals("IB")) {
            acc = this.createCFETS();
        } else if (marketGroup.equals("SGE")) {
            acc = this.createSge();
        }
        if (acc != null) {
            acc.setStatus(this.nodeStatus.clone());
        }
        return acc;
    }

    public FundAccount createMargin() {
        MarginFundAccount account = new MarginFundAccount();
        account.setStatus(this.nodeStatus.clone());
        return account;
    }

    public FundAccount createSge() {
        CtpFundAccount account = new CtpFundAccount();
        account.setStatus(this.nodeStatus.clone());
        return account;
    }

    public FundAccount createCCS() {
        CcsFundAccount account = new CcsFundAccount();
        return account;
    }

    public FundAccount createCTP() {
        CtpFundAccount account = new CtpFundAccount();
        return account;
    }

    public FundAccount createCFETS() {
        CfetsFundAccount account = new CfetsFundAccount();
        return account;
    }
}

