/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.factory;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.factory.InstrumentFactory;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsDealSum;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.CtpDealSum;
import cms.tmx.entity.trade.Deal;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DealFactory {
    private MxNode side;
    private MxNode market;
    private MxNode ocFlag;
    private MxNode shFlag;
    private MxNode dealType;
    @Inject
    protected MObjFactory of;
    @Inject
    protected InstrumentFactory insFactory;

    @PostConstruct
    public void init() {
        this.side = MxNodeFactory.create((String)"side", (String)"");
        this.market = MxNodeFactory.create((String)"market_code", (String)"");
        this.ocFlag = MxNodeFactory.create((String)"oc_flag", (String)"");
        this.shFlag = MxNodeFactory.create((String)"sh_flag", (String)"");
        this.dealType = MxNodeFactory.create((String)"deal_type", (String)"");
    }

    public Deal create(POrderService.Execution pDeal) {
        String marketGroup = MarketUtils.getMarketGroup((String)pDeal.getInstrument().getMarket());
        Deal deal = this.create(marketGroup);
        if (deal != null) {
            deal.update((Object)pDeal);
        }
        return deal;
    }

    public Deal create(PAssetService.ExecutionsCollect pDeal) {
        String marketGroup = MarketUtils.getMarketGroup((String)pDeal.getInstrument().getMarket());
        Deal deal = null;
        if (marketGroup.equals("CCS")) {
            CcsDealSum item = new CcsDealSum();
            item.setSide(this.side.clone());
            item.setMarket(this.market.clone());
            item.setInstrument(this.insFactory.create());
            deal = item;
        } else if (marketGroup.equals("FUTURES")) {
            CtpDealSum item = new CtpDealSum();
            item.setSide(this.side.clone());
            item.setMarket(this.market.clone());
            item.setOcFlag(this.ocFlag.clone());
            item.setShFlag(this.shFlag.clone());
            item.setInstrument(this.insFactory.create());
            deal = item;
        }
        if (deal != null) {
            deal.update((Object)pDeal);
        }
        return deal;
    }

    public Deal create(String marketGroup) {
        Deal deal = null;
        if (marketGroup.equals("CCS")) {
            deal = this.createCcs();
        } else if (marketGroup.equals("FUTURES")) {
            deal = this.createCtp();
        }
        return deal;
    }

    private CcsDeal createCcs() {
        CcsDeal item = new CcsDeal();
        item.setSide(this.side.clone());
        item.setMarket(this.market.clone());
        item.setInstrument(this.insFactory.create());
        return item;
    }

    private CtpDeal createCtp() {
        CtpDeal item = new CtpDeal();
        item.setSide(this.side.clone());
        item.setMarket(this.market.clone());
        item.setOcFlag(this.ocFlag.clone());
        item.setShFlag(this.shFlag.clone());
        item.setDealType(this.dealType.clone());
        item.setInstrument(this.insFactory.create());
        return item;
    }
}

