/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.http.api.marketdata.dto.MDEntry;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.javafx.obj.MxObject;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class XBondDealMarketItem
extends MxObject {
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty termToMaturityString = new SimpleStringProperty("");
    private StringProperty rating = new SimpleStringProperty("");
    private DoubleProperty nowPrice = new SimpleDoubleProperty();
    private DoubleProperty nowYield = new SimpleDoubleProperty();
    private DoubleProperty offset = new SimpleDoubleProperty();
    private LongProperty volume = new SimpleLongProperty();
    private DoubleProperty openPrice = new SimpleDoubleProperty();
    private DoubleProperty openYield = new SimpleDoubleProperty();
    private DoubleProperty highYield = new SimpleDoubleProperty();
    private DoubleProperty lowYield = new SimpleDoubleProperty();
    private DoubleProperty avgYield = new SimpleDoubleProperty();
    private DoubleProperty preAvgYield = new SimpleDoubleProperty();
    private DoubleProperty closeYield = new SimpleDoubleProperty();
    private StringProperty time = new SimpleStringProperty("");

    public XBondDealMarketItem() {
    }

    public XBondDealMarketItem(String market, String code) {
        this.setMarket(market);
        this.setCode(code);
    }

    public void update(Object obj) {
        if (obj instanceof XBondDealMarketItem) {
            this.update((XBondDealMarketItem)((Object)XBondDealMarketItem.class.cast(obj)));
        } else if (obj instanceof MarketDataSnapshot) {
            this.update((MarketDataSnapshot)MarketDataSnapshot.class.cast(obj));
        }
    }

    private void update(XBondDealMarketItem item) {
        this.setCode(item.getCode());
        this.setName(item.getName());
        this.setTermToMaturityString(item.getTermToMaturityString());
        this.setRating(item.getRating());
        this.setMarket(item.getMarket());
        this.setNowPrice(item.getNowPrice());
        this.setNowYield(item.getNowYield());
        this.setOffset(item.getOffset());
        this.setVolume(item.getVolume());
        this.setOpenPrice(item.getOpenPrice());
        this.setOpenYield(item.getOpenYield());
        this.setHighYield(item.getHighYield());
        this.setLowYield(item.getLowYield());
        this.setAvgYield(item.getAvgYield());
        this.setPreAvgYield(item.getPreAvgYield());
        this.setCloseYield(item.getCloseYield());
        this.setTime(item.getTime());
    }

    private void update(MarketDataSnapshot data) {
        List entries;
        if (data.getTransactTime() != null) {
            int index = data.getTransactTime().indexOf("-");
            this.setTime(data.getTransactTime().substring(index));
        }
        if (data.getPriceUnit() != null) {
            this.setVolume(data.getPriceUnit().getVolume() / 100000000L);
        }
        if ((entries = data.getEntry()) == null) {
            return;
        }
        for (MDEntry entry : entries) {
            switch (entry.getMdEntryType()) {
                case 2: {
                    this.setNowPrice(entry.getMdEntryPx());
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setNowYield((double)Math.round(yield * 10000.0) / 10000.0);
                    break;
                }
                case 4: {
                    this.setOpenPrice(entry.getMdEntryPx());
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setOpenYield((double)Math.round(yield * 10000.0) / 10000.0);
                    break;
                }
                case 5: {
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setCloseYield((double)Math.round(yield * 10000.0) / 10000.0);
                    break;
                }
                case 7: {
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setLowYield((double)Math.round(yield * 10000.0) / 10000.0);
                    break;
                }
                case 8: {
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setHighYield((double)Math.round(yield * 10000.0) / 10000.0);
                    break;
                }
                case 9: {
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setAvgYield((double)Math.round(yield * 10000.0) / 10000.0);
                    break;
                }
                case 10: {
                    if (entry.getYieldData() == null) break;
                    double yield = entry.getYieldData().getYield() * 100.0;
                    this.setPreAvgYield((double)Math.round(yield * 10000.0) / 10000.0);
                }
            }
        }
        double offset = (this.getNowYield() - this.getCloseYield()) * 100.0;
        this.setOffset((double)Math.round(offset * 100.0) / 100.0);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getCode() == null ? 0 : this.getCode().hashCode());
        result = 31 * result + (this.getMarket() == null ? 0 : this.getMarket().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XBondDealMarketItem other = (XBondDealMarketItem)((Object)obj);
        if (this.getCode() == null ? other.getCode() != null : !this.getCode().equals(other.getCode())) {
            return false;
        }
        return !(this.getMarket() == null ? other.getMarket() != null : !this.getMarket().equals(other.getMarket()));
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public final double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public final void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public final DoubleProperty nowYieldProperty() {
        return this.nowYield;
    }

    public final double getNowYield() {
        return this.nowYieldProperty().get();
    }

    public final void setNowYield(double nowYield) {
        this.nowYieldProperty().set(nowYield);
    }

    public final DoubleProperty offsetProperty() {
        return this.offset;
    }

    public final double getOffset() {
        return this.offsetProperty().get();
    }

    public final void setOffset(double offset) {
        this.offsetProperty().set(offset);
    }

    public final LongProperty volumeProperty() {
        return this.volume;
    }

    public final long getVolume() {
        return this.volumeProperty().get();
    }

    public final void setVolume(long volume) {
        this.volumeProperty().set(volume);
    }

    public final DoubleProperty openPriceProperty() {
        return this.openPrice;
    }

    public final double getOpenPrice() {
        return this.openPriceProperty().get();
    }

    public final void setOpenPrice(double openPrice) {
        this.openPriceProperty().set(openPrice);
    }

    public final DoubleProperty openYieldProperty() {
        return this.openYield;
    }

    public final double getOpenYield() {
        return this.openYieldProperty().get();
    }

    public final void setOpenYield(double openYield) {
        this.openYieldProperty().set(openYield);
    }

    public final DoubleProperty highYieldProperty() {
        return this.highYield;
    }

    public final double getHighYield() {
        return this.highYieldProperty().get();
    }

    public final void setHighYield(double highYield) {
        this.highYieldProperty().set(highYield);
    }

    public final DoubleProperty lowYieldProperty() {
        return this.lowYield;
    }

    public final double getLowYield() {
        return this.lowYieldProperty().get();
    }

    public final void setLowYield(double lowYield) {
        this.lowYieldProperty().set(lowYield);
    }

    public final DoubleProperty avgYieldProperty() {
        return this.avgYield;
    }

    public final double getAvgYield() {
        return this.avgYieldProperty().get();
    }

    public final void setAvgYield(double avgYield) {
        this.avgYieldProperty().set(avgYield);
    }

    public final DoubleProperty preAvgYieldProperty() {
        return this.preAvgYield;
    }

    public final double getPreAvgYield() {
        return this.preAvgYieldProperty().get();
    }

    public final void setPreAvgYield(double preAvgYield) {
        this.preAvgYieldProperty().set(preAvgYield);
    }

    public final DoubleProperty closeYieldProperty() {
        return this.closeYield;
    }

    public final double getCloseYield() {
        return this.closeYieldProperty().get();
    }

    public final void setCloseYield(double closeYield) {
        this.closeYieldProperty().set(closeYield);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty termToMaturityStringProperty() {
        return this.termToMaturityString;
    }

    public final String getTermToMaturityString() {
        return (String)this.termToMaturityStringProperty().get();
    }

    public final void setTermToMaturityString(String termToMaturityString) {
        this.termToMaturityStringProperty().set((Object)termToMaturityString);
    }

    public final StringProperty ratingProperty() {
        return this.rating;
    }

    public final String getRating() {
        return (String)this.ratingProperty().get();
    }

    public final void setRating(String rating) {
        this.ratingProperty().set((Object)rating);
    }
}

