/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PCfetsRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.Status;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.http.security.dto.ForwardInfo;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.LinkedList;
import java.util.List;

public class StdBondForward
extends RefItem {
    private String status;
    private List<StdBondForwardDeliver> delivers = new LinkedList<StdBondForwardDeliver>();

    @Override
    public void update(Object obj) {
        super.update(obj);
        if (obj instanceof PRefData.SecListItem) {
            try {
                this.update((PRefData.SecListItem)PRefData.SecListItem.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error((Object)e);
            }
        } else if (obj instanceof StdBondForward) {
            this.update((StdBondForward)((Object)StdBondForward.class.cast(obj)));
        } else if (obj instanceof ForwardInfo) {
            this.update((ForwardInfo)ForwardInfo.class.cast(obj));
        }
    }

    private void update(PRefData.SecListItem item) throws InvalidProtocolBufferException {
        Any any = item.getObject();
        if (any.is(PCfetsRefdata.StdBondForward.class)) {
            PCfetsRefdata.StdBondForward sec = (PCfetsRefdata.StdBondForward)any.unpack(PCfetsRefdata.StdBondForward.class);
            this.setStatus(sec.getStatus());
            this.setMarket(sec.getMarket());
            this.setSpellCode(this.getCode());
            this.setScale(3);
        }
    }

    private void update(ForwardInfo info) {
        List list;
        if (info.getSecStat() != null) {
            this.setStatus(Status.getDesc(info.getSecStat().getTradingStatus()));
        }
        this.setSpellCode(this.getCode());
        if (info.getParams() != null && (list = info.getParams().getDeliver()) != null) {
            this.delivers.clear();
            list.forEach(fDeliver -> {
                StdBondForwardDeliver deliver = new StdBondForwardDeliver();
                deliver.update(fDeliver.getLeg());
                deliver.setSecurityClass(info.getInstrument().getSecurityId());
                deliver.setActive(fDeliver.isActiveFlag() ? 1 : 0);
                this.setMarket(info.getInstrument().getMarket());
                this.delivers.add(deliver);
            });
        }
    }

    private void update(StdBondForward deliver) {
        this.setStatus(deliver.getStatus());
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public List<StdBondForwardDeliver> getDelivers() {
        return this.delivers;
    }

    public void setDelivers(List<StdBondForwardDeliver> delivers) {
        this.delivers = delivers;
    }
}

