/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.utils.MarketUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SgeRefItem
extends MxChgObj {
    protected static final Logger logger = LogManager.getLogger(SgeRefItem.class);
    private StringProperty currency = new SimpleStringProperty("");
    private StringProperty deliveryMethod = new SimpleStringProperty("");
    private StringProperty deliveryVarity = new SimpleStringProperty("");
    private DoubleProperty maxOrderAmt = new SimpleDoubleProperty();
    private DoubleProperty minOrderAmt = new SimpleDoubleProperty();
    private DoubleProperty priceTick = new SimpleDoubleProperty();
    private DoubleProperty tradeUnit = new SimpleDoubleProperty();
    private StringProperty quoteUnit = new SimpleStringProperty("");
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty symbol = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private DoubleProperty highLimitPx = new SimpleDoubleProperty();
    private DoubleProperty lowLimitPx = new SimpleDoubleProperty();
    private String code;
    private String name;
    private double limitUpPrice;
    private double limitDownPrice;

    public void update(Object obj) {
        if (obj instanceof RefItem) {
            RefItem item = (RefItem)((Object)RefItem.class.cast(obj));
            this.update(item);
        } else if (obj instanceof SgeRefItem) {
            SgeRefItem item = (SgeRefItem)((Object)SgeRefItem.class.cast(obj));
            this.update(item);
        }
    }

    public void update(RefItem item) {
        this.setSecurityId(item.getCode());
        this.setSymbol(item.getName());
        this.setMarket(MarketUtils.getMarketNameById((String)item.getMarket()));
        this.setCurrency(this.getCurrencyName(item.getCurrency()));
        this.setDeliveryMethod(item.getDeliveryMethod());
        this.setDeliveryVarity(item.getDeliveryVarity());
        this.setMaxOrderAmt(item.getMaxOrderAmt());
        this.setMinOrderAmt(item.getMinOrderAmt());
        this.setPriceTick(item.getPriceTick());
        this.setQuoteUnit(item.getQuoteUnit());
        this.setTradeUnit(item.getTradeUnit());
        this.setHighLimitPx(item.getLimitUpPrice());
        this.setLowLimitPx(item.getLimitDownPrice());
        this.setLimitUpPrice(item.getLimitUpPrice());
        this.setLimitDownPrice(item.getLimitDownPrice());
        this.setCode(item.getCode());
        this.setName(item.getName());
    }

    private String getCurrencyName(String curr) {
        if (curr != null && curr.equals("CNY")) {
            return "\u4eba\u6c11\u5e01";
        }
        return curr;
    }

    public void update(SgeRefItem item) {
        this.setSecurityId(item.getSecurityId());
        this.setSymbol(item.getSymbol());
        this.setMarket(item.getMarket());
        this.setCurrency(item.getCurrency());
        this.setDeliveryMethod(item.getDeliveryMethod());
        this.setDeliveryVarity(item.getDeliveryVarity());
        this.setMaxOrderAmt(item.getMaxOrderAmt());
        this.setMinOrderAmt(item.getMinOrderAmt());
        this.setPriceTick(item.getPriceTick());
        this.setQuoteUnit(item.getQuoteUnit());
        this.setTradeUnit(item.getTradeUnit());
        this.setHighLimitPx(item.getHighLimitPx());
        this.setLowLimitPx(item.getLowLimitPx());
        this.setCode(item.getSecurityId());
        this.setName(item.getSymbol());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getSecurityId().hashCode();
        result = 31 * result + this.getMarket().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SgeRefItem other = (SgeRefItem)((Object)SgeRefItem.class.cast(obj));
        return other.getMarket().equals(this.getMarket()) && other.getSecurityId().equals(this.getSecurityId());
    }

    public final StringProperty currencyProperty() {
        return this.currency;
    }

    public final String getCurrency() {
        return (String)this.currencyProperty().get();
    }

    public final void setCurrency(String currency) {
        this.currencyProperty().set((Object)currency);
    }

    public final StringProperty deliveryMethodProperty() {
        return this.deliveryMethod;
    }

    public final String getDeliveryMethod() {
        return (String)this.deliveryMethodProperty().get();
    }

    public final void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethodProperty().set((Object)deliveryMethod);
    }

    public final StringProperty deliveryVarityProperty() {
        return this.deliveryVarity;
    }

    public final String getDeliveryVarity() {
        return (String)this.deliveryVarityProperty().get();
    }

    public final void setDeliveryVarity(String deliveryVarity) {
        this.deliveryVarityProperty().set((Object)deliveryVarity);
    }

    public final DoubleProperty maxOrderAmtProperty() {
        return this.maxOrderAmt;
    }

    public final double getMaxOrderAmt() {
        return this.maxOrderAmtProperty().get();
    }

    public final void setMaxOrderAmt(double maxOrderAmt) {
        this.maxOrderAmtProperty().set(maxOrderAmt);
    }

    public final DoubleProperty minOrderAmtProperty() {
        return this.minOrderAmt;
    }

    public final double getMinOrderAmt() {
        return this.minOrderAmtProperty().get();
    }

    public final void setMinOrderAmt(double minOrderAmt) {
        this.minOrderAmtProperty().set(minOrderAmt);
    }

    public final DoubleProperty priceTickProperty() {
        return this.priceTick;
    }

    public final double getPriceTick() {
        return this.priceTickProperty().get();
    }

    public final void setPriceTick(double priceTick) {
        this.priceTickProperty().set(priceTick);
    }

    public final DoubleProperty tradeUnitProperty() {
        return this.tradeUnit;
    }

    public final Double getTradeUnit() {
        return this.tradeUnitProperty().get();
    }

    public final void setTradeUnit(Double tradeUnit) {
        this.tradeUnitProperty().set(tradeUnit.doubleValue());
    }

    public final StringProperty quoteUnitProperty() {
        return this.quoteUnit;
    }

    public final String getQuoteUnit() {
        return (String)this.quoteUnitProperty().get();
    }

    public final void setQuoteUnit(String quoteUnit) {
        this.quoteUnitProperty().set((Object)quoteUnit);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty symbolProperty() {
        return this.symbol;
    }

    public final String getSymbol() {
        return (String)this.symbolProperty().get();
    }

    public final void setSymbol(String symbol) {
        this.symbolProperty().set((Object)symbol);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final DoubleProperty highLimitPxProperty() {
        return this.highLimitPx;
    }

    public final double getHighLimitPx() {
        return this.highLimitPxProperty().get();
    }

    public final void setHighLimitPx(double highLimitPx) {
        this.highLimitPxProperty().set(highLimitPx);
    }

    public final DoubleProperty lowLimitPxProperty() {
        return this.lowLimitPx;
    }

    public final double getLowLimitPx() {
        return this.lowLimitPxProperty().get();
    }

    public final void setLowLimitPx(double lowLimitPx) {
        this.lowLimitPxProperty().set(lowLimitPx);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLimitUpPrice() {
        return this.limitUpPrice;
    }

    public void setLimitUpPrice(double limitUpPrice) {
        this.limitUpPrice = limitUpPrice;
    }

    public double getLimitDownPrice() {
        return this.limitDownPrice;
    }

    public void setLimitDownPrice(double limitDownPrice) {
        this.limitDownPrice = limitDownPrice;
    }
}

