/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.security.dto.RepoInfo;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepoRefItem
extends RefItem {
    private String stdSecId = "";
    private long expireDay;
    private static final Logger logger = LogManager.getLogger(RepoRefItem.class);

    @Override
    public void update(Object obj) {
        super.update(obj);
        if (obj instanceof PRefData.SecListItem) {
            try {
                this.update((PRefData.SecListItem)PRefData.SecListItem.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error((Object)e);
            }
        } else if (obj instanceof RepoRefItem) {
            RepoRefItem repo = (RepoRefItem)((Object)RepoRefItem.class.cast(obj));
            this.update(repo);
        } else if (obj instanceof RepoInfo) {
            this.update((RepoInfo)RepoInfo.class.cast(obj));
        }
    }

    private void update(PRefData.SecListItem item) throws InvalidProtocolBufferException {
        Any any = item.getObject();
        if (any.is(PCcsRefdata.RefDataExtraRepo.class)) {
            PCcsRefdata.RefDataExtraRepo sec = (PCcsRefdata.RefDataExtraRepo)any.unpack(PCcsRefdata.RefDataExtraRepo.class);
            if (!StringUtils.isEmpty((String)sec.getStdSecId())) {
                this.setStdSecId(sec.getStdSecId());
            } else if ("XSHE".equals(this.getMarket())) {
                this.setStdSecId("131990");
            } else if ("XSHG".equals(this.getMarket())) {
                this.setStdSecId("888880");
            }
        }
    }

    private void update(RepoInfo info) {
        if (info.getSecurity().getUnderlying() != null) {
            this.setStdSecId(info.getSecurity().getUnderlying().getSecurityId());
        }
        if (info.getParams() != null) {
            this.setExpireDay(info.getParams().getExpireDay());
        }
    }

    private void update(RepoRefItem repo) {
        this.setStdSecId(repo.getStdSecId());
    }

    public String getStdSecId() {
        return this.stdSecId;
    }

    public void setStdSecId(String stdSecId) {
        this.stdSecId = stdSecId;
    }

    public long getExpireDay() {
        return this.expireDay;
    }

    public void setExpireDay(long expireDay) {
        this.expireDay = expireDay;
    }
}

