/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.api.data.IRefItem;
import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PCtpRefdata;
import cms.tmx.datatype.message.PMarketData;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.define.BsDict;
import cms.tmx.entity.data.StoreRefItem;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.data.FundInfo;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.data.SecItem;
import cms.tmx.http.security.dto.BondInfo;
import cms.tmx.http.security.dto.ForwardInfo;
import cms.tmx.http.security.dto.FutureInfo;
import cms.tmx.http.security.dto.FutureParams;
import cms.tmx.http.security.dto.RepoInfo;
import cms.tmx.http.security.dto.SecStatus;
import cms.tmx.http.security.dto.Security;
import cms.tmx.http.security.dto.StockInfo;
import cms.tmx.http.security.dto.XBondInfo;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RefItem
extends MxChgObj
implements IRefItem {
    protected static final Logger logger = LogManager.getLogger(RefItem.class);
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private String market = "";
    private String type = "";
    private String subSecurityType = "";
    private String spellCode = "";
    private double issPrice;
    private String transferMethod = "";
    private String transferMethodCode = "";
    private String levelInfo = "";
    private String listSector = "";
    private DoubleProperty priceUnit = new SimpleDoubleProperty();
    private IntegerProperty scale = new SimpleIntegerProperty();
    private int buyUnit = 1;
    private int sellUnit = 1;
    private long totalCapitalStock = 0L;
    private double limitUpPrice;
    private double limitDownPrice;
    private int marketMakerCount;
    private String otherBusiness;
    private int noProfit;
    private int weightedVotingRights;
    private int isRegistration;
    private int isVIE;
    private String status;
    private String listFlag = "";
    private String investedTarget = "";
    public static final String START_STATUS = "\u4e0a\u5e02\u521d\u671f";
    public static final String START_STATUS_TWO = "\u4e0a\u5e02\u9996\u65e5";
    public static final String UN_LISTED = "unlisted";
    private double limitUpRate = 47.0;
    private double limitDownRate = 48.0;
    private String conId = "";
    private static String bidRate = "";
    private static String askRate = "";
    private static double mediumRate = 0.0;
    private boolean stopFlag = false;
    private boolean neeqQuery = true;
    private boolean isDelayedDelivery;
    private String currency;
    private String deliveryMethod;
    private String deliveryVarity;
    private String quoteUnit;
    private double tradeUnit;
    private double maxOrderAmt;
    private double minOrderAmt;
    private double priceTick;

    public void update(Object obj) {
        if (obj instanceof PRefData.SecListItem) {
            try {
                this.update((PRefData.SecListItem)PRefData.SecListItem.class.cast(obj));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error((Object)e);
            }
        } else if (obj instanceof RefItem) {
            this.update((RefItem)((Object)RefItem.class.cast(obj)));
        } else if (obj instanceof StoreRefItem) {
            this.update((StoreRefItem)StoreRefItem.class.cast(obj));
        } else if (obj instanceof FundInfo) {
            this.update((FundInfo)FundInfo.class.cast(obj));
        } else if (obj instanceof StockInfo) {
            this.update((StockInfo)StockInfo.class.cast(obj));
        } else if (obj instanceof SecItem) {
            this.update((SecItem)SecItem.class.cast(obj));
        } else if (obj instanceof Security) {
            this.update((Security)Security.class.cast(obj));
        } else if (obj instanceof Instrument) {
            this.update((Instrument)Instrument.class.cast(obj));
        } else if (obj instanceof BondInfo) {
            this.update((BondInfo)BondInfo.class.cast(obj));
        } else if (obj instanceof IssueInfo) {
            this.update((IssueInfo)IssueInfo.class.cast(obj));
        } else if (obj instanceof RepoInfo) {
            this.update((RepoInfo)RepoInfo.class.cast(obj));
        } else if (obj instanceof FutureInfo) {
            this.update((FutureInfo)FutureInfo.class.cast(obj));
        } else if (obj instanceof XBondInfo) {
            this.update((XBondInfo)XBondInfo.class.cast(obj));
        } else if (obj instanceof ForwardInfo) {
            this.update((ForwardInfo)ForwardInfo.class.cast(obj));
        }
    }

    private void update(Instrument inst) {
        this.setType(inst.getSecurityType());
        this.setSubSecurityType(inst.getSecuritySubType());
        this.setMarket(inst.getMarket());
        this.setCode(inst.getSecurityId());
        this.setName(inst.getSymbol());
    }

    private void update(Security security) {
        if (security != null) {
            this.setMarket(security.getInstrument().getMarket());
            this.setCode(security.getInstrument().getSecurityId());
            this.setName(StringUtils.isEmpty((String)security.getShortName()) ? security.getInstrument().getSymbol() : security.getShortName());
            this.setType(security.getInstrument().getSecurityType());
            if ("NEEQ".equals(security.getInstrument().getMarket()) && SecItem.STOCK_SEC_SUB_TYPE_MAP.containsKey(security.getInstrument().getSecuritySubType())) {
                this.setSubSecurityType((String)SecItem.STOCK_SEC_SUB_TYPE_MAP.get(security.getInstrument().getSecuritySubType()));
            } else {
                this.setSubSecurityType(security.getInstrument().getSecuritySubType());
            }
            this.setListSector(security.getListingSector());
            if (security.getSpellShortName() != null) {
                this.setSpellCode(security.getSpellShortName());
            }
        }
    }

    private void update(FutureParams para) {
        if (para != null) {
            this.setDelayedDelivery(para.getIsDeferred() == 1);
            this.setDeliveryMethod(para.getDeliveryMonth());
            this.setDeliveryVarity(para.getDeliveryVarity());
            this.setCurrency(para.getCurrency());
            this.setMaxOrderAmt(para.getMaxOrderAmt());
            this.setMinOrderAmt(para.getMinOrderAmt());
            this.setPriceTick(para.getPriceTick());
            this.setQuoteUnit(para.getQuoteUnit());
            this.setTradeUnit(Double.valueOf("".equals(para.getTradeUnit()) || para.getTradeUnit() == null ? "0" : para.getTradeUnit()));
        }
    }

    private void update(SecStatus secStatus) {
        if (secStatus != null) {
            this.setLimitUpRate(secStatus.getIncreaseRate());
            this.setLimitDownRate(secStatus.getDecreaseRate());
            if (secStatus.getPxDefs() != null) {
                this.setPriceUnit(secStatus.getPxDefs().getUnit());
            }
            if (secStatus.getQtyDefs() != null) {
                this.setBuyUnit(Double.valueOf(secStatus.getQtyDefs().getUnit()).intValue());
            }
            this.setSellUnit(1);
            if (secStatus.getPxLimits() != null) {
                this.setLimitUpPrice(secStatus.getPxLimits().getHighLimitPx());
                this.setLimitDownPrice(secStatus.getPxLimits().getLowLimitPx());
            }
        }
        this.setScale(DecimalUtils.getScale((double)this.getPriceUnit()));
        this.checkUnit();
    }

    private void update(StockInfo info) {
        this.update(info.getSecurity());
        this.update(info.getSecStat());
        if (info.getParams() != null) {
            this.setMarketMakerCount(info.getParams().getMarketMakerCount());
            String otherBusiness = info.getParams().getOtherBusiness();
            if (!StringUtils.isEmpty((String)otherBusiness) && otherBusiness.substring(1).startsWith("T")) {
                this.setOtherBusiness("W");
            }
            this.setIssPrice(info.getParams().getIssuePrice());
            this.setListFlag(info.getParams().getListFlag());
            this.setNoProfit(info.getParams().isNoProfit() ? 1 : 0);
            this.setIsRegistration(info.getParams().isRegistration() ? 1 : 0);
            this.setIsVIE(info.getParams().isVie() ? 1 : 0);
            this.setWeightedVotingRights(info.getParams().isWeightedVotingRights() ? 1 : 0);
        }
        if (info.getStockStat() != null) {
            this.setTotalCapitalStock((long)info.getStockStat().getTotalStock());
            this.setStatus(info.getStockStat().getTradeStatus());
            this.setTransferMethodCode(info.getStockStat().getTransferMethod());
            this.setTransferMethod(MatchType.getDes((String)info.getStockStat().getTransferMethod()));
            String li = info.getStockStat().getLevelInfo();
            this.setLevelInfo(BsDict.NEEQ_LEVEL_INFO.containsKey(li) ? (String)BsDict.NEEQ_LEVEL_INFO.get(li) : li);
            this.setStopFlag(info.getStockStat().getStopFlag());
        }
    }

    private void update(FundInfo info) {
        this.update(info.getSecurity());
        this.update(info.getSecStat());
    }

    private void update(BondInfo info) {
        this.update(info.getSecurity());
        this.update(info.getSecStat());
    }

    private void update(XBondInfo info) {
        this.update(info.getInstrument());
    }

    private void update(ForwardInfo info) {
        this.update(info.getInstrument());
    }

    private void update(IssueInfo info) {
        this.update(info.getSecurity());
        if (info.getParams() != null) {
            this.setNoProfit(info.getParams().isNoProfit() ? 1 : 0);
            this.setIsRegistration(info.getParams().isRegistration() ? 1 : 0);
            this.setIsVIE(info.getParams().isVie() ? 1 : 0);
            this.setWeightedVotingRights(info.getParams().isWeightedVotingRights() ? 1 : 0);
            this.setBuyUnit(new Double(info.getParams().getTradeUnit()).intValue());
            this.setSellUnit(new Double(info.getParams().getTradeUnit()).intValue());
        }
        this.setPriceUnit(0.01);
        this.setScale(DecimalUtils.getScale((double)this.getPriceUnit()));
        this.checkUnit();
    }

    private void update(RepoInfo info) {
        this.update(info.getSecurity());
        this.update(info.getSecStat());
        if (info.getSecStat() != null && info.getSecStat().getQtyDefs() != null) {
            this.setSellUnit(Double.valueOf(info.getSecStat().getQtyDefs().getUnit()).intValue());
        }
    }

    private void update(FutureInfo info) {
        this.setPriceUnit(info.getParams().getPriceTick());
        this.update(info.getSecurity());
        this.update(info.getSecStat());
        this.update(info.getParams());
        this.setSpellCode(this.getCode());
    }

    private void update(SecItem info) {
        this.setCode(info.getSecurityId());
        this.setName(info.getSecurityName());
        this.setMarket((String)SecItem.MARKET_MAP.get(String.valueOf(info.getMic())));
        this.setType((String)SecItem.SEC_TYPE_MAP.get(String.valueOf(info.getSecType())));
        this.setSubSecurityType((String)SecItem.SEC_SUB_TYPE_MAP.get(String.valueOf(info.getSecSubType())));
        if (info.getPxDefs() != null) {
            this.setPriceUnit(info.getPxDefs().getUnit());
            this.setScale(DecimalUtils.getScale((double)this.getPriceUnit()));
        }
        if (info.getQtyDefs() != null) {
            this.setBuyUnit(info.getQtyDefs().getUnit());
            this.setSellUnit(info.getQtyDefs().getUnit());
        }
        if (info.getFlags() > 0L) {
            int transferMethod = (int)info.getFlags();
            int level = (int)(info.getFlags() >> 32);
            this.setLevelInfo(SecItem.LEVEL_INFO_MAP.get(String.valueOf(level)) == null ? "" : (String)SecItem.LEVEL_INFO_MAP.get(String.valueOf(level)));
            this.setTransferMethodCode((String)SecItem.TRANSFER_METHOD_MAP.get(String.valueOf(transferMethod)));
            this.setTransferMethod(MatchType.getDes((String)this.getTransferMethodCode()));
        }
        if (info.getPxLimits() != null) {
            this.setLimitUpPrice(info.getPxLimits().getHighLimitPx());
            this.setLimitDownPrice(info.getPxLimits().getLowLimitPx());
        }
    }

    private void update(StoreRefItem storeItem) {
        this.setCode(storeItem.getCode());
        this.setMarket(storeItem.getMarket());
        this.setType(storeItem.getSecType());
    }

    private void update(PRefData.SecListItem item) throws InvalidProtocolBufferException {
        this.setMarket(item.getInstrument().getMarket());
        this.setCode(item.getInstrument().getSecurityId());
        this.setName(item.getInstrument().getSymbol());
        this.setType(item.getInstrument().getSecurityType());
        this.setSubSecurityType(item.getInstrument().getSecuritySubType());
        Any any = item.getObject();
        if (any.is(PCcsRefdata.RefDataExtraBond.class)) {
            PCcsRefdata.RefDataExtraBond sec = (PCcsRefdata.RefDataExtraBond)any.unpack(PCcsRefdata.RefDataExtraBond.class);
            this.setPriceUnit(sec.getPriceUnit());
            this.setBuyUnit(new Double(sec.getBuyUnit()).intValue());
            this.setSellUnit(new Double(sec.getSellUnit()).intValue());
            this.setSpellCode(sec.getSpellCode());
        } else if (any.is(PCcsRefdata.RefDataExtraFund.class)) {
            PCcsRefdata.RefDataExtraFund sec = (PCcsRefdata.RefDataExtraFund)any.unpack(PCcsRefdata.RefDataExtraFund.class);
            this.setPriceUnit(sec.getPriceUnit());
            this.setBuyUnit(new Double(sec.getBuyUnit()).intValue());
            this.setSellUnit(new Double(sec.getSellUnit()).intValue());
            this.setSpellCode(sec.getSpellCode());
            this.setLimitUpRate(sec.getLimitUpRate());
            this.setLimitDownRate(sec.getLimitDownRate());
            this.setInvestedTarget(sec.getInvestedTarget());
        } else if (any.is(PCcsRefdata.RefDataExtraStock.class)) {
            PCcsRefdata.RefDataExtraStock sec = (PCcsRefdata.RefDataExtraStock)any.unpack(PCcsRefdata.RefDataExtraStock.class);
            this.setPriceUnit(sec.getPriceUnit());
            this.setBuyUnit(new Double(sec.getBuyUnit()).intValue());
            this.setSellUnit(new Double(sec.getSellUnit()).intValue());
            this.setSpellCode(sec.getSpellCode());
            this.setIssPrice(sec.getIssPrc());
            this.setTotalCapitalStock((long)sec.getTotalCapitalStock());
            this.setListSector(sec.getListSector());
            this.setNoProfit(sec.getNoProfit());
            this.setWeightedVotingRights(sec.getWeightedVotingRights());
            this.setIsVIE(sec.getIsVIE());
            this.setIsRegistration(sec.getIsRegistration());
            this.setStatus(sec.getStatus());
            this.setLimitUpRate(sec.getLimitUpRate());
            this.setLimitDownRate(sec.getLimitDownRate());
            this.setListFlag(sec.getListFlag());
        } else if (any.is(PCtpRefdata.RefDataExtraCTP.class)) {
            PCtpRefdata.RefDataExtraCTP ctp = (PCtpRefdata.RefDataExtraCTP)any.unpack(PCtpRefdata.RefDataExtraCTP.class);
            this.setPriceUnit(ctp.getPriceTick());
            this.setSpellCode(this.getCode());
        } else if (any.is(PCcsRefdata.IssueInfo.class)) {
            PCcsRefdata.IssueInfo sec = (PCcsRefdata.IssueInfo)any.unpack(PCcsRefdata.IssueInfo.class);
            this.setPriceUnit(0.01);
            this.setBuyUnit(new Double(sec.getTradeUnit()).intValue());
            this.setSellUnit(new Double(sec.getTradeUnit()).intValue());
            this.setNoProfit(sec.getNoProfit());
            this.setWeightedVotingRights(sec.getWeightedVotingRights());
            this.setIsVIE(sec.getIsVIE());
            this.setIsRegistration(sec.getIsRegistration());
        } else if (any.is(PCcsRefdata.RefDataExtraRepo.class)) {
            PCcsRefdata.RefDataExtraRepo sec = (PCcsRefdata.RefDataExtraRepo)any.unpack(PCcsRefdata.RefDataExtraRepo.class);
            this.setPriceUnit(sec.getPriceUnit());
            this.setBuyUnit(new Double(sec.getBuyUnit()).intValue());
            this.setSellUnit(new Double(sec.getSellUnit()).intValue());
        }
        this.setScale(DecimalUtils.getScale((double)this.getPriceUnit()));
        this.checkUnit();
    }

    public static void updateRate(PRefData.SecurityList list) throws InvalidProtocolBufferException {
        Any any = list.getObject();
        if (any.is(PCcsRefdata.HKStockRefRate.class)) {
            PCcsRefdata.HKStockRefRate rate = (PCcsRefdata.HKStockRefRate)any.unpack(PCcsRefdata.HKStockRefRate.class);
            RefItem.updateRate(rate);
        }
    }

    public static void updateRate(PCcsRefdata.HKStockRefRate rate) {
        RefItem.setBidRate(StringUtils.toThousands((String)String.valueOf(rate.getBidRefRate()), (int)4));
        RefItem.setAskRate(StringUtils.toThousands((String)String.valueOf(rate.getAskRefRate()), (int)4));
        RefItem.setMediumRate(RefItem.formatScale((rate.getBidRefRate() + rate.getAskRefRate()) / 2.0, 4));
    }

    public static void updateQuota(PMarketData.MarketDataSnapshot snap) throws InvalidProtocolBufferException {
        snap.getMrkStatusData().getThresholdAmt();
    }

    private static double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    private void checkUnit() {
        if (this.getBuyUnit() <= 0) {
            this.setBuyUnit(1);
        }
        if (this.getSellUnit() <= 0) {
            this.setSellUnit(1);
        }
    }

    private void update(RefItem item) {
        this.setMarket(item.getMarket());
        this.setCode(item.getCode());
        this.setConId(item.getCode());
        this.setName(item.getName());
        this.setType(item.getType());
        this.setPriceUnit(item.getPriceUnit());
        this.setBuyUnit(item.getBuyUnit());
        this.setSellUnit(item.getSellUnit());
        this.setScale(item.getScale());
        this.setIssPrice(item.getIssPrice());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getCode().hashCode();
        result = 31 * result + this.getMarket().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RefItem other = (RefItem)((Object)RefItem.class.cast(obj));
        return other.getMarket().equals(this.getMarket()) && other.getCode().equals(this.getCode());
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.codeProperty().get();
    }

    public void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DoubleProperty priceUnitProperty() {
        return this.priceUnit;
    }

    public double getPriceUnit() {
        return this.priceUnitProperty().get();
    }

    public void setPriceUnit(double priceUnit) {
        this.priceUnitProperty().set(priceUnit);
    }

    public final int getBuyUnit() {
        return this.buyUnit;
    }

    public final void setBuyUnit(int buyUnit) {
        this.buyUnit = buyUnit;
    }

    public final int getSellUnit() {
        return this.sellUnit;
    }

    public final void setSellUnit(int sellUnit) {
        this.sellUnit = sellUnit;
    }

    public String toString() {
        return (String)this.code.get();
    }

    public IntegerProperty scaleProperty() {
        return this.scale;
    }

    public int getScale() {
        return this.scaleProperty().get();
    }

    public void setScale(int scale) {
        this.scaleProperty().set(scale);
    }

    public final String getSpellCode() {
        return this.spellCode;
    }

    public final void setSpellCode(String spellCode) {
        this.spellCode = spellCode;
    }

    public double getIssPrice() {
        return this.issPrice;
    }

    public void setIssPrice(double issPrice) {
        this.issPrice = issPrice;
    }

    public String getTransferMethod() {
        return this.transferMethod;
    }

    public void setTransferMethod(String transferMethod) {
        this.transferMethod = transferMethod;
    }

    public String getLevelInfo() {
        return this.levelInfo;
    }

    public void setLevelInfo(String levelInfo) {
        this.levelInfo = levelInfo;
    }

    public String getSubSecurityType() {
        return this.subSecurityType;
    }

    public void setSubSecurityType(String subSecurityType) {
        this.subSecurityType = subSecurityType;
    }

    public long getTotalCapitalStock() {
        return this.totalCapitalStock;
    }

    public void setTotalCapitalStock(long totalCapitalStock) {
        this.totalCapitalStock = totalCapitalStock;
    }

    public String getTransferMethodCode() {
        return this.transferMethodCode;
    }

    public void setTransferMethodCode(String transferMethodCode) {
        this.transferMethodCode = transferMethodCode;
    }

    public double getLimitUpPrice() {
        return this.limitUpPrice;
    }

    public void setLimitUpPrice(double limitUpPrice) {
        this.limitUpPrice = limitUpPrice;
    }

    public double getLimitDownPrice() {
        return this.limitDownPrice;
    }

    public void setLimitDownPrice(double limitDownPrice) {
        this.limitDownPrice = limitDownPrice;
    }

    public boolean isStopFlag() {
        return this.stopFlag;
    }

    public boolean isNeeqQuery() {
        return this.neeqQuery;
    }

    public void setStopFlag(boolean stopFlag) {
        this.stopFlag = stopFlag;
    }

    public void setNeeqQuery(boolean neeqQuery) {
        this.neeqQuery = neeqQuery;
    }

    public static String getBidRate() {
        return bidRate;
    }

    private static void setBidRate(String bidRate) {
        RefItem.bidRate = bidRate;
    }

    public static String getAskRate() {
        return askRate;
    }

    private static void setAskRate(String askRate) {
        RefItem.askRate = askRate;
    }

    public static double getMediumRate() {
        return mediumRate;
    }

    private static void setMediumRate(double mediumRate) {
        RefItem.mediumRate = mediumRate;
    }

    public boolean isHkWolun() {
        return "SHSC".equals(this.market) || "SZSC".equals(this.market);
    }

    public String getListSector() {
        return this.listSector;
    }

    public void setListSector(String listSector) {
        this.listSector = listSector;
    }

    public boolean isGem() {
        return "XSHE".equals(this.market) && ((String)this.code.get()).startsWith("30");
    }

    public int getNoProfit() {
        return this.noProfit;
    }

    public void setNoProfit(int noProfit) {
        this.noProfit = noProfit;
    }

    public int getWeightedVotingRights() {
        return this.weightedVotingRights;
    }

    public void setWeightedVotingRights(int weightedVotingRights) {
        this.weightedVotingRights = weightedVotingRights;
    }

    public int getIsRegistration() {
        return this.isRegistration;
    }

    public void setIsRegistration(int isRegistration) {
        this.isRegistration = isRegistration;
    }

    public int getIsVIE() {
        return this.isVIE;
    }

    public void setIsVIE(int isVIE) {
        this.isVIE = isVIE;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public double getLimitUpRate() {
        return this.limitUpRate;
    }

    public void setLimitUpRate(double limitUpRate) {
        this.limitUpRate = limitUpRate;
    }

    public double getLimitDownRate() {
        return this.limitDownRate;
    }

    public void setLimitDownRate(double limitDownRate) {
        this.limitDownRate = limitDownRate;
    }

    public String getConId() {
        return this.conId;
    }

    public void setConId(String conId) {
        this.conId = conId;
    }

    public int getMarketMakerCount() {
        return this.marketMakerCount;
    }

    public void setMarketMakerCount(int marketMakerCount) {
        this.marketMakerCount = marketMakerCount;
    }

    public String getOtherBusiness() {
        return this.otherBusiness;
    }

    public void setOtherBusiness(String otherBusiness) {
        this.otherBusiness = otherBusiness;
    }

    public String getListFlag() {
        return this.listFlag;
    }

    public void setListFlag(String listFlag) {
        this.listFlag = listFlag;
    }

    public boolean isDelayedDelivery() {
        return this.isDelayedDelivery;
    }

    public void setDelayedDelivery(boolean isDelayedDelivery) {
        this.isDelayedDelivery = isDelayedDelivery;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public String getDeliveryVarity() {
        return this.deliveryVarity;
    }

    public void setDeliveryVarity(String deliveryVarity) {
        this.deliveryVarity = deliveryVarity;
    }

    public String getQuoteUnit() {
        return this.quoteUnit;
    }

    public void setQuoteUnit(String quoteUnit) {
        this.quoteUnit = quoteUnit;
    }

    public double getTradeUnit() {
        return this.tradeUnit;
    }

    public void setTradeUnit(double tradeUnit) {
        this.tradeUnit = tradeUnit;
    }

    public double getMaxOrderAmt() {
        return this.maxOrderAmt;
    }

    public void setMaxOrderAmt(double maxOrderAmt) {
        this.maxOrderAmt = maxOrderAmt;
    }

    public double getMinOrderAmt() {
        return this.minOrderAmt;
    }

    public void setMinOrderAmt(double minOrderAmt) {
        this.minOrderAmt = minOrderAmt;
    }

    public double getPriceTick() {
        return this.priceTick;
    }

    public void setPriceTick(double priceTick) {
        this.priceTick = priceTick;
    }

    public String getInvestedTarget() {
        return this.investedTarget;
    }

    public void setInvestedTarget(String investedTarget) {
        this.investedTarget = investedTarget;
    }
}

