/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PMarketData;
import cms.tmx.define.BsDict;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.HandicapInfoXRepo;
import cms.tmx.entity.data.HkwolunPriceUnit;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StdBondForwardDeliver;
import cms.tmx.http.api.marketdata.dto.MDEntry;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.http.api.marketdata.dto.YieldData;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.javafx.obj.MxChgClrObj;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.ObservableList;

public class MarketItem
extends MxChgClrObj {
    private static final String SEC_STOPPED_FLAG_X = "X";
    private static final String SEC_STOPPED_FLAG_B = "B";
    private static final String SEC_STOPPED_FLAG_Q = "Q";
    private static final String SEC_STOPPED_FLAG_D = "D";
    private static final String SEC_LIMIT_UP_STR = "\u6da8\u505c";
    private static final String SEC_LIMIT_DOWN_STR = "\u8dcc\u505c";
    private static final String SEC_STOP_STR = "\u505c\u724c";
    public static final int BUY = 0;
    private static final int SELL = 1;
    private static final int TRADE = 2;
    private static final int OPEN_PRICE = 4;
    private static final int CLOSE_PRICE = 5;
    private ObjectProperty<RefItem> refItem = new SimpleObjectProperty();
    private StringProperty phase = new SimpleStringProperty("");
    private DoubleProperty openPrice = new SimpleDoubleProperty();
    private DoubleProperty nowPrice = new SimpleDoubleProperty();
    private DoubleProperty volume = new SimpleDoubleProperty();
    private DoubleProperty closePrice = new SimpleDoubleProperty();
    private DoubleProperty preSettlementPrice = new SimpleDoubleProperty();
    private DoubleProperty prevSettlementPrice = new SimpleDoubleProperty();
    private double settlementPrice;
    private IntegerProperty totalDealQty = new SimpleIntegerProperty();
    private IntegerProperty totalPositionQty = new SimpleIntegerProperty();
    private static StringProperty initAmtSh = new SimpleStringProperty("");
    private static StringProperty initAmtSz = new SimpleStringProperty("");
    private static StringProperty posAmtSh = new SimpleStringProperty("");
    private static StringProperty posAmtSz = new SimpleStringProperty("");
    private DoubleProperty lowPrice = new SimpleDoubleProperty();
    private DoubleProperty highPrice = new SimpleDoubleProperty();
    private DoubleProperty avgPrice = new SimpleDoubleProperty();
    private DoubleProperty upLimitPrice = new SimpleDoubleProperty();
    private DoubleProperty downLimitPrice = new SimpleDoubleProperty();
    private BooleanBinding rising = this.closePrice.lessThan((ObservableNumberValue)this.nowPrice);
    private BooleanBinding falling = this.closePrice.greaterThan((ObservableNumberValue)this.nowPrice);
    private BooleanBinding draw = this.closePrice.isEqualTo((ObservableNumberValue)this.nowPrice);
    private DoubleProperty fallPrice = new SimpleDoubleProperty();
    private DoubleProperty risePrice = new SimpleDoubleProperty();
    private ObservableList<HandicapInfo> listBuyHandicap = FxUtils.newList();
    private ObservableList<HandicapInfo> listSellHandicap = FxUtils.newList();
    private ObservableList<HandicapInfoXRepo> listRepoHandicap = FxUtils.newList();
    private ObservableList<HandicapInfo> listHKBuyHandicap = FxUtils.newList();
    private ObservableList<HandicapInfo> listHKSellHandicap = FxUtils.newList();
    private HandicapInfo buyHandicap;
    private HandicapInfo sellHandicap;
    private DoubleProperty canDealTotal = new SimpleDoubleProperty();
    private DoubleProperty openYield = new SimpleDoubleProperty();
    private int mdBookType;
    private SettlType settlType = SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE;
    private StringProperty buyYtm = new SimpleStringProperty("");
    private StringProperty sellYtm = new SimpleStringProperty("");
    private StringProperty settlTypeName = new SimpleStringProperty("");
    private ObjectProperty<StdBondForwardDeliver> deliver1 = new SimpleObjectProperty();
    private ObjectProperty<StdBondForwardDeliver> deliver2 = new SimpleObjectProperty();
    private StringProperty basePrice = new SimpleStringProperty("");
    private StringProperty forwardYtm1 = new SimpleStringProperty("");
    private StringProperty forwardYtm2 = new SimpleStringProperty("");
    private boolean priceChange = false;
    private String basket = "";
    private int index;
    private long lastUpdateTime = 0L;
    private int gears = 10;
    private boolean subd = false;
    private boolean canUnsub = true;
    private boolean reSub = false;
    private boolean isMarketMaking = false;
    private int clearGears = 5;
    private static final double NUM = 0.01;
    private DoubleBinding pct = Bindings.createDoubleBinding(() -> {
        double close = this.closePrice.get();
        if (this.refItem.getValue() != null && ((RefItem)((Object)((Object)((Object)this.refItem.getValue())))).getType().equals("FUT")) {
            close = this.preSettlementPrice.get();
        }
        if (this.refItem.getValue() != null && ((RefItem)((Object)((Object)((Object)this.refItem.getValue())))).getType().equals("FUT") && ((RefItem)((Object)((Object)((Object)this.refItem.getValue())))).getMarket().equals("SGEX")) {
            close = this.prevSettlementPrice.get();
        }
        double now = this.nowPrice.get();
        if (close == 0.0 || now == 0.0) {
            return 0.0;
        }
        double percent = (now - close) / close * 100.0;
        if (Math.abs(percent) < 0.01) {
            return 0.0;
        }
        return percent;
    }, (Observable[])new Observable[]{super.changedProperty()});
    private BooleanBinding stop = Bindings.createBooleanBinding(() -> {
        if (!(SEC_STOPPED_FLAG_B.equals(this.phase.getValue()) || SEC_STOPPED_FLAG_X.equals(this.phase.getValue()) || SEC_STOPPED_FLAG_Q.equals(this.phase.getValue()) || SEC_STOPPED_FLAG_D.equals(this.phase.getValue()))) {
            return false;
        }
        return true;
    }, (Observable[])new Observable[]{this.phase});
    private BooleanBinding limitUp = Bindings.createBooleanBinding(() -> {
        if (!this.nowPrice.lessThan((ObservableNumberValue)this.upLimitPrice).get() && this.nowPrice.isNotEqualTo(0).get() && this.upLimitPrice.isNotEqualTo(0).get()) {
            return true;
        }
        return false;
    }, (Observable[])new Observable[]{super.changedProperty()});
    private BooleanBinding limitDown = Bindings.createBooleanBinding(() -> {
        if (!this.nowPrice.greaterThan((ObservableNumberValue)this.downLimitPrice).get() && this.nowPrice.isNotEqualTo(0).get() && this.downLimitPrice.isNotEqualTo(0).get()) {
            return true;
        }
        return false;
    }, (Observable[])new Observable[]{super.changedProperty()});
    private StringBinding status = Bindings.createStringBinding(() -> {
        if (this.stop.get()) {
            return SEC_STOP_STR;
        }
        if (this.limitUp.get()) {
            return SEC_LIMIT_UP_STR;
        }
        if (this.limitDown.get()) {
            return SEC_LIMIT_DOWN_STR;
        }
        return "";
    }, (Observable[])new Observable[]{this.limitUp, this.limitDown, this.stop});
    public static boolean showAll = false;

    public boolean isPriceChange() {
        return this.priceChange;
    }

    public void setPriceChange(boolean priceChange) {
        this.priceChange = priceChange;
    }

    public MarketItem(int gears) {
        this.gears = gears;
        this.init();
    }

    public MarketItem(SettlType type, int mdBookType, int gears) {
        this.setSettlType(type);
        this.setMdBookType(mdBookType);
        this.gears = gears;
        this.init();
    }

    public void init() {
        int i = 0;
        while (i < this.gears) {
            HandicapInfo infoBuy = new HandicapInfo();
            HandicapInfo infoSell = new HandicapInfo();
            infoBuy.setIndex(i + 1);
            infoSell.setIndex(i + 1);
            this.listBuyHandicap.add((Object)infoBuy);
            this.listSellHandicap.add((Object)infoSell);
            HandicapInfoXRepo infoRepo = new HandicapInfoXRepo();
            this.listRepoHandicap.add((Object)infoRepo);
            ++i;
        }
        this.buyHandicap = new HandicapInfo();
        this.sellHandicap = new HandicapInfo();
    }

    public double getBuyPrice(int index) {
        if (this.listBuyHandicap.size() > index) {
            return ((HandicapInfo)((Object)this.listBuyHandicap.get(index))).getPrice();
        }
        return 0.0;
    }

    public double getSellPrice(int index) {
        if (this.listSellHandicap.size() > index) {
            return ((HandicapInfo)((Object)this.listSellHandicap.get(index))).getPrice();
        }
        return 0.0;
    }

    public int getBuyCount(int index) {
        if (this.listBuyHandicap.size() > index) {
            return ((HandicapInfo)((Object)this.listBuyHandicap.get(index))).getCount();
        }
        return 0;
    }

    public int getSellCount(int index) {
        if (this.listBuyHandicap.size() > index) {
            return ((HandicapInfo)((Object)this.listSellHandicap.get(index))).getCount();
        }
        return 0;
    }

    public void update(Object obj) {
        this.priceChange = false;
        if (obj instanceof MarketItem) {
            this.update((MarketItem)((Object)MarketItem.class.cast(obj)));
        } else if (obj instanceof PMarketData.MarketDataSnapshot) {
            this.update((PMarketData.MarketDataSnapshot)PMarketData.MarketDataSnapshot.class.cast(obj), true);
        } else if (obj instanceof MarketDataSnapshot) {
            this.update((MarketDataSnapshot)MarketDataSnapshot.class.cast(obj));
        }
        if (this.priceChange) {
            this.changed();
        }
    }

    public void update(Object obj, boolean isPush) {
        this.priceChange = false;
        if (obj instanceof PMarketData.MarketDataSnapshot) {
            this.update((PMarketData.MarketDataSnapshot)PMarketData.MarketDataSnapshot.class.cast(obj), isPush);
        } else if (obj instanceof MarketDataSnapshot) {
            this.update((MarketDataSnapshot)MarketDataSnapshot.class.cast(obj));
        }
        if (this.priceChange) {
            this.changed();
        }
    }

    public static String getIndexText(boolean bBuy, HandicapInfo info) {
        if (info == null) {
            return "";
        }
        if (bBuy) {
            return String.format("\u4e70%s", StringUtils.numToChinese((int)info.getIndex()));
        }
        return String.format("\u5356%s", StringUtils.numToChinese((int)info.getIndex()));
    }

    private void update(MarketItem item) {
        this.setOpenPrice(item.getOpenPrice());
        this.setVolume(item.getVolume());
        this.setClosePrice(item.getClosePrice());
        this.setPreSettlementPrice(item.getPreSettlementPrice());
        this.setPrevSettlementPrice(item.getPrevSettlementPrice());
        this.setSettlementPrice(item.getSettlementPrice());
        this.setTotalDealQty(item.getTotalDealQty());
        this.setTotalPositionQty(item.getTotalPositionQty());
        if (this.getNowPrice() != item.getNowPrice()) {
            this.setNowPrice(item.getNowPrice());
            this.priceChange = true;
        }
        this.setLowPrice(item.getLowPrice());
        this.setHighPrice(item.getHighPrice());
        this.setAvgPrice(item.getAvgPrice());
        this.setUpLimitPrice(item.getUpLimitPrice());
        this.setDownLimitPrice(item.getDownLimitPrice());
        this.setPhase(item.getPhase());
        this.setClear(item.isClear());
        this.buyHandicap.update((Object)item.getBuyHandicap());
        this.sellHandicap.update((Object)item.getSellHandicap());
        this.updateHandicapInfo((List<HandicapInfo>)this.listBuyHandicap, (List<HandicapInfo>)item.getListBuyHandicap());
        this.updateHandicapInfo((List<HandicapInfo>)this.listSellHandicap, (List<HandicapInfo>)item.getListSellHandicap());
        this.setMdBookType(item.getMdBookType());
        this.setSettlType(item.getSettlType());
        this.setSettlTypeName(item.getSettlTypeName());
        this.setForwardYtm1(item.getForwardYtm1());
        this.setForwardYtm2(item.getForwardYtm2());
    }

    private void updateHandicapInfo(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int size = listHandicap.size() > listInfo.size() ? listInfo.size() : listHandicap.size();
        int i = 0;
        while (i < size) {
            if (listHandicap.get(i).getPrice() != listInfo.get(i).getPrice()) {
                this.priceChange = true;
            }
            listHandicap.get(i).update((Object)listInfo.get(i));
            ++i;
        }
    }

    private synchronized void update(PMarketData.MarketDataSnapshot snap, boolean isPush) {
        this.setOpenPrice(snap.getPriceUnit().getOpenPx());
        if (this.getNowPrice() != snap.getPriceUnit().getLastPx()) {
            this.setNowPrice(snap.getPriceUnit().getLastPx());
            this.priceChange = true;
        } else if (this.getUpLimitPrice() != snap.getPriceUnit().getRisePx() || this.getDownLimitPrice() != snap.getPriceUnit().getFallPx()) {
            this.priceChange = true;
        }
        this.setClosePrice(snap.getPriceUnit().getClosePx());
        this.setPreSettlementPrice(snap.getPriceUnit().getPreSettlementPx());
        this.setSettlementPrice(snap.getPriceUnit().getSettlementPx());
        this.setPreSettlementPrice(snap.getPriceUnit().getPreSettlementPx());
        this.setTotalDealQty(snap.getPriceUnit().getVolume());
        this.setTotalPositionQty((int)snap.getPriceUnit().getOpenInterest());
        this.setLowPrice(snap.getPriceUnit().getLowestPx());
        this.setHighPrice(snap.getPriceUnit().getHighestPx());
        this.setAvgPrice(snap.getPriceUnit().getAvgPx());
        this.setUpLimitPrice(snap.getPriceUnit().getRisePx());
        this.setDownLimitPrice(snap.getPriceUnit().getFallPx());
        this.setRisePrice(snap.getPriceUnit().getRisePx());
        this.setFallPrice(snap.getPriceUnit().getFallPx());
        this.setPhase(snap.getTradePhaseCode());
        this.checkHkwolunPriceUnitUpdate();
        this.updateHandicap(snap, isPush);
        this.setClear(false);
        this.setPrevSettlementPrice(snap.getPriceUnit().getPreSettlementPx());
    }

    private synchronized void update(MarketDataSnapshot snap) {
        if ("pricing".equals(snap.getMdType())) {
            this.updateHandicapDepth(snap);
            this.setClear(false);
            this.priceChange = true;
            return;
        }
        this.setMdBookType(snap.getMdBookType());
        this.setSettlType(snap.getSettlType());
        if (snap.getSettlType() != null) {
            switch (snap.getSettlType().ordinal()) {
                case 1: {
                    this.setSettlTypeName("T+0");
                    break;
                }
                case 2: {
                    this.setSettlTypeName("T+1");
                    break;
                }
                default: {
                    this.setSettlTypeName("");
                }
            }
        }
        if (snap.getPriceUnit() != null) {
            this.setClosePrice(snap.getPriceUnit().getClosePx());
            this.setLowPrice(snap.getPriceUnit().getLowestPx());
            this.setHighPrice(snap.getPriceUnit().getHighestPx());
            this.setAvgPrice(snap.getPriceUnit().getAvgPx());
            this.setNowPrice(snap.getPriceUnit().getLastPx());
            this.setVolume(snap.getPriceUnit().getVolume());
            this.setPrevSettlementPrice(snap.getPriceUnit().getPrevSettlementPx());
            this.setRisePrice(snap.getPriceUnit().getRisePx());
            this.setFallPrice(snap.getPriceUnit().getFallPx());
        }
        this.setUpLimitPrice(this.getRefItem().getLimitUpPrice());
        this.setDownLimitPrice(this.getRefItem().getLimitDownPrice());
        this.updateHandicap(snap);
        this.setClear(false);
        this.priceChange = true;
    }

    private void updateHandicap(PMarketData.MarketDataSnapshot snapshot, boolean isPush) {
        PMarketData.MDFullGrp sanp = snapshot.getMdFullGrp();
        try {
            int levelBuyMax = -1;
            int levelSellMax = -1;
            for (PMarketData.MDEntry entry : sanp.getMdEntryList()) {
                boolean change;
                if (!BsDict.HKUSA_MARKET.contains(snapshot.getInstrument().getMarket()) && !showAll && entry.getMdPriceLevel() >= 5 || entry.getMdPriceLevel() >= this.gears) continue;
                if (entry.getMdEntryType() == 0) {
                    change = ((HandicapInfo)((Object)this.listBuyHandicap.get(entry.getMdPriceLevel()))).updata(entry, this.getRefItem());
                    if (change) {
                        this.priceChange = true;
                    }
                    if (entry.getMdPriceLevel() <= levelBuyMax) continue;
                    levelBuyMax = entry.getMdPriceLevel();
                    continue;
                }
                if (entry.getMdEntryType() != 1) continue;
                change = ((HandicapInfo)((Object)this.listSellHandicap.get(entry.getMdPriceLevel()))).updata(entry, this.getRefItem());
                if (change) {
                    this.priceChange = true;
                }
                if (entry.getMdPriceLevel() <= levelSellMax) continue;
                levelSellMax = entry.getMdPriceLevel();
            }
            if (!isPush) {
                return;
            }
            int gear = this.gears;
            if (this.isMarketMaking) {
                gear = this.clearGears;
            }
            if (gear > levelBuyMax + 1 && (((HandicapInfo)((Object)this.listBuyHandicap.get(levelBuyMax + 1))).getPrice() > 0.0 || ((HandicapInfo)((Object)this.listBuyHandicap.get(levelBuyMax + 1))).getCount() > 0)) {
                this.priceChange = true;
                int i = levelBuyMax + 1;
                while (i < gear) {
                    ((HandicapInfo)((Object)this.listBuyHandicap.get(i))).clear();
                    ++i;
                }
            }
            if (gear > levelSellMax + 1 && (((HandicapInfo)((Object)this.listSellHandicap.get(levelSellMax + 1))).getPrice() > 0.0 || ((HandicapInfo)((Object)this.listSellHandicap.get(levelSellMax + 1))).getCount() > 0)) {
                this.priceChange = true;
                int i = levelSellMax + 1;
                while (i < gear) {
                    ((HandicapInfo)((Object)this.listSellHandicap.get(i))).clear();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private void updateHandicap(MarketDataSnapshot snap) {
        List list = snap.getEntry();
        if (list == null) {
            return;
        }
        try {
            for (MDEntry entry : list) {
                if (!BsDict.HKUSA_MARKET.contains(snap.getInstrument().getMarket()) && !showAll && entry.getMdPriceLevel() > 5 || entry.getMdPriceLevel() > this.gears) continue;
                if (entry.getMdEntryType() == 0) {
                    if (entry.getMdPriceLevel() == 0) {
                        this.buyHandicap.updata(entry, this.getRefItem());
                        continue;
                    }
                    if (entry.getMdPriceLevel() == 1 && "FutureYtm".equals(snap.getMdType())) {
                        this.setBuyYtm(StringUtils.toThousands((Number)(entry.getYieldData().getYield() * 100.0), (int)3));
                        continue;
                    }
                    if ("XcfeXRepo".equals(snap.getInstrument().getSecuritySubType())) {
                        ((HandicapInfoXRepo)((Object)this.listRepoHandicap.get(entry.getMdPriceLevel() - 1))).update(entry, false);
                        continue;
                    }
                    ((HandicapInfo)((Object)this.listBuyHandicap.get(entry.getMdPriceLevel() - 1))).updata(entry, this.getRefItem());
                    continue;
                }
                if (entry.getMdEntryType() == 1) {
                    if (entry.getMdPriceLevel() == 0) {
                        this.sellHandicap.updata(entry, this.getRefItem());
                        continue;
                    }
                    if (entry.getMdPriceLevel() == 1 && "FutureYtm".equals(snap.getMdType())) {
                        this.setSellYtm(StringUtils.toThousands((Number)(entry.getYieldData().getYield() * 100.0), (int)3));
                        continue;
                    }
                    if ("XcfeXRepo".equals(snap.getInstrument().getSecuritySubType())) {
                        ((HandicapInfoXRepo)((Object)this.listRepoHandicap.get(entry.getMdPriceLevel() - 1))).update(entry, true);
                        continue;
                    }
                    ((HandicapInfo)((Object)this.listSellHandicap.get(entry.getMdPriceLevel() - 1))).updata(entry, this.getRefItem());
                    continue;
                }
                if (entry.getMdEntryType() == 4) {
                    this.setOpenPrice(entry.getMdEntryPx());
                    if (entry.getYieldData() != null) {
                        this.setOpenYield(entry.getYieldData().getYield());
                    }
                    this.setCanDealTotal(entry.getMdEntrySize());
                    continue;
                }
                if (entry.getMdEntryType() != 5) continue;
                this.setClosePrice(entry.getMdEntryPx());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateHandicapDepth(MarketDataSnapshot snap) {
        List list = snap.getEntry();
        if (list == null) {
            return;
        }
        boolean isActive = snap.getInstrument().getSecurityId().contains("Active");
        if (isActive) {
            for (MDEntry entry : list) {
                YieldData data;
                if (entry.getText() == null) {
                    Double px = entry.getMdEntryPx();
                    this.setBasePrice(px == null ? "" : String.valueOf((double)Math.round(px * 10000.0) / 10000.0));
                    continue;
                }
                if (this.getDeliver1().getSecurityId().equals(entry.getText())) {
                    data = entry.getYieldData();
                    this.setForwardYtm1(data == null ? "" : String.valueOf((double)Math.round(data.getYield() * 1000000.0) / 10000.0));
                    continue;
                }
                if (!this.getDeliver2().getSecurityId().equals(entry.getText())) continue;
                data = entry.getYieldData();
                this.setForwardYtm2(data == null ? "" : String.valueOf((double)Math.round(data.getYield() * 1000000.0) / 10000.0));
            }
            return;
        }
        int deliver = 0;
        if (snap.getInstrument().getSecurityIdSource().equals(this.getDeliver1().getSecurityId())) {
            deliver = 1;
        } else if (snap.getInstrument().getSecurityIdSource().equals(this.getDeliver2().getSecurityId())) {
            deliver = 2;
        }
        try {
            for (MDEntry entry : list) {
                if (!BsDict.HKUSA_MARKET.contains(snap.getInstrument().getMarket()) && !showAll && entry.getMdPriceLevel() > 5 || entry.getMdPriceLevel() > this.gears) continue;
                if (entry.getMdEntryType() == 0) {
                    ((HandicapInfo)((Object)this.listBuyHandicap.get(entry.getMdPriceLevel() - 1))).updataDepth(entry, this.getRefItem(), deliver);
                    continue;
                }
                if (entry.getMdEntryType() != 1) continue;
                ((HandicapInfo)((Object)this.listSellHandicap.get(entry.getMdPriceLevel() - 1))).updataDepth(entry, this.getRefItem(), deliver);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    public static boolean checkQuotaUpdate(PMarketData.MarketDataSnapshot snap) {
        String code = snap.getInstrument().getSecurityId();
        if (!"666666".equals(code)) {
            return false;
        }
        String market = snap.getInstrument().getMarket();
        int unit = 100000000;
        String unitStr = "\u4ebf";
        double initAmt = snap.getMrkStatusData().getThresholdAmt();
        double posAmt = snap.getMrkStatusData().getPosAmt();
        if ("SHSC".equals(market)) {
            MarketItem.setInitAmtSh(String.valueOf(StringUtils.toStr((double)(initAmt / (double)unit), (int)1)) + unitStr);
            Platform.runLater(() -> MarketItem.setPosAmtSh(String.valueOf(StringUtils.toStr((double)(posAmt / (double)unit), (int)1)) + unitStr));
        } else if ("SZSC".equals(market)) {
            MarketItem.setInitAmtSz(String.valueOf(StringUtils.toStr((double)(initAmt / (double)unit), (int)1)) + unitStr);
            Platform.runLater(() -> MarketItem.setPosAmtSz(String.valueOf(StringUtils.toStr((double)(posAmt / (double)unit), (int)1)) + unitStr));
        } else {
            return false;
        }
        return true;
    }

    private void checkHkwolunPriceUnitUpdate() {
        RefItem refItem = this.getRefItem();
        String market = refItem.getMarket();
        if (!"SHSC".equals(market) && !"SZSC".equals(market)) {
            return;
        }
        double price = this.getNowPrice();
        if (price == 0.0) {
            price = this.getClosePrice();
        }
        double priceUnit = HkwolunPriceUnit.getPriceUnit(price);
        int scale = DecimalUtils.getScale((double)priceUnit);
        this.logger.info("\u6e2f\u80a1\u901a\u4ef7\u683c\u6700\u5c0f\u62a5\u4ef7\u5f00\u59cb\u66f4\u65b0" + market + "," + refItem.getCode() + " priceUnit:" + priceUnit + " scale:" + scale);
        refItem.setScale(scale);
        refItem.setPriceUnit(priceUnit);
        this.logger.info("\u6e2f\u80a1\u901a\u4ef7\u683c\u6700\u5c0f\u62a5\u4ef7\u66f4\u65b0" + market + "," + refItem.getCode() + " priceUnit:" + priceUnit + " scale:" + scale);
    }

    public synchronized void clear() {
        this.setClear(true);
        this.setPhase("");
        this.setDownLimitPrice(0.0);
        this.setUpLimitPrice(0.0);
        this.setSettlTypeName("");
        this.setNowPrice(0.0);
        this.setClosePrice(0.0);
        for (HandicapInfo info2 : this.listBuyHandicap) {
            if (this.isMarketMaking && info2.getIndex() > this.clearGears) break;
            info2.clear();
        }
        for (HandicapInfo info2 : this.listSellHandicap) {
            if (this.isMarketMaking && info2.getIndex() > this.clearGears) break;
            info2.clear();
        }
        this.listRepoHandicap.forEach(info -> info.clear());
        this.setBasePrice("");
        this.setForwardYtm1("");
        this.setForwardYtm2("");
        this.changed();
    }

    public boolean isValidRef() {
        if (this.getRefItem() == null) {
            return false;
        }
        return !this.getRefItem().getType().isEmpty();
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getType().equals("BOND") || this.getRefItem().getType().equals("REPO");
    }

    public boolean isSHSec() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isSZSec() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getMarket().equals("XSHE");
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getType().equals("STOCK");
    }

    public boolean isSHStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isStock() && this.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isSZStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isStock() && this.getRefItem().getMarket().equals("XSHE");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getRefItem().getType().equals("FUND");
    }

    public BooleanBinding getStop() {
        return this.stop;
    }

    public DoubleBinding pctProperty() {
        return this.pct;
    }

    public double getPct() {
        return this.pct.get();
    }

    public StringBinding statusProperty() {
        return this.status;
    }

    public String getStatus() {
        return this.status.get();
    }

    public BooleanBinding getLimitUp() {
        return this.limitUp;
    }

    public BooleanBinding getLimitDown() {
        return this.limitDown;
    }

    public BooleanBinding getRising() {
        return this.rising;
    }

    public BooleanBinding getFalling() {
        return this.falling;
    }

    public BooleanBinding getDraw() {
        return this.draw;
    }

    public void setDraw(BooleanBinding draw) {
        this.draw = draw;
    }

    public ObservableList<HandicapInfo> getListBuyHandicap() {
        return this.listBuyHandicap;
    }

    public ObservableList<HandicapInfo> getListSellHandicap() {
        return this.listSellHandicap;
    }

    public StringProperty phaseProperty() {
        return this.phase;
    }

    public String getPhase() {
        return (String)this.phaseProperty().get();
    }

    public void setPhase(String phase) {
        this.phaseProperty().set((Object)phase);
    }

    public DoubleProperty openPriceProperty() {
        return this.openPrice;
    }

    public double getOpenPrice() {
        return this.openPriceProperty().get();
    }

    public void setOpenPrice(double openPrice) {
        this.openPriceProperty().set(openPrice);
    }

    public DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public DoubleProperty closePriceProperty() {
        return this.closePrice;
    }

    public double getClosePrice() {
        return this.closePriceProperty().get();
    }

    public void setClosePrice(double closePrice) {
        this.closePriceProperty().set(closePrice);
    }

    public DoubleProperty lowPriceProperty() {
        return this.lowPrice;
    }

    public double getLowPrice() {
        return this.lowPriceProperty().get();
    }

    public void setLowPrice(double lowPrice) {
        this.lowPriceProperty().set(lowPrice);
    }

    public DoubleProperty avgPriceProperty() {
        return this.avgPrice;
    }

    public double getAvgPrice() {
        return this.avgPriceProperty().get();
    }

    public void setAvgPrice(double avgPrice) {
        this.avgPriceProperty().set(avgPrice);
    }

    public DoubleProperty upLimitPriceProperty() {
        return this.upLimitPrice;
    }

    public double getUpLimitPrice() {
        return this.upLimitPriceProperty().get();
    }

    public void setUpLimitPrice(double upLimitPrice) {
        this.upLimitPriceProperty().set(upLimitPrice);
    }

    public DoubleProperty downLimitPriceProperty() {
        return this.downLimitPrice;
    }

    public double getDownLimitPrice() {
        return this.downLimitPriceProperty().get();
    }

    public void setDownLimitPrice(double downLimitPrice) {
        this.downLimitPriceProperty().set(downLimitPrice);
    }

    public DoubleProperty highPriceProperty() {
        return this.highPrice;
    }

    public double getHighPrice() {
        return this.highPriceProperty().get();
    }

    public void setHighPrice(double highPrice) {
        this.highPriceProperty().set(highPrice);
    }

    public ObjectProperty<RefItem> refItemProperty() {
        return this.refItem;
    }

    public RefItem getRefItem() {
        return (RefItem)((Object)this.refItemProperty().get());
    }

    public void setRefItem(RefItem refItem) {
        if (refItem == null) {
            refItem = new RefItem();
        }
        this.clear();
        this.refItemProperty().set((Object)refItem);
    }

    public boolean isSubd() {
        return this.subd;
    }

    public void subd() {
        this.subd = true;
    }

    public boolean isCanUnsub() {
        return this.canUnsub;
    }

    public void setCanUnsub(boolean canUnsub) {
        this.canUnsub = canUnsub;
    }

    public int getGears() {
        return this.gears;
    }

    public final DoubleProperty preSettlementPriceProperty() {
        return this.preSettlementPrice;
    }

    public final double getPreSettlementPrice() {
        return this.preSettlementPriceProperty().get();
    }

    public final void setPreSettlementPrice(double preSettlementPrice) {
        this.preSettlementPriceProperty().set(preSettlementPrice);
    }

    public boolean isReSub() {
        return this.reSub;
    }

    public void setReSub(boolean reSub) {
        this.reSub = reSub;
    }

    public boolean notUpdatedForLongTime() {
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
        long now = new Date().getTime();
        String day = dayFormat.format(now);
        try {
            if (!(now > this.getTime(day, "090000") && now < this.getTime(day, "113000") || now > this.getTime(day, "130000") && now < this.getTime(day, "160000"))) {
                this.logger.info("\u975e\u4ea4\u6613\u65f6\u95f4\u6bb5\uff0c\u4e0d\u8fdb\u884c\u8ba2\u9605\u65e5\u671f\u6821\u9a8c(\u7279\u6743\u5f00\u653e)");
                return false;
            }
        }
        catch (ParseException e) {
            this.logger.error("\u8ba2\u9605\u65e5\u671f\u8f6c\u6362\u51fa\u9519(\u7279\u6743\u5f00\u653e)", (Throwable)e);
            return false;
        }
        return System.currentTimeMillis() - this.getLastUpdateTime() > 60000L;
    }

    private long getTime(String day, String time) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.parse(String.valueOf(day) + time).getTime();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public final IntegerProperty totalDealQtyProperty() {
        return this.totalDealQty;
    }

    public final int getTotalDealQty() {
        return this.totalDealQtyProperty().get();
    }

    public final void setTotalDealQty(int totalDealQty) {
        this.totalDealQtyProperty().set(totalDealQty);
    }

    public double getSettlementPrice() {
        return this.settlementPrice;
    }

    public void setSettlementPrice(double settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    public final DoubleProperty openYieldProperty() {
        return this.openYield;
    }

    public final double getOpenYield() {
        return this.openYieldProperty().get();
    }

    public final void setOpenYield(double openYield) {
        this.openYieldProperty().set(openYield);
    }

    public final DoubleProperty canDealTotalProperty() {
        return this.canDealTotal;
    }

    public final double getCanDealTotal() {
        return this.canDealTotalProperty().get();
    }

    public final void setCanDealTotal(double canDealTotal) {
        this.canDealTotalProperty().set(canDealTotal);
    }

    public SettlType getSettlType() {
        return this.settlType;
    }

    public void setSettlType(SettlType settlType) {
        this.settlType = settlType;
    }

    public final StringProperty settlTypeNameProperty() {
        return this.settlTypeName;
    }

    public final String getSettlTypeName() {
        return (String)this.settlTypeNameProperty().get();
    }

    public final void setSettlTypeName(String settlTypeName) {
        this.settlTypeNameProperty().set((Object)settlTypeName);
    }

    public int getMdBookType() {
        return this.mdBookType;
    }

    public void setMdBookType(int mdBookType) {
        this.mdBookType = mdBookType;
    }

    public String toString() {
        return String.valueOf(this.getSettlType().name()) + " " + this.mdBookType;
    }

    public boolean isMarketMaking() {
        return this.isMarketMaking;
    }

    public void setMarketMaking(boolean isMarketMaking) {
        this.isMarketMaking = isMarketMaking;
    }

    public int getClearGears() {
        return this.clearGears;
    }

    public void setClearGears(int clearGears) {
        this.clearGears = clearGears;
    }

    public HandicapInfo getBuyHandicap() {
        return this.buyHandicap;
    }

    public void setBuyHandicap(HandicapInfo buyHandicap) {
        this.buyHandicap = buyHandicap;
    }

    public HandicapInfo getSellHandicap() {
        return this.sellHandicap;
    }

    public void setSellHandicap(HandicapInfo sellHandicap) {
        this.sellHandicap = sellHandicap;
    }

    public String getBasket() {
        return this.basket;
    }

    public void setBasket(String basket) {
        this.basket = basket;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public final DoubleProperty volumeProperty() {
        return this.volume;
    }

    public final double getVolume() {
        return this.volumeProperty().get();
    }

    public final void setVolume(double volume) {
        this.volumeProperty().set(volume);
    }

    public static final StringProperty initAmtShProperty() {
        return initAmtSh;
    }

    public static final String getInitAmtSh() {
        return (String)MarketItem.initAmtShProperty().get();
    }

    public static final void setInitAmtSh(String initAmtSh) {
        MarketItem.initAmtShProperty().set((Object)initAmtSh);
    }

    public static final StringProperty initAmtSzProperty() {
        return initAmtSz;
    }

    public static final String getInitAmtSz() {
        return (String)MarketItem.initAmtSzProperty().get();
    }

    public static final void setInitAmtSz(String initAmtSz) {
        MarketItem.initAmtSzProperty().set((Object)initAmtSz);
    }

    public static final StringProperty posAmtShProperty() {
        return posAmtSh;
    }

    public final String getPosAmtSh() {
        return (String)MarketItem.posAmtShProperty().get();
    }

    public static final void setPosAmtSh(String posAmtSh) {
        MarketItem.posAmtShProperty().set((Object)posAmtSh);
    }

    public static final StringProperty posAmtSzProperty() {
        return posAmtSz;
    }

    public final String getPosAmtSz() {
        return (String)MarketItem.posAmtSzProperty().get();
    }

    public static final void setPosAmtSz(String posAmtSz) {
        MarketItem.posAmtSzProperty().set((Object)posAmtSz);
    }

    public final IntegerProperty totalPositionQtyProperty() {
        return this.totalPositionQty;
    }

    public final int getTotalPositionQty() {
        return this.totalPositionQtyProperty().get();
    }

    public final void setTotalPositionQty(int totalPositionQty) {
        this.totalPositionQtyProperty().set(totalPositionQty);
    }

    public final StringProperty buyYtmProperty() {
        return this.buyYtm;
    }

    public final String getBuyYtm() {
        return (String)this.buyYtmProperty().get();
    }

    public final void setBuyYtm(String buyYtm) {
        this.buyYtmProperty().set((Object)buyYtm);
    }

    public final StringProperty sellYtmProperty() {
        return this.sellYtm;
    }

    public final String getSellYtm() {
        return (String)this.sellYtmProperty().get();
    }

    public final void setSellYtm(String sellYtm) {
        this.sellYtmProperty().set((Object)sellYtm);
    }

    public final ObjectProperty<StdBondForwardDeliver> deliver1Property() {
        return this.deliver1;
    }

    public final StdBondForwardDeliver getDeliver1() {
        return (StdBondForwardDeliver)((Object)this.deliver1Property().get());
    }

    public final void setDeliver1(StdBondForwardDeliver deliver1) {
        this.deliver1Property().set((Object)deliver1);
    }

    public final ObjectProperty<StdBondForwardDeliver> deliver2Property() {
        return this.deliver2;
    }

    public final StdBondForwardDeliver getDeliver2() {
        return (StdBondForwardDeliver)((Object)this.deliver2Property().get());
    }

    public final void setDeliver2(StdBondForwardDeliver deliver2) {
        this.deliver2Property().set((Object)deliver2);
    }

    public final StringProperty basePriceProperty() {
        return this.basePrice;
    }

    public final String getBasePrice() {
        return (String)this.basePriceProperty().get();
    }

    public final void setBasePrice(String basePrice) {
        this.basePriceProperty().set((Object)basePrice);
    }

    public final StringProperty forwardYtm1Property() {
        return this.forwardYtm1;
    }

    public final String getForwardYtm1() {
        return (String)this.forwardYtm1Property().get();
    }

    public final void setForwardYtm1(String forwardYtm1) {
        this.forwardYtm1Property().set((Object)forwardYtm1);
    }

    public final StringProperty forwardYtm2Property() {
        return this.forwardYtm2;
    }

    public final String getForwardYtm2() {
        return (String)this.forwardYtm2Property().get();
    }

    public final void setForwardYtm2(String forwardYtm2) {
        this.forwardYtm2Property().set((Object)forwardYtm2);
    }

    public final DoubleProperty prevSettlementPriceProperty() {
        return this.prevSettlementPrice;
    }

    public final double getPrevSettlementPrice() {
        return this.prevSettlementPriceProperty().get();
    }

    public final void setPrevSettlementPrice(double prevSettlementPrice) {
        this.prevSettlementPriceProperty().set(prevSettlementPrice);
    }

    public final DoubleProperty fallPriceProperty() {
        return this.fallPrice;
    }

    public final double getFallPrice() {
        return this.fallPriceProperty().get();
    }

    public final void setFallPrice(double fallPrice) {
        this.fallPriceProperty().set(fallPrice);
    }

    public final DoubleProperty risePriceProperty() {
        return this.risePrice;
    }

    public final double getRisePrice() {
        return this.risePriceProperty().get();
    }

    public final void setRisePrice(double risePrice) {
        this.risePriceProperty().set(risePrice);
    }

    public ObservableList<HandicapInfoXRepo> getListRepoHandicap() {
        return this.listRepoHandicap;
    }

    public void setListRepoHandicap(ObservableList<HandicapInfoXRepo> listRepoHandicap) {
        this.listRepoHandicap = listRepoHandicap;
    }

    public ObservableList<HandicapInfo> getListHKBuyHandicap() {
        return this.listHKBuyHandicap;
    }

    public ObservableList<HandicapInfo> getListHKSellHandicap() {
        return this.listHKSellHandicap;
    }
}

