/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.utils.DecimalUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HkwolunPriceUnit
extends MxObject {
    public static List<HkwolunPriceUnit> listUnit = new LinkedList<HkwolunPriceUnit>();
    public static Map<Double, Integer> mapScale = new HashMap<Double, Integer>();
    int groupSeq = 1;
    private double priceFloor = 2.0;
    private double priceCeiling = 3.0;
    private double priceUnit = 4.0;

    public void update(PCcsRefdata.HKStockPriceUnitGroup group) {
        this.setGroupSeq(group.getGroupSeq());
        this.setPriceFloor(group.getPriceFloor());
        this.setPriceCeiling(group.getPriceCeiling());
        this.setPriceUnit(group.getPriceUnit());
    }

    public static double getPriceUnit(double price) {
        for (HkwolunPriceUnit unit : listUnit) {
            if (!(unit.getPriceFloor() < price) || !(price <= unit.getPriceCeiling())) continue;
            return unit.getPriceUnit();
        }
        return 0.0;
    }

    public static int getScale(double price) {
        Integer scale = mapScale.get(price);
        if (scale == null) {
            scale = DecimalUtils.getScale((double)HkwolunPriceUnit.getPriceUnit(price));
            mapScale.put(price, scale);
        }
        return scale;
    }

    public static void setList(List<HkwolunPriceUnit> list) {
        listUnit = list;
    }

    public int getGroupSeq() {
        return this.groupSeq;
    }

    public void setGroupSeq(int groupSeq) {
        this.groupSeq = groupSeq;
    }

    public double getPriceFloor() {
        return this.priceFloor;
    }

    public void setPriceFloor(double priceFloor) {
        this.priceFloor = priceFloor;
    }

    public double getPriceCeiling() {
        return this.priceCeiling;
    }

    public void setPriceCeiling(double priceCeiling) {
        this.priceCeiling = priceCeiling;
    }

    public double getPriceUnit() {
        return this.priceUnit;
    }

    public void setPriceUnit(double priceUnit) {
        this.priceUnit = priceUnit;
    }
}

