/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.http.api.marketdata.dto.MDEntry;
import cms.tmx.javafx.obj.MxClrObj;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class HandicapInfoXRepo
extends MxClrObj {
    private IntegerProperty rows = new SimpleIntegerProperty(0);
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private DoubleProperty bidPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty bidQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty bidDealQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty offerPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty offerDealQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty offerQty = new SimpleDoubleProperty(0.0);
    private Set<String> bidUserId = new HashSet<String>();
    private Set<String> offerUserId = new HashSet<String>();

    public void update(Object obj) {
        if (obj instanceof HandicapInfoXRepo) {
            this.update((HandicapInfoXRepo)((Object)HandicapInfoXRepo.class.cast(obj)));
        }
    }

    public void update(MDEntry entry, boolean isBid) {
        double price = this.getPrice(entry.getMdEntryPx(), 2);
        int unit = 100000000;
        if (isBid) {
            this.setBidPrice(price);
            this.setBidDealQty((int)Math.round(entry.getMdEntrySize() / (double)unit));
            this.setBidQty((int)Math.round(((double)entry.getUnMatchQty() + entry.getMdEntrySize()) / (double)unit));
        } else {
            this.setOfferPrice(price);
            this.setOfferDealQty((int)Math.round(entry.getMdEntrySize() / (double)unit));
            this.setOfferQty((int)Math.round(((double)entry.getUnMatchQty() + entry.getMdEntrySize()) / (double)unit));
        }
        this.clearCheck();
    }

    private void clearCheck() {
        if (this.getBidQty() == 0.0 && this.getBidPrice() <= 0.0) {
            this.setClear(true);
        } else {
            this.setClear(false);
        }
    }

    private double getPrice(double px, int scale) {
        BigDecimal bd = new BigDecimal(px);
        double price = bd.setScale(scale, RoundingMode.HALF_UP).doubleValue();
        return price;
    }

    private void update(HandicapInfoXRepo info) {
        this.setCode(info.getCode());
        this.setName(info.getName());
        this.setBidPrice(info.getBidPrice());
        this.setBidQty(info.getBidQty());
        this.setBidDealQty(info.getBidDealQty());
        this.setBidUserId(info.getBidUserId());
        this.setOfferPrice(info.getOfferPrice());
        this.setOfferQty(info.getOfferQty());
        this.setOfferDealQty(info.getOfferDealQty());
        this.setOfferUserId(info.getOfferUserId());
        this.setClear(info.isClear());
    }

    public void clear() {
        this.setBidPrice(0.0);
        this.setBidQty(0.0);
        this.setBidDealQty(0.0);
        this.setOfferPrice(0.0);
        this.setOfferQty(0.0);
        this.setOfferDealQty(0.0);
        this.setClear(true);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final IntegerProperty rowsProperty() {
        return this.rows;
    }

    public final int getRows() {
        return this.rowsProperty().get();
    }

    public final void setRows(int rows) {
        this.rowsProperty().set(rows);
    }

    public final DoubleProperty bidPriceProperty() {
        return this.bidPrice;
    }

    public final double getBidPrice() {
        return this.bidPriceProperty().get();
    }

    public final void setBidPrice(double bidPrice) {
        this.bidPriceProperty().set(bidPrice);
    }

    public final DoubleProperty bidQtyProperty() {
        return this.bidQty;
    }

    public final double getBidQty() {
        return this.bidQtyProperty().get();
    }

    public final void setBidQty(double bidQty) {
        this.bidQtyProperty().set(bidQty);
    }

    public final DoubleProperty offerPriceProperty() {
        return this.offerPrice;
    }

    public final double getOfferPrice() {
        return this.offerPriceProperty().get();
    }

    public final void setOfferPrice(double offerPrice) {
        this.offerPriceProperty().set(offerPrice);
    }

    public final DoubleProperty offerQtyProperty() {
        return this.offerQty;
    }

    public final double getOfferQty() {
        return this.offerQtyProperty().get();
    }

    public final void setOfferQty(double offerQty) {
        this.offerQtyProperty().set(offerQty);
    }

    public final DoubleProperty bidDealQtyProperty() {
        return this.bidDealQty;
    }

    public final double getBidDealQty() {
        return this.bidDealQtyProperty().get();
    }

    public final void setBidDealQty(double bidDealQty) {
        this.bidDealQtyProperty().set(bidDealQty);
    }

    public final DoubleProperty offerDealQtyProperty() {
        return this.offerDealQty;
    }

    public final double getOfferDealQty() {
        return this.offerDealQtyProperty().get();
    }

    public final void setOfferDealQty(double offerDealQty) {
        this.offerDealQtyProperty().set(offerDealQty);
    }

    public Set<String> getBidUserId() {
        return this.bidUserId;
    }

    public void setBidUserId(Set<String> bidUserId) {
        this.bidUserId = bidUserId;
    }

    public void setOfferUserId(Set<String> offerUserId) {
        this.offerUserId = offerUserId;
    }

    public void addBidUserId(String bidUserId) {
        this.bidUserId.add(bidUserId);
    }

    public Set<String> getOfferUserId() {
        return this.offerUserId;
    }

    public void addOfferUserId(String offerUserId) {
        this.offerUserId.add(offerUserId);
    }
}

