/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PMarketData;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.marketdata.dto.MDEntry;
import cms.tmx.javafx.obj.MxClrObj;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class HandicapInfo
extends MxClrObj {
    private DoubleProperty price = new SimpleDoubleProperty();
    private IntegerProperty count = new SimpleIntegerProperty();
    private IntegerProperty order = new SimpleIntegerProperty();
    private int index;
    private DoubleProperty yield = new SimpleDoubleProperty();
    private DoubleProperty yield1 = new SimpleDoubleProperty();
    private DoubleProperty yield2 = new SimpleDoubleProperty();
    private IntegerProperty unMatchQty = new SimpleIntegerProperty();
    private IntegerProperty sumQty = new SimpleIntegerProperty();
    private StringProperty unMatchQtyStr = new SimpleStringProperty("");
    private StringProperty priceStr = new SimpleStringProperty("");
    private StringProperty sumQtyStr = new SimpleStringProperty("");
    private StringProperty countStr = new SimpleStringProperty("");
    private StringProperty orderStr = new SimpleStringProperty("");
    private String traderId;
    private Boolean self = false;

    public void update(Object obj) {
        if (obj instanceof HandicapInfo) {
            this.update((HandicapInfo)((Object)HandicapInfo.class.cast(obj)));
        }
    }

    private void update(HandicapInfo info) {
        this.setCount(info.getCount());
        this.setPrice(info.getPrice());
        this.setPriceStr(info.getPriceStr().equals("") ? "0" : info.getPriceStr());
        this.setYield(info.getYield());
        this.setYield1(info.getYield1());
        this.setYield2(info.getYield2());
        this.setUnMatchQty(info.getUnMatchQty());
        this.setUnMatchQtyStr(String.valueOf(info.getUnMatchQty() / 10000000));
        this.setSumQty(info.getUnMatchQty() + info.getCount());
        this.setSumQtyStr(String.valueOf(info.getSumQty() / 10000000));
        this.setCountStr(String.valueOf(info.getCount() / 10000000));
        this.setOrderStr(String.valueOf(info.getOrder() / 10000000));
        this.setTraderId(info.getTraderId());
        this.clearCheck();
    }

    public boolean updata(PMarketData.MDEntry entry, RefItem refItem) {
        this.setCount(entry.getMdEntrySize());
        double price = this.getPrice(entry.getMdEntryPx(), refItem);
        boolean change = false;
        if (this.getPrice() != price) {
            this.setPrice(price);
            this.setPriceStr(String.valueOf(this.getPrice()));
            change = true;
        }
        this.clearCheck();
        return change;
    }

    public void updata(MDEntry entry, RefItem refItem) {
        if (refItem.getType().equals("BOND") && "XcfeXBond".equals(refItem.getSubSecurityType())) {
            this.setCount((int)Math.round(entry.getMdEntrySize() / 10000.0));
        } else if ((refItem.getType().equals("SBFWD") || refItem.getType().equals("FORWARD")) && "XcfeXSwap".equals(refItem.getSubSecurityType())) {
            this.setCount((int)Math.round(entry.getMdEntrySize() / 10000.0));
        } else {
            this.setCount((int)Math.round(entry.getMdEntrySize()));
        }
        double entryPx = entry.getMdEntryPx() == null ? 0.0 : entry.getMdEntryPx();
        this.setPrice(this.getPriceNew(entryPx, refItem));
        this.setPriceStr(String.valueOf(this.getPrice()));
        if (entry.getYieldData() != null) {
            double yield = entry.getYieldData().getYield();
            this.setYield((double)Math.round(yield * 1000000.0) / 10000.0);
        }
        this.setUnMatchQty(entry.getUnMatchQty());
        this.setUnMatchQtyStr(String.valueOf((double)entry.getUnMatchQty() / 1.0E7));
        this.setSumQty(entry.getUnMatchQty() + (int)Math.round(entry.getMdEntrySize() / 10000.0));
        this.setSumQtyStr(String.valueOf((entry.getUnMatchQty() + (int)Math.round(entry.getMdEntrySize() / 10000.0)) / 10000000));
        this.clearCheck();
    }

    public void updataDepth(MDEntry entry, RefItem refItem, int deliver) {
        if (entry.getYieldData() != null) {
            double yield = entry.getYieldData().getYield();
            yield = (double)Math.round(yield * 1000000.0) / 10000.0;
            if (deliver == 1) {
                this.setYield1(yield);
            } else if (deliver == 2) {
                this.setYield2(yield);
            }
        }
    }

    private double getPrice(int px, RefItem item) {
        double entryPx = (double)px / 10000.0;
        BigDecimal bd = new BigDecimal(entryPx);
        double price = bd.setScale(item.getScale(), RoundingMode.HALF_UP).doubleValue();
        return price;
    }

    private double getPriceNew(double px, RefItem item) {
        double entryPx = px;
        double conPrice = 0.0;
        BigDecimal bd = new BigDecimal(entryPx);
        if (entryPx < 0.0) {
            entryPx = Math.abs(entryPx);
            conPrice = bd.setScale(3, 4).doubleValue();
        }
        double price = bd.setScale(item.getScale(), RoundingMode.HALF_UP).doubleValue();
        if (item.getType().equals("SBFWD") || item.getType().equals("FORWARD")) {
            price = bd.setScale(3, RoundingMode.HALF_UP).doubleValue();
        }
        if (item.getType().equals("STOCKXHKG")) {
            price = bd.setScale(3, RoundingMode.HALF_UP).doubleValue();
        }
        return px > 0.0 ? price : conPrice;
    }

    private void clearCheck() {
        if (this.getCount() == 0 && this.getPrice() <= 0.0) {
            this.setClear(true);
        } else {
            this.setClear(false);
        }
    }

    public void clear() {
        this.setCount(-1);
        this.setPrice(-1.0);
        this.setPriceStr("");
        this.setYield(0.0);
        this.setYield1(0.0);
        this.setYield2(0.0);
        this.setClear(true);
        this.setSumQty(-1);
        this.setSumQtyStr("");
        this.setTraderId("");
        this.setOrderStr("");
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public IntegerProperty countProperty() {
        return this.count;
    }

    public int getCount() {
        return this.countProperty().get();
    }

    public void setCount(int count) {
        this.countProperty().set(count);
    }

    public String toString() {
        return "HandicapInfo [price=" + this.price + ", count=" + this.count + ", index=" + this.index + "]";
    }

    public StringProperty priceStrProperty() {
        return this.priceStr;
    }

    public String getPriceStr() {
        return (String)this.priceStrProperty().get();
    }

    public void setPriceStr(String priceStr) {
        this.priceStrProperty().set((Object)priceStr);
    }

    public final IntegerProperty orderProperty() {
        return this.order;
    }

    public final int getOrder() {
        return this.orderProperty().get();
    }

    public final void setOrder(int order) {
        this.orderProperty().set(order);
    }

    public final DoubleProperty yieldProperty() {
        return this.yield;
    }

    public final double getYield() {
        return this.yieldProperty().get();
    }

    public final void setYield(double yield) {
        this.yieldProperty().set(yield);
    }

    public final IntegerProperty unMatchQtyProperty() {
        return this.unMatchQty;
    }

    public final int getUnMatchQty() {
        return this.unMatchQtyProperty().get();
    }

    public final void setUnMatchQty(int unMatchQty) {
        this.unMatchQtyProperty().set(unMatchQty);
    }

    public final IntegerProperty sumQtyProperty() {
        return this.sumQty;
    }

    public final int getSumQty() {
        return this.sumQtyProperty().get();
    }

    public final void setSumQty(int sumQty) {
        this.sumQtyProperty().set(sumQty);
    }

    public final StringProperty sumQtyStrProperty() {
        return this.sumQtyStr;
    }

    public final String getSumQtyStr() {
        return (String)this.sumQtyStrProperty().get();
    }

    public final void setSumQtyStr(String sumQtyStr) {
        this.sumQtyStrProperty().set((Object)sumQtyStr);
    }

    public final StringProperty countStrProperty() {
        return this.countStr;
    }

    public final String getCountStr() {
        return (String)this.countStrProperty().get();
    }

    public final void setCountStr(String countStr) {
        this.countStrProperty().set((Object)countStr);
    }

    public final StringProperty orderStrProperty() {
        return this.orderStr;
    }

    public final String getOrderStr() {
        return (String)this.orderStrProperty().get();
    }

    public final void setOrderStr(String orderStr) {
        this.orderStrProperty().set((Object)orderStr);
    }

    public final StringProperty unMatchQtyStrProperty() {
        return this.unMatchQtyStr;
    }

    public final String getUnMatchQtyStr() {
        return (String)this.unMatchQtyStrProperty().get();
    }

    public final void setUnMatchQtyStr(String unMatchQtyStr) {
        this.unMatchQtyStrProperty().set((Object)unMatchQtyStr);
    }

    public final DoubleProperty yield2Property() {
        return this.yield2;
    }

    public final double getYield2() {
        return this.yield2Property().get();
    }

    public final void setYield2(double yield2) {
        this.yield2Property().set(yield2);
    }

    public final DoubleProperty yield1Property() {
        return this.yield1;
    }

    public final double getYield1() {
        return this.yield1Property().get();
    }

    public final void setYield1(double yield1) {
        this.yield1Property().set(yield1);
    }

    public Boolean isSelf() {
        return this.self;
    }

    public void setSelf(Boolean self) {
        this.self = self;
    }

    public String getTraderId() {
        return this.traderId;
    }

    public void setTraderId(String traderId) {
        this.traderId = traderId;
    }
}

