/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PCtpRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.security.dto.FutureInfo;
import com.google.protobuf.Any;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CtpRefItem
extends RefItem {
    private StringProperty productId = new SimpleStringProperty("");
    private StringProperty productClass = new SimpleStringProperty("");
    private StringProperty deliveryYear = new SimpleStringProperty("");
    private StringProperty deliveryMonth = new SimpleStringProperty("");
    private StringProperty maxMarketOrderVolume = new SimpleStringProperty("");
    private StringProperty minMarketOrderVolume = new SimpleStringProperty("");
    private DoubleProperty maxLimitOrderVolume = new SimpleDoubleProperty();
    private DoubleProperty minLimitOrderVolume = new SimpleDoubleProperty();
    private IntegerProperty volumeMultiple = new SimpleIntegerProperty();
    private DoubleProperty priceTick = new SimpleDoubleProperty();
    private StringProperty createDate = new SimpleStringProperty();
    private StringProperty openDate = new SimpleStringProperty();
    private StringProperty expireDate = new SimpleStringProperty();
    private StringProperty startDeliveryDate = new SimpleStringProperty();
    private StringProperty endDeliveryDate = new SimpleStringProperty();
    private IntegerProperty instLifePhase = new SimpleIntegerProperty();
    private IntegerProperty isTrading = new SimpleIntegerProperty();
    private IntegerProperty positioType = new SimpleIntegerProperty();
    private IntegerProperty positionDateType = new SimpleIntegerProperty();
    private DoubleProperty longMarginRatio = new SimpleDoubleProperty();
    private DoubleProperty shortMarginRatio = new SimpleDoubleProperty();
    private IntegerProperty maxMarginSideAlgorithm = new SimpleIntegerProperty();
    private StringProperty underlyingInstrId = new SimpleStringProperty();
    private DoubleProperty strikePrice = new SimpleDoubleProperty();
    private IntegerProperty optionsType = new SimpleIntegerProperty();
    private DoubleProperty underlyingMultiple = new SimpleDoubleProperty();
    private IntegerProperty combinationType = new SimpleIntegerProperty();
    private StringProperty brokerId = new SimpleStringProperty();
    private DoubleProperty longMarginVolume = new SimpleDoubleProperty();
    private DoubleProperty shortMarginVolume = new SimpleDoubleProperty();
    private StringProperty openRatio = new SimpleStringProperty();
    private DoubleProperty openVolume = new SimpleDoubleProperty();
    private DoubleProperty closeRatio = new SimpleDoubleProperty();
    private DoubleProperty closeVolume = new SimpleDoubleProperty();
    private DoubleProperty closeTodayRatio = new SimpleDoubleProperty();
    private DoubleProperty closeTodayVolume = new SimpleDoubleProperty();
    private DoubleProperty listedBasePrice = new SimpleDoubleProperty();
    private DoubleProperty priceUpRate = new SimpleDoubleProperty();
    private DoubleProperty priceDownRate = new SimpleDoubleProperty();
    private DoubleProperty settlementPrice = new SimpleDoubleProperty();
    private DoubleProperty closeTodayDiscountRate = new SimpleDoubleProperty();
    private DoubleProperty deliverySettPrice = new SimpleDoubleProperty();
    private DoubleProperty deliveryMarginRate = new SimpleDoubleProperty();
    private DoubleProperty deliveryFeeRate = new SimpleDoubleProperty();
    private DoubleProperty deliveryFeeVolume = new SimpleDoubleProperty();
    private IntegerProperty lastDealQty = new SimpleIntegerProperty();
    private DoubleProperty lastPositionQty = new SimpleDoubleProperty();
    private IntegerProperty mainContract = new SimpleIntegerProperty();
    private static final Logger logger = LogManager.getLogger(RefItem.class);

    @Override
    public void update(Object obj) {
        super.update(obj);
        if (obj instanceof PRefData.SecListItem) {
            try {
                PRefData.SecListItem refData = (PRefData.SecListItem)PRefData.SecListItem.class.cast(obj);
                Any any = refData.getObject();
                if (any.is(PCtpRefdata.RefDataExtraCTP.class)) {
                    PCtpRefdata.RefDataExtraCTP ctp = (PCtpRefdata.RefDataExtraCTP)any.unpack(PCtpRefdata.RefDataExtraCTP.class);
                    this.updateCTP(ctp);
                    this.changed();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        } else if (obj instanceof FutureInfo) {
            this.update((FutureInfo)FutureInfo.class.cast(obj));
        }
    }

    private void updateCTP(PCtpRefdata.RefDataExtraCTP ctp) {
        this.setProductId(ctp.getProductId());
        this.setPriceTick(ctp.getPriceTick());
        int minMarket = (int)ctp.getMinMarketOrderVolume();
        int maxMarket = (int)ctp.getMaxMarketOrderVolume();
        this.setMinMarketOrderVolume(Integer.toString(minMarket));
        this.setMaxMarketOrderVolume(Integer.toString(maxMarket));
        this.setOpenDate(ctp.getOpenDate());
        this.setExpireDate(ctp.getExpireDate());
        this.setUnderlyingMultiple(ctp.getUnderlyingMultiple() == 0.0 ? 1.0 : ctp.getUnderlyingMultiple());
        this.setStartDeliveryDate(ctp.getStartDeliveryDate());
        this.setEndDeliveryDate(ctp.getEndDeliveryDate());
        this.setListedBasePrice(ctp.getListedBasePrice());
        BigDecimal bd = new BigDecimal(ctp.getOpenRatio() * 100.0);
        this.setOpenRatio(bd.setScale(3, 4).toPlainString());
        this.setOpenVolume(ctp.getOpenVolume());
        this.setLongMarginRatio(ctp.getLongMarginRatio());
        this.setShortMarginRatio(ctp.getShortMarginRatio());
        this.setVolumeMultiple(ctp.getVolumeMultiple() == 0.0 ? 1 : (int)ctp.getVolumeMultiple());
        this.setBrokerId(ctp.getBrokerId());
        this.setMainContract(ctp.getIsMainContract());
        this.setLastDealQty(ctp.getVolume());
        this.setLastPositionQty(ctp.getOpenInterest());
    }

    private void update(FutureInfo info) {
        this.setListedBasePrice(info.getFutureStat().getListedBasePrice());
        this.setMainContract(info.getFutureStat().getIsMainContract() == null || info.getFutureStat().getIsMainContract() == false ? 0 : 1);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.brokerId.get() == null ? 0 : ((String)this.brokerId.get()).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CtpRefItem other = (CtpRefItem)((Object)obj);
        return !(this.brokerId.get() == null ? other.brokerId.get() != null : !((String)this.brokerId.get()).equals(other.brokerId.get()));
    }

    public final StringProperty productIdProperty() {
        return this.productId;
    }

    public final String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public final void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public final StringProperty productClassProperty() {
        return this.productClass;
    }

    public final String getProductClass() {
        return (String)this.productClassProperty().get();
    }

    public final void setProductClass(String productClass) {
        this.productClassProperty().set((Object)productClass);
    }

    public final StringProperty deliveryYearProperty() {
        return this.deliveryYear;
    }

    public final String getDeliveryYear() {
        return (String)this.deliveryYearProperty().get();
    }

    public final void setDeliveryYear(String deliveryYear) {
        this.deliveryYearProperty().set((Object)deliveryYear);
    }

    public final StringProperty deliveryMonthProperty() {
        return this.deliveryMonth;
    }

    public final String getDeliveryMonth() {
        return (String)this.deliveryMonthProperty().get();
    }

    public final void setDeliveryMonth(String deliveryMonth) {
        this.deliveryMonthProperty().set((Object)deliveryMonth);
    }

    public final DoubleProperty maxLimitOrderVolumeProperty() {
        return this.maxLimitOrderVolume;
    }

    public final double getMaxLimitOrderVolume() {
        return this.maxLimitOrderVolumeProperty().get();
    }

    public final void setMaxLimitOrderVolume(double maxLimitOrderVolume) {
        this.maxLimitOrderVolumeProperty().set(maxLimitOrderVolume);
    }

    public final DoubleProperty minLimitOrderVolumeProperty() {
        return this.minLimitOrderVolume;
    }

    public final double getMinLimitOrderVolume() {
        return this.minLimitOrderVolumeProperty().get();
    }

    public final void setMinLimitOrderVolume(double minLimitOrderVolume) {
        this.minLimitOrderVolumeProperty().set(minLimitOrderVolume);
    }

    public final IntegerProperty volumeMultipleProperty() {
        return this.volumeMultiple;
    }

    public final int getVolumeMultiple() {
        return this.volumeMultipleProperty().get();
    }

    public final void setVolumeMultiple(int volumeMultiple) {
        this.volumeMultipleProperty().set(volumeMultiple);
    }

    public final DoubleProperty priceTickProperty() {
        return this.priceTick;
    }

    @Override
    public final double getPriceTick() {
        return this.priceTickProperty().get();
    }

    @Override
    public final void setPriceTick(double priceTick) {
        this.priceTickProperty().set(priceTick);
    }

    public final StringProperty createDateProperty() {
        return this.createDate;
    }

    public final String getCreateDate() {
        return (String)this.createDateProperty().get();
    }

    public final void setCreateDate(String createDate) {
        this.createDateProperty().set((Object)createDate);
    }

    public final StringProperty openDateProperty() {
        return this.openDate;
    }

    public final String getOpenDate() {
        return (String)this.openDateProperty().get();
    }

    public final void setOpenDate(String openDate) {
        this.openDateProperty().set((Object)openDate);
    }

    public final StringProperty expireDateProperty() {
        return this.expireDate;
    }

    public final String getExpireDate() {
        return (String)this.expireDateProperty().get();
    }

    public final void setExpireDate(String expireDate) {
        this.expireDateProperty().set((Object)expireDate);
    }

    public final StringProperty startDeliveryDateProperty() {
        return this.startDeliveryDate;
    }

    public final String getStartDeliveryDate() {
        return (String)this.startDeliveryDateProperty().get();
    }

    public final void setStartDeliveryDate(String startDeliveryDate) {
        this.startDeliveryDateProperty().set((Object)startDeliveryDate);
    }

    public final StringProperty endDeliveryDateProperty() {
        return this.endDeliveryDate;
    }

    public final String getEndDeliveryDate() {
        return (String)this.endDeliveryDateProperty().get();
    }

    public final void setEndDeliveryDate(String endDeliveryDate) {
        this.endDeliveryDateProperty().set((Object)endDeliveryDate);
    }

    public final IntegerProperty instLifePhaseProperty() {
        return this.instLifePhase;
    }

    public final int getInstLifePhase() {
        return this.instLifePhaseProperty().get();
    }

    public final void setInstLifePhase(int instLifePhase) {
        this.instLifePhaseProperty().set(instLifePhase);
    }

    public final IntegerProperty isTradingProperty() {
        return this.isTrading;
    }

    public final int getIsTrading() {
        return this.isTradingProperty().get();
    }

    public final void setIsTrading(int isTrading) {
        this.isTradingProperty().set(isTrading);
    }

    public final IntegerProperty positioTypeProperty() {
        return this.positioType;
    }

    public final int getPositioType() {
        return this.positioTypeProperty().get();
    }

    public final void setPositioType(int positioType) {
        this.positioTypeProperty().set(positioType);
    }

    public final IntegerProperty positionDateTypeProperty() {
        return this.positionDateType;
    }

    public final int getPositionDateType() {
        return this.positionDateTypeProperty().get();
    }

    public final void setPositionDateType(int positionDateType) {
        this.positionDateTypeProperty().set(positionDateType);
    }

    public final DoubleProperty longMarginRatioProperty() {
        return this.longMarginRatio;
    }

    public final double getLongMarginRatio() {
        return this.longMarginRatioProperty().get();
    }

    public final void setLongMarginRatio(double longMarginRatio) {
        this.longMarginRatioProperty().set(longMarginRatio);
    }

    public final DoubleProperty shortMarginRatioProperty() {
        return this.shortMarginRatio;
    }

    public final double getShortMarginRatio() {
        return this.shortMarginRatioProperty().get();
    }

    public final void setShortMarginRatio(double shortMarginRatio) {
        this.shortMarginRatioProperty().set(shortMarginRatio);
    }

    public final IntegerProperty maxMarginSideAlgorithmProperty() {
        return this.maxMarginSideAlgorithm;
    }

    public final int getMaxMarginSideAlgorithm() {
        return this.maxMarginSideAlgorithmProperty().get();
    }

    public final void setMaxMarginSideAlgorithm(int maxMarginSideAlgorithm) {
        this.maxMarginSideAlgorithmProperty().set(maxMarginSideAlgorithm);
    }

    public final StringProperty underlyingInstrIdProperty() {
        return this.underlyingInstrId;
    }

    public final String getUnderlyingInstrId() {
        return (String)this.underlyingInstrIdProperty().get();
    }

    public final void setUnderlyingInstrId(String underlyingInstrId) {
        this.underlyingInstrIdProperty().set((Object)underlyingInstrId);
    }

    public final DoubleProperty strikePriceProperty() {
        return this.strikePrice;
    }

    public final double getStrikePrice() {
        return this.strikePriceProperty().get();
    }

    public final void setStrikePrice(double strikePrice) {
        this.strikePriceProperty().set(strikePrice);
    }

    public final IntegerProperty optionsTypeProperty() {
        return this.optionsType;
    }

    public final int getOptionsType() {
        return this.optionsTypeProperty().get();
    }

    public final void setOptionsType(int optionsType) {
        this.optionsTypeProperty().set(optionsType);
    }

    public final DoubleProperty underlyingMultipleProperty() {
        return this.underlyingMultiple;
    }

    public final double getUnderlyingMultiple() {
        return this.underlyingMultipleProperty().get();
    }

    public final void setUnderlyingMultiple(double underlyingMultiple) {
        this.underlyingMultipleProperty().set(underlyingMultiple);
    }

    public final IntegerProperty combinationTypeProperty() {
        return this.combinationType;
    }

    public final int getCombinationType() {
        return this.combinationTypeProperty().get();
    }

    public final void setCombinationType(int combinationType) {
        this.combinationTypeProperty().set(combinationType);
    }

    public final StringProperty brokerIdProperty() {
        return this.brokerId;
    }

    public final String getBrokerId() {
        return (String)this.brokerIdProperty().get();
    }

    public final void setBrokerId(String brokerId) {
        this.brokerIdProperty().set((Object)brokerId);
    }

    public final DoubleProperty longMarginVolumeProperty() {
        return this.longMarginVolume;
    }

    public final double getLongMarginVolume() {
        return this.longMarginVolumeProperty().get();
    }

    public final void setLongMarginVolume(double longMarginVolume) {
        this.longMarginVolumeProperty().set(longMarginVolume);
    }

    public final DoubleProperty shortMarginVolumeProperty() {
        return this.shortMarginVolume;
    }

    public final double getShortMarginVolume() {
        return this.shortMarginVolumeProperty().get();
    }

    public final void setShortMarginVolume(double shortMarginVolume) {
        this.shortMarginVolumeProperty().set(shortMarginVolume);
    }

    public final StringProperty openRatioProperty() {
        return this.openRatio;
    }

    public final String getOpenRatio() {
        return (String)this.openRatioProperty().get();
    }

    public final void setOpenRatio(String openRatio) {
        this.openRatioProperty().set((Object)openRatio);
    }

    public final DoubleProperty openVolumeProperty() {
        return this.openVolume;
    }

    public final double getOpenVolume() {
        return this.openVolumeProperty().get();
    }

    public final void setOpenVolume(double openVolume) {
        this.openVolumeProperty().set(openVolume);
    }

    public final DoubleProperty closeRatioProperty() {
        return this.closeRatio;
    }

    public final double getCloseRatio() {
        return this.closeRatioProperty().get();
    }

    public final void setCloseRatio(double closeRatio) {
        this.closeRatioProperty().set(closeRatio);
    }

    public final DoubleProperty closeVolumeProperty() {
        return this.closeVolume;
    }

    public final double getCloseVolume() {
        return this.closeVolumeProperty().get();
    }

    public final void setCloseVolume(double closeVolume) {
        this.closeVolumeProperty().set(closeVolume);
    }

    public final DoubleProperty closeTodayRatioProperty() {
        return this.closeTodayRatio;
    }

    public final double getCloseTodayRatio() {
        return this.closeTodayRatioProperty().get();
    }

    public final void setCloseTodayRatio(double closeTodayRatio) {
        this.closeTodayRatioProperty().set(closeTodayRatio);
    }

    public final DoubleProperty closeTodayVolumeProperty() {
        return this.closeTodayVolume;
    }

    public final double getCloseTodayVolume() {
        return this.closeTodayVolumeProperty().get();
    }

    public final void setCloseTodayVolume(double closeTodayVolume) {
        this.closeTodayVolumeProperty().set(closeTodayVolume);
    }

    public final DoubleProperty listedBasePriceProperty() {
        return this.listedBasePrice;
    }

    public final double getListedBasePrice() {
        return this.listedBasePriceProperty().get();
    }

    public final void setListedBasePrice(double listedBasePrice) {
        this.listedBasePriceProperty().set(listedBasePrice);
    }

    public final DoubleProperty settlementPriceProperty() {
        return this.settlementPrice;
    }

    public final double getSettlementPrice() {
        return this.settlementPriceProperty().get();
    }

    public final void setSettlementPrice(double settlementPrice) {
        this.settlementPriceProperty().set(settlementPrice);
    }

    public final DoubleProperty closeTodayDiscountRateProperty() {
        return this.closeTodayDiscountRate;
    }

    public final double getCloseTodayDiscountRate() {
        return this.closeTodayDiscountRateProperty().get();
    }

    public final void setCloseTodayDiscountRate(double closeTodayDiscountRate) {
        this.closeTodayDiscountRateProperty().set(closeTodayDiscountRate);
    }

    public final DoubleProperty deliverySettPriceProperty() {
        return this.deliverySettPrice;
    }

    public final double getDeliverySettPrice() {
        return this.deliverySettPriceProperty().get();
    }

    public final void setDeliverySettPrice(double deliverySettPrice) {
        this.deliverySettPriceProperty().set(deliverySettPrice);
    }

    public final DoubleProperty deliveryMarginRateProperty() {
        return this.deliveryMarginRate;
    }

    public final double getDeliveryMarginRate() {
        return this.deliveryMarginRateProperty().get();
    }

    public final void setDeliveryMarginRate(double deliveryMarginRate) {
        this.deliveryMarginRateProperty().set(deliveryMarginRate);
    }

    public final DoubleProperty deliveryFeeRateProperty() {
        return this.deliveryFeeRate;
    }

    public final double getDeliveryFeeRate() {
        return this.deliveryFeeRateProperty().get();
    }

    public final void setDeliveryFeeRate(double deliveryFeeRate) {
        this.deliveryFeeRateProperty().set(deliveryFeeRate);
    }

    public final DoubleProperty deliveryFeeVolumeProperty() {
        return this.deliveryFeeVolume;
    }

    public final double getDeliveryFeeVolume() {
        return this.deliveryFeeVolumeProperty().get();
    }

    public final void setDeliveryFeeVolume(double deliveryFeeVolume) {
        this.deliveryFeeVolumeProperty().set(deliveryFeeVolume);
    }

    public final DoubleProperty priceUpRateProperty() {
        return this.priceUpRate;
    }

    public final double getPriceUpRate() {
        return this.priceUpRateProperty().get();
    }

    public final void setPriceUpRate(double priceUpRate) {
        this.priceUpRateProperty().set(priceUpRate);
    }

    public final DoubleProperty priceDownRateProperty() {
        return this.priceDownRate;
    }

    public final double getPriceDownRate() {
        return this.priceDownRateProperty().get();
    }

    public final void setPriceDownRate(double priceDownRate) {
        this.priceDownRateProperty().set(priceDownRate);
    }

    public final StringProperty maxMarketOrderVolumeProperty() {
        return this.maxMarketOrderVolume;
    }

    public final String getMaxMarketOrderVolume() {
        return (String)this.maxMarketOrderVolumeProperty().get();
    }

    public final void setMaxMarketOrderVolume(String maxMarketOrderVolume) {
        this.maxMarketOrderVolumeProperty().set((Object)maxMarketOrderVolume);
    }

    public final StringProperty minMarketOrderVolumeProperty() {
        return this.minMarketOrderVolume;
    }

    public final String getMinMarketOrderVolume() {
        return (String)this.minMarketOrderVolumeProperty().get();
    }

    public final void setMinMarketOrderVolume(String minMarketOrderVolume) {
        this.minMarketOrderVolumeProperty().set((Object)minMarketOrderVolume);
    }

    public final IntegerProperty lastDealQtyProperty() {
        return this.lastDealQty;
    }

    public final int getLastDealQty() {
        return this.lastDealQtyProperty().get();
    }

    public final void setLastDealQty(int lastDealQty) {
        this.lastDealQtyProperty().set(lastDealQty);
    }

    public final DoubleProperty lastPositionQtyProperty() {
        return this.lastPositionQty;
    }

    public final double getLastPositionQty() {
        return this.lastPositionQtyProperty().get();
    }

    public final void setLastPositionQty(double lastPositionQty) {
        this.lastPositionQtyProperty().set(lastPositionQty);
    }

    public final IntegerProperty mainContractProperty() {
        return this.mainContract;
    }

    public final int getMainContract() {
        return this.mainContractProperty().get();
    }

    public final void setMainContract(int mainContract) {
        this.mainContractProperty().set(mainContract);
    }
}

