/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.data;

import cms.tmx.datatype.message.PContractService;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.entity.data.Contract;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpContract
extends Contract {
    private String brokerId = "";
    private Double volumeMultiple;
    private Double underlyingMultiple;
    private StringProperty investorId = new SimpleStringProperty("");
    private DoubleProperty longMarginRatio = new SimpleDoubleProperty(0.0);
    private DoubleProperty shortMarginRatio = new SimpleDoubleProperty(0.0);
    private DoubleProperty longMarginVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty shortMarginVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty openVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty openRatio = new SimpleDoubleProperty(0.0);
    private DoubleProperty closeVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty closeRatio = new SimpleDoubleProperty(0.0);
    private DoubleProperty closeTodayVolume = new SimpleDoubleProperty(0.0);
    private DoubleProperty closeTodayRatio = new SimpleDoubleProperty(0.0);
    private static final Logger logger = LogManager.getLogger(CtpContract.class);

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.brokerId == null ? 0 : this.brokerId.hashCode());
        result = 31 * result + (this.investorId == null ? 0 : this.investorId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CtpContract other = (CtpContract)((Object)obj);
        if (this.brokerId == null ? other.brokerId != null : !this.brokerId.equals(other.brokerId)) {
            return false;
        }
        return !(this.investorId == null ? other.investorId != null : !this.investorId.equals(other.investorId));
    }

    @Override
    public void update(Object obj) {
        try {
            super.update(obj);
            if (obj instanceof PContractService.Contract) {
                PContractService.Contract con = (PContractService.Contract)PContractService.Contract.class.cast(obj);
                PCtpExtra.CTPContract co = (PCtpExtra.CTPContract)con.getObject().unpack(PCtpExtra.CTPContract.class);
                this.update(co);
            } else if (obj instanceof Contract) {
                CtpContract co = (CtpContract)((Object)CtpContract.class.cast(obj));
                this.update(co);
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage());
        }
    }

    private void update(PCtpExtra.CTPContract co) {
        this.setBrokerId(co.getBrokerId());
        this.setInvestorId(co.getInvestorId());
        this.setVolumeMultiple(co.getVolumeMultiple() == 0.0 ? 1.0 : co.getVolumeMultiple());
        this.setLongMarginRatio(co.getLongMarginRatio());
        this.setLongMarginVolume(co.getLongMarginVolume());
        this.setShortMarginRatio(co.getShortMarginRatio());
        this.setShortMarginVolume(co.getShortMarginVolume());
        this.setUnderlyingMultiple(co.getUnderlyingMultiple() == 0.0 ? 1.0 : co.getUnderlyingMultiple());
        this.setOpenVolume(co.getOpenVolume());
        this.setOpenRatio(co.getOpenRatio());
        this.setCloseVolume(co.getCloseVolume());
        this.setCloseRatio(co.getCloseRatio());
        this.setCloseTodayVolume(co.getCloseTodayVolume());
        this.setCloseTodayRatio(co.getCloseTodayRatio());
    }

    private void update(CtpContract co) {
        this.setBrokerId(co.getBrokerId());
        this.setInvestorId(co.getInvestorId());
        this.setVolumeMultiple(co.getVolumeMultiple());
        this.setLongMarginRatio(co.getLongMarginRatio());
        this.setLongMarginVolume(co.getLongMarginVolume());
        this.setShortMarginRatio(co.getShortMarginRatio());
        this.setShortMarginVolume(co.getShortMarginVolume());
        this.setUnderlyingMultiple(co.getUnderlyingMultiple());
        this.setOpenVolume(co.getOpenVolume());
        this.setOpenRatio(co.getOpenRatio());
        this.setCloseVolume(co.getCloseVolume());
        this.setCloseRatio(co.getCloseRatio());
        this.setCloseTodayVolume(co.getCloseTodayVolume());
        this.setCloseTodayRatio(co.getCloseTodayRatio());
    }

    public Double getVolumeMultiple() {
        return this.volumeMultiple;
    }

    public void setVolumeMultiple(Double volumeMultiple) {
        this.volumeMultiple = volumeMultiple;
    }

    public Double getUnderlyingMultiple() {
        return this.underlyingMultiple;
    }

    public void setUnderlyingMultiple(Double underlyingMultiple) {
        this.underlyingMultiple = underlyingMultiple;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final DoubleProperty longMarginRatioProperty() {
        return this.longMarginRatio;
    }

    public final double getLongMarginRatio() {
        return this.longMarginRatioProperty().get();
    }

    public final void setLongMarginRatio(double longMarginRatio) {
        this.longMarginRatioProperty().set(longMarginRatio);
    }

    public final DoubleProperty shortMarginRatioProperty() {
        return this.shortMarginRatio;
    }

    public final double getShortMarginRatio() {
        return this.shortMarginRatioProperty().get();
    }

    public final void setShortMarginRatio(double shortMarginRatio) {
        this.shortMarginRatioProperty().set(shortMarginRatio);
    }

    public final DoubleProperty openVolumeProperty() {
        return this.openVolume;
    }

    public final double getOpenVolume() {
        return this.openVolumeProperty().get();
    }

    public final void setOpenVolume(double openVolume) {
        this.openVolumeProperty().set(openVolume);
    }

    public final DoubleProperty closeVolumeProperty() {
        return this.closeVolume;
    }

    public final double getCloseVolume() {
        return this.closeVolumeProperty().get();
    }

    public final void setCloseVolume(double closeVolume) {
        this.closeVolumeProperty().set(closeVolume);
    }

    public final DoubleProperty closeTodayVolumeProperty() {
        return this.closeTodayVolume;
    }

    public final double getCloseTodayVolume() {
        return this.closeTodayVolumeProperty().get();
    }

    public final void setCloseTodayVolume(double closeTodayVolume) {
        this.closeTodayVolumeProperty().set(closeTodayVolume);
    }

    public final DoubleProperty longMarginVolumeProperty() {
        return this.longMarginVolume;
    }

    public final double getLongMarginVolume() {
        return this.longMarginVolumeProperty().get();
    }

    public final void setLongMarginVolume(double longMarginVolume) {
        this.longMarginVolumeProperty().set(longMarginVolume);
    }

    public final DoubleProperty shortMarginVolumeProperty() {
        return this.shortMarginVolume;
    }

    public final double getShortMarginVolume() {
        return this.shortMarginVolumeProperty().get();
    }

    public final void setShortMarginVolume(double shortMarginVolume) {
        this.shortMarginVolumeProperty().set(shortMarginVolume);
    }

    public final DoubleProperty openRatioProperty() {
        return this.openRatio;
    }

    public final double getOpenRatio() {
        return this.openRatioProperty().get();
    }

    public final void setOpenRatio(double openRatio) {
        this.openRatioProperty().set(openRatio);
    }

    public final DoubleProperty closeRatioProperty() {
        return this.closeRatio;
    }

    public final double getCloseRatio() {
        return this.closeRatioProperty().get();
    }

    public final void setCloseRatio(double closeRatio) {
        this.closeRatioProperty().set(closeRatio);
    }

    public final DoubleProperty closeTodayRatioProperty() {
        return this.closeTodayRatio;
    }

    public final double getCloseTodayRatio() {
        return this.closeTodayRatioProperty().get();
    }

    public final void setCloseTodayRatio(double closeTodayRatio) {
        this.closeTodayRatioProperty().set(closeTodayRatio);
    }
}

