/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity.app;

import cms.tmx.app.models.IIndexInfo;
import cms.tmx.datatype.message.PMarketData;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class IndexInfo
extends MxObject
implements IIndexInfo {
    private StringProperty code = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty rise = new SimpleDoubleProperty();
    private DoubleProperty deal = new SimpleDoubleProperty();

    public void update(Object obj) {
        if (obj instanceof PMarketData.MarketDataSnapshot) {
            this.update((PMarketData.MarketDataSnapshot)PMarketData.MarketDataSnapshot.class.cast(obj));
        }
    }

    public void update(PMarketData.MarketDataSnapshot snap) {
        for (PMarketData.MarketIndexSnapshot index : snap.getIndexSnapList()) {
            this.setCode(snap.getInstrument().getSecurityId());
            this.setPrice((double)index.getLastIndex() / 10000.0);
            this.setRise((double)index.getLastIndex() / 10000.0 - (double)index.getPreCloseIndex() / 10000.0);
            if (this.getPrice() == 0.0) {
                this.setPrice((double)index.getPreCloseIndex() / 10000.0);
                this.setRise(0.0);
            }
            this.setDeal((double)index.getTurnOver() / 1000000.0);
        }
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty riseProperty() {
        return this.rise;
    }

    public final double getRise() {
        return this.riseProperty().get();
    }

    public final void setRise(double rise) {
        this.riseProperty().set(rise);
    }

    public final DoubleProperty dealProperty() {
        return this.deal;
    }

    public final double getDeal() {
        return this.dealProperty().get();
    }

    public final void setDeal(double deal) {
        this.dealProperty().set(deal);
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.codeProperty().get();
    }

    public void setCode(String code) {
        this.codeProperty().set((Object)code);
    }
}

