/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.proto.workflow.PWorkflow;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.factory.AccountStepAttributeFactory;
import cms.tmx.javafx.obj.MxChgObj;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class WorkFlowDescriptor
extends MxChgObj {
    private IntegerProperty id = new SimpleIntegerProperty();
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty workflowAttrId = new SimpleStringProperty("");
    private StringProperty accntId = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty productId = new SimpleStringProperty("");
    private List<AccntStepAttribute> steps = new LinkedList<AccntStepAttribute>();
    private BooleanProperty permitOrder = new SimpleBooleanProperty(false);
    private AccountStepAttributeFactory af;

    public void update(Object obj) {
        if (obj instanceof PWorkflow.WorkflowDescriptor) {
            PWorkflow.WorkflowDescriptor flow = (PWorkflow.WorkflowDescriptor)PWorkflow.WorkflowDescriptor.class.cast(obj);
            this.update(flow);
            this.changed();
        } else if (obj instanceof PWorkflow.WorkflowAttr) {
            PWorkflow.WorkflowAttr flow = (PWorkflow.WorkflowAttr)PWorkflow.WorkflowAttr.class.cast(obj);
            this.update(flow);
            this.changed();
        }
    }

    private void update(PWorkflow.WorkflowDescriptor flow) {
        this.setId(flow.getFlowId());
        if (flow.getFlowName().isEmpty() && flow.getStepList().size() == 2) {
            this.setName("\u4e8c\u8282\u70b9");
        } else if (flow.getFlowName().isEmpty() && flow.getStepList().size() == 3) {
            this.setName("\u4e09\u8282\u70b9");
        } else if (!flow.getFlowName().isEmpty()) {
            this.setName(flow.getFlowName());
        }
        flow.getStepList().forEach(item -> {
            AccntStepAttribute step = this.af.create();
            step.update(item);
            this.getSteps().add(step);
        });
    }

    private void update(PWorkflow.WorkflowAttr flow) {
        this.setId(flow.getWorkflowDescId());
        this.setWorkflowAttrId(flow.getWorkflowAttrId());
        this.setAccntId(flow.getAccntId());
        this.setPortfolioId(flow.getPortfolioId());
        this.setProductId(flow.getProductId());
        flow.getStepList().forEach(item -> {
            AccntStepAttribute step = this.af.create();
            step.update(item);
            this.getSteps().add(step);
        });
        this.setPermitOrder(flow.getPermitOrder() == 1);
    }

    public AccountStepAttributeFactory getAf() {
        return this.af;
    }

    public void setAf(AccountStepAttributeFactory af) {
        this.af = af;
    }

    public String toString() {
        return (String)this.name.get();
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public List<AccntStepAttribute> getSteps() {
        return this.steps;
    }

    public void setSteps(List<AccntStepAttribute> steps) {
        this.steps = steps;
    }

    public final IntegerProperty idProperty() {
        return this.id;
    }

    public final int getId() {
        return this.idProperty().get();
    }

    public final void setId(int id) {
        this.idProperty().set(id);
    }

    public final StringProperty workflowAttrIdProperty() {
        return this.workflowAttrId;
    }

    public final String getWorkflowAttrId() {
        return (String)this.workflowAttrIdProperty().get();
    }

    public final void setWorkflowAttrId(String workflowAttrId) {
        this.workflowAttrIdProperty().set((Object)workflowAttrId);
    }

    public final StringProperty accntIdProperty() {
        return this.accntId;
    }

    public final String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public final void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty productIdProperty() {
        return this.productId;
    }

    public final String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public final void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public BooleanProperty permitOrderProperty() {
        return this.permitOrder;
    }

    public boolean isPermitOrder() {
        return this.permitOrderProperty().get();
    }

    public void setPermitOrder(boolean permitOrder) {
        this.permitOrderProperty().set(permitOrder);
    }
}

