/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.message.PAccount;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SecAccount
extends MxChgSelObj {
    private ObjectProperty<MxNode> currency = new SimpleObjectProperty();
    private ObjectProperty<MxNode> exchange = new SimpleObjectProperty();
    private ObjectProperty<MxNode> category = new SimpleObjectProperty();
    private StringProperty marketGrp = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private StringProperty extAccntId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private StringProperty inverstorId = new SimpleStringProperty("");
    private StringProperty securitiesAccountName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> custodianInstitutionName = new SimpleObjectProperty();
    private StringProperty custodianEntityCode = new SimpleStringProperty("");
    private StringProperty accntId = new SimpleStringProperty("");
    private String oldExtSecAccntId = "";
    private boolean newAccntIdFlag = false;
    private String businessCtrl = "";
    private String newSecAccntId = "";
    private StringProperty secMapKey = new SimpleStringProperty("");

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)"currency_type", (String)"CNY");
        this.setCurrency(node);
        node = MxNodeFactory.create((String)"market_code", (String)"XSHG");
        this.setExchange(node);
        node = MxNodeFactory.create((String)"submarket_code", (String)"A");
        this.setCategory(node);
        node = MxNodeFactory.create((String)"CUSTODIAN_INSTITUTIONS", (String)"1");
        this.setCustodianInstitutionName(node);
    }

    public void update(Object obj) {
        if (obj instanceof PAccount.ExtSecAccnt) {
            PAccount.ExtSecAccnt accntParties = (PAccount.ExtSecAccnt)PAccount.ExtSecAccnt.class.cast(obj);
            this.update(accntParties);
            this.changed();
        } else if (obj instanceof SecAccount) {
            SecAccount account = (SecAccount)((Object)SecAccount.class.cast(obj));
            this.update(account);
        } else if (obj instanceof SecAccnt) {
            SecAccnt account = (SecAccnt)SecAccnt.class.cast(obj);
            this.update(account);
        }
    }

    private void update(SecAccount acc) {
        this.setMarketGrp(acc.getMarketGrp());
        this.setInverstorId(acc.getInverstorId());
        this.setInverstorSecId(acc.getInverstorSecId());
        this.setExchange(acc.getExchange());
        this.setCurrency(acc.getCurrency());
        this.setCategory(acc.getCategory());
        this.setExtSecAccntId(acc.getExtSecAccntId());
        this.setOldExtSecAccntId(acc.getOldExtSecAccntId());
        this.setNewAccntIdFlag(acc.isNewAccntIdFlag());
        this.setNewSecAccntId(acc.getNewSecAccntId());
        this.setExtAccntId(acc.getExtAccntId());
        this.setSecMapKey(String.valueOf(acc.getExtSecAccntId()) + acc.getMarketGrp());
        this.setBusinessCtrl(acc.getBusinessCtrl());
    }

    private void update(SecAccnt acc) {
        this.setNewAccntIdFlag(true);
        this.setOldExtSecAccntId(this.getExtSecAccntId());
        this.setExtSecAccntId(acc.getSecAccntId());
        this.getCategory().setRaw(acc.getSubMarket());
    }

    private void update(PAccount.ExtSecAccnt acc) {
        this.setMarketGrp(acc.getMarketGrp());
        this.setInverstorId(acc.getInvestorId());
        this.setInverstorSecId(acc.getInvestorSecId());
        this.getExchange().setRaw(acc.getMarket());
        this.getCurrency().setRaw(acc.getCurrencyId());
        this.getCategory().setRaw(acc.getSubMarket());
        this.setExtSecAccntId(acc.getExtSecAccntId());
        this.setExtAccntId(acc.getExtAccntId());
        this.setOldExtSecAccntId(acc.getExtSecAccntId());
        this.getCustodianInstitutionName().setRaw(acc.getCustodianEntityCode());
        this.setSecuritiesAccountName(acc.getSecuritiesAccountName());
        this.setSecMapKey(String.valueOf(acc.getExtSecAccntId()) + acc.getMarketGrp());
        this.setBusinessCtrl(acc.getBusinessCtrl().toUpperCase());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.exchange.get() == null ? 0 : ((MxNode)this.exchange.get()).getRaw().hashCode());
        result = 31 * result + (this.extSecAccntId == null ? 0 : ((String)this.extSecAccntId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SecAccount other = (SecAccount)((Object)obj);
        if (this.exchange.get() == null ? other.exchange.get() != null : this.exchange.getValue() != null && other.exchange.getValue() != null && !((MxNode)this.exchange.getValue()).getRaw().equals(((MxNode)other.exchange.getValue()).getRaw())) {
            return false;
        }
        return !(this.extSecAccntId.get() == null ? other.extSecAccntId.get() != null : !((String)this.extSecAccntId.get()).equals(other.extSecAccntId.get()));
    }

    public final StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public final StringProperty extAccntIdProperty() {
        return this.extAccntId;
    }

    public final String getExtAccntId() {
        return (String)this.extAccntIdProperty().get();
    }

    public final void setExtAccntId(String extAccntId) {
        this.extAccntIdProperty().set((Object)extAccntId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public final StringProperty inverstorIdProperty() {
        return this.inverstorId;
    }

    public final String getInverstorId() {
        return (String)this.inverstorIdProperty().get();
    }

    public final void setInverstorId(String inverstorId) {
        this.inverstorIdProperty().set((Object)inverstorId);
    }

    public String toString() {
        return this.getInverstorSecId();
    }

    public final ObjectProperty<MxNode> currencyProperty() {
        return this.currency;
    }

    public final MxNode getCurrency() {
        return (MxNode)this.currencyProperty().get();
    }

    public final void setCurrency(MxNode currency) {
        this.currencyProperty().set((Object)currency);
    }

    public final ObjectProperty<MxNode> exchangeProperty() {
        return this.exchange;
    }

    public final MxNode getExchange() {
        return (MxNode)this.exchangeProperty().get();
    }

    public final void setExchange(MxNode exchange) {
        this.exchangeProperty().set((Object)exchange);
    }

    public final ObjectProperty<MxNode> categoryProperty() {
        return this.category;
    }

    public final MxNode getCategory() {
        return (MxNode)this.categoryProperty().get();
    }

    public final void setCategory(MxNode category) {
        this.categoryProperty().set((Object)category);
    }

    public final StringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public final String getMarketGrp() {
        return (String)this.marketGrpProperty().get();
    }

    public final void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set((Object)marketGrp);
    }

    public final StringProperty securitiesAccountNameProperty() {
        return this.securitiesAccountName;
    }

    public final String getSecuritiesAccountName() {
        return (String)this.securitiesAccountNameProperty().get();
    }

    public final void setSecuritiesAccountName(String securitiesAccountName) {
        this.securitiesAccountNameProperty().set((Object)securitiesAccountName);
    }

    public final StringProperty custodianEntityCodeProperty() {
        return this.custodianEntityCode;
    }

    public final String getCustodianEntityCode() {
        return (String)this.custodianEntityCodeProperty().get();
    }

    public final void setCustodianEntityCode(String custodianEntityCode) {
        this.custodianEntityCodeProperty().set((Object)custodianEntityCode);
    }

    public final ObjectProperty<MxNode> custodianInstitutionNameProperty() {
        return this.custodianInstitutionName;
    }

    public final MxNode getCustodianInstitutionName() {
        return (MxNode)this.custodianInstitutionNameProperty().get();
    }

    public final void setCustodianInstitutionName(MxNode custodianInstitutionName) {
        this.custodianInstitutionNameProperty().set((Object)custodianInstitutionName);
    }

    public SecAccnt toSecAccnt() {
        SecAccnt secAccnt = new SecAccnt();
        secAccnt.setAccntId(this.getAccntId());
        secAccnt.setInvestorId(this.getInverstorId());
        secAccnt.setInvestorSecId(this.getInverstorSecId());
        secAccnt.setRefExtId(this.getExtSecAccntId());
        secAccnt.setSecAccntName(this.getExtSecAccntId());
        secAccnt.setMarket(this.getExchange().getRaw());
        secAccnt.setCurrencyId(this.getCurrency().getRaw());
        secAccnt.setSubMarket(this.getCategory().getRaw());
        secAccnt.setIsDefault(1);
        return secAccnt;
    }

    public final StringProperty accntIdProperty() {
        return this.accntId;
    }

    public final String getAccntId() {
        return (String)this.accntIdProperty().get();
    }

    public final void setAccntId(String accntId) {
        this.accntIdProperty().set((Object)accntId);
    }

    public String getOldExtSecAccntId() {
        return this.oldExtSecAccntId;
    }

    public void setOldExtSecAccntId(String oldExtSecAccntId) {
        this.oldExtSecAccntId = oldExtSecAccntId;
    }

    public boolean isNewAccntIdFlag() {
        return this.newAccntIdFlag;
    }

    public void setNewAccntIdFlag(boolean newAccntIdFlag) {
        this.newAccntIdFlag = newAccntIdFlag;
    }

    public final StringProperty secMapKeyProperty() {
        return this.secMapKey;
    }

    public final String getSecMapKey() {
        return String.valueOf((String)this.extSecAccntIdProperty().get()) + ((MxNode)this.exchange.getValue()).getRaw();
    }

    public final void setSecMapKey(String secMapKey) {
        this.secMapKeyProperty().set((Object)secMapKey);
    }

    public String getBusinessCtrl() {
        return this.businessCtrl;
    }

    public void setBusinessCtrl(String businessCtrl) {
        this.businessCtrl = businessCtrl;
    }

    public String getNewSecAccntId() {
        return this.newSecAccntId;
    }

    public void setNewSecAccntId(String newSecAccntId) {
        this.newSecAccntId = newSecAccntId;
    }
}

