/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.proto.product.PProduct;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Product
extends MxSelObj
implements Comparable<Object> {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty des = new SimpleStringProperty("");
    private StringProperty manager = new SimpleStringProperty("");
    private DoubleProperty netValue = new SimpleDoubleProperty();
    private StringProperty shares = new SimpleStringProperty("");
    private StringProperty beginDate = new SimpleStringProperty("");
    private StringProperty endDate = new SimpleStringProperty("");
    private StringProperty creator = new SimpleStringProperty("");
    private StringProperty createTime = new SimpleStringProperty("");
    private StringProperty updater = new SimpleStringProperty("");
    private StringProperty updateTime = new SimpleStringProperty("");
    private StringProperty dateShow = new SimpleStringProperty("");
    private StringProperty partyId = new SimpleStringProperty("");
    private StringProperty partyName = new SimpleStringProperty("");
    private List<String> benchmarkList = new LinkedList<String>();
    private IntegerProperty benchmarkType = new SimpleIntegerProperty(1);
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    public static final String PRODUCT_STATUS = "post_status";
    public static final String PRODUCT_TYPE = "productType";
    public static final String PRODUCT_STATUS_Q = "1";
    public static final String PRODUCT_TYPE_P = "1";

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)PRODUCT_TYPE, (String)"");
        this.setType(node);
        node = MxNodeFactory.create((String)PRODUCT_STATUS, (String)"1");
        this.setStatus(node);
    }

    public void update(Object obj) {
        if (obj instanceof PProduct.Product) {
            PProduct.Product product = (PProduct.Product)PProduct.Product.class.cast(obj);
            this.update(product);
        } else if (obj instanceof Product) {
            Product product = (Product)Product.class.cast(obj);
            this.update(product);
        } else if (obj instanceof PProduct.ProductDetails) {
            PProduct.ProductDetails productDetails = (PProduct.ProductDetails)PProduct.ProductDetails.class.cast(obj);
            this.update(productDetails);
        }
    }

    public void update(Product product, boolean k) {
        if (k) {
            this.setBenchmarkList(product.getBenchmarkList());
            this.setBenchmarkType(product.getBenchmarkType());
        } else {
            this.setId(product.getId());
            this.setName(product.getName());
            this.setDes(product.getDes());
            this.setManager(product.getManager());
            this.setNetValue(product.getNetValue());
            this.setShares(product.getShares());
            this.setBeginDate(product.getBeginDate());
            this.setEndDate(product.getEndDate());
            this.setCreator(product.getCreator());
            this.setCreateTime(product.getCreateTime());
            this.setUpdater(product.getUpdater());
            this.setUpdateTime(product.getUpdateTime());
            this.setDateShow(String.valueOf(product.getBeginDate()) + "\u81f3" + product.getEndDate());
            this.setPartyId(product.getPartyId());
            this.setPartyName(product.getPartyName());
            this.getStatus().setRaw(product.getStatus().getRaw());
            this.getType().setRaw(product.getType().getRaw());
        }
    }

    private void update(PProduct.ProductDetails productDetails) {
        this.setPartyId(productDetails.getPartyId());
        this.setPartyName(productDetails.getPartyName());
        this.update(productDetails.getProduct());
    }

    private void update(PProduct.Product product) {
        this.setId(product.getProductId());
        this.setName(product.getName());
        this.setDes(product.getDescription());
        this.setManager(product.getManager());
        this.setNetValue(product.getNetValue());
        this.setShares(product.getShares() == 0.0 ? "" : StringUtils.toStr((double)product.getShares(), (int)0));
        this.setBeginDate(product.getBeginDate());
        this.setEndDate(product.getEndDate());
        this.setCreator(product.getCreator());
        this.setCreateTime(product.getCreateTime());
        this.setUpdater(product.getLastUpdater());
        this.setUpdateTime(product.getLastUpdateTime());
        this.setDateShow(String.valueOf(product.getBeginDate()) + "\u81f3" + product.getEndDate());
        this.getStatus().setRaw(Integer.toString(product.getStatus()));
        this.getType().setRaw(Integer.toString(product.getType()));
        this.setBenchmarkList((List<String>)product.getBenchmarkIdList());
        this.setBenchmarkType(product.getBenchmarkType());
    }

    private void update(Product product) {
        this.setId(product.getId());
        this.setName(product.getName());
        this.setDes(product.getDes());
        this.setManager(product.getManager());
        this.setNetValue(product.getNetValue());
        this.setShares(product.getShares());
        this.setBeginDate(product.getBeginDate());
        this.setEndDate(product.getEndDate());
        this.setCreator(product.getCreator());
        this.setCreateTime(product.getCreateTime());
        this.setUpdater(product.getUpdater());
        this.setUpdateTime(product.getUpdateTime());
        this.setDateShow(String.valueOf(product.getBeginDate()) + "\u81f3" + product.getEndDate());
        this.setPartyId(product.getPartyId());
        this.setPartyName(product.getPartyName());
        this.getStatus().setRaw(product.getStatus().getRaw());
        this.getType().setRaw(product.getType().getRaw());
        this.setBenchmarkList(product.getBenchmarkList());
        this.setBenchmarkType(product.getBenchmarkType());
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty desProperty() {
        return this.des;
    }

    public final String getDes() {
        return (String)this.desProperty().get();
    }

    public final void setDes(String des) {
        this.desProperty().set((Object)des);
    }

    public final StringProperty managerProperty() {
        return this.manager;
    }

    public final String getManager() {
        return (String)this.managerProperty().get();
    }

    public final void setManager(String manager) {
        this.managerProperty().set((Object)manager);
    }

    public final DoubleProperty netValueProperty() {
        return this.netValue;
    }

    public final double getNetValue() {
        return this.netValueProperty().get();
    }

    public final void setNetValue(double netValue) {
        this.netValueProperty().set(netValue);
    }

    public final StringProperty beginDateProperty() {
        return this.beginDate;
    }

    public final String getBeginDate() {
        return (String)this.beginDateProperty().get();
    }

    public final void setBeginDate(String beginDate) {
        this.beginDateProperty().set((Object)beginDate);
    }

    public final StringProperty endDateProperty() {
        return this.endDate;
    }

    public final String getEndDate() {
        return (String)this.endDateProperty().get();
    }

    public final void setEndDate(String endDate) {
        this.endDateProperty().set((Object)endDate);
    }

    public final StringProperty creatorProperty() {
        return this.creator;
    }

    public final String getCreator() {
        return (String)this.creatorProperty().get();
    }

    public final void setCreator(String creator) {
        this.creatorProperty().set((Object)creator);
    }

    public final StringProperty createTimeProperty() {
        return this.createTime;
    }

    public final String getCreateTime() {
        return (String)this.createTimeProperty().get();
    }

    public final void setCreateTime(String createTime) {
        this.createTimeProperty().set((Object)createTime);
    }

    public final StringProperty updaterProperty() {
        return this.updater;
    }

    public final String getUpdater() {
        return (String)this.updaterProperty().get();
    }

    public final void setUpdater(String updater) {
        this.updaterProperty().set((Object)updater);
    }

    public final StringProperty updateTimeProperty() {
        return this.updateTime;
    }

    public final String getUpdateTime() {
        return (String)this.updateTimeProperty().get();
    }

    public final void setUpdateTime(String updateTime) {
        this.updateTimeProperty().set((Object)updateTime);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty dateShowProperty() {
        return this.dateShow;
    }

    public final String getDateShow() {
        return (String)this.dateShowProperty().get();
    }

    public final void setDateShow(String dateShow) {
        this.dateShowProperty().set((Object)dateShow);
    }

    public final StringProperty partyIdProperty() {
        return this.partyId;
    }

    public final String getPartyId() {
        return (String)this.partyIdProperty().get();
    }

    public final void setPartyId(String partyId) {
        this.partyIdProperty().set((Object)partyId);
    }

    public final StringProperty partyNameProperty() {
        return this.partyName;
    }

    public final String getPartyName() {
        return (String)this.partyNameProperty().get();
    }

    public final void setPartyName(String partyName) {
        this.partyNameProperty().set((Object)partyName);
    }

    public String toString() {
        return (String)this.name.get();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : ((String)this.id.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Product other = (Product)obj;
        return !(this.id.get() == null ? other.id.get() != null : !((String)this.id.get()).equals(other.id.get()));
    }

    @Override
    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o != null && o instanceof Product) {
            Product u = (Product)o;
            if (Integer.parseInt(u.getId().substring(1)) < Integer.parseInt(this.getId().substring(1))) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public final StringProperty sharesProperty() {
        return this.shares;
    }

    public final String getShares() {
        return (String)this.sharesProperty().get();
    }

    public final void setShares(String shares) {
        this.sharesProperty().set((Object)shares);
    }

    public final IntegerProperty benchmarkTypeProperty() {
        return this.benchmarkType;
    }

    public final int getBenchmarkType() {
        return this.benchmarkTypeProperty().get();
    }

    public final void setBenchmarkType(int benchmarkType) {
        this.benchmarkTypeProperty().set(benchmarkType);
    }

    public List<String> getBenchmarkList() {
        return this.benchmarkList;
    }

    public void setBenchmarkList(List<String> benchmarkList) {
        this.benchmarkList = benchmarkList;
    }
}

