/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Portfolio
extends MxChgSelObj
implements Comparable<Object> {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty partyId = new SimpleStringProperty("");
    private StringProperty partyName = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private ObjectProperty<MxNode> fType = new SimpleObjectProperty();
    private StringProperty creator = new SimpleStringProperty("");
    private StringProperty createTime = new SimpleStringProperty("");
    private StringProperty updater = new SimpleStringProperty("");
    private StringProperty updateTime = new SimpleStringProperty("");
    private StringProperty des = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private StringProperty shares = new SimpleStringProperty("");
    private ObjectProperty<MxNode> toPeriod = new SimpleObjectProperty();
    private StringProperty totalPeriod = new SimpleStringProperty("-1");
    private List<String> benchmarkList = new LinkedList<String>();
    private IntegerProperty benchmarkType = new SimpleIntegerProperty(1);
    private IntegerProperty isVerifyFund = new SimpleIntegerProperty();
    private IntegerProperty isVerifySecu = new SimpleIntegerProperty();
    private IntegerProperty exportSettlement = new SimpleIntegerProperty();
    private StringProperty valPeriod = new SimpleStringProperty("0");
    private DoubleProperty assetAmt = new SimpleDoubleProperty();
    private DoubleProperty available = new SimpleDoubleProperty();
    private DoubleProperty extAvailable = new SimpleDoubleProperty();
    private DoubleProperty hkAvailable = new SimpleDoubleProperty();
    private DoubleProperty hkExtAvailable = new SimpleDoubleProperty();
    public static final String PORTFOLIO_STATUS = "post_status";
    public static final String PORTFOLIO_STATUS_Q = "1";
    public static final String FINANCINGCATEGORY = "financingCategory";
    public static final String PORTFOLIOTYPE = "portfolioType";
    public static final String PORTFOLIOTYPE_DEFAULT = "1";
    public static final String PORTFOLIOVALPERIOD = "portfolioValidityPeriod";
    public static final String VALPERIOD_DEFAULT = "-1";
    public static final String PORTFOLIOTYPE_BENCH = "benchmark";
    public static final String PORTFOLIO_BENCH_DEFAILT = "1";
    private IntegerProperty carryCode = new SimpleIntegerProperty();
    private StringProperty carryYears = new SimpleStringProperty("");
    private StringProperty carryDay = new SimpleStringProperty("");
    private ObjectProperty<MxNode> nonTradableAsset = new SimpleObjectProperty();
    private boolean externalAsset;
    private String externalId;
    private String externalName;
    private ObjectProperty<MxNode> dataSource = new SimpleObjectProperty();
    private StringProperty externalPort = new SimpleStringProperty("");
    public static final String NON_TRADABLE_ASSETS = "non_tradable_assets";
    public static final String NON_TRADABLE_ASSETS_NO = "0";
    public static final String DATA_SOURCE = "accnt_data_source";
    public static final String DATA_SOURCE_AUTO = "1";
    public static final String DATA_SOURCE_MANUAL = "2";

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)PORTFOLIO_STATUS, (String)"1");
        this.setStatus(node);
        MxNode fTypeNode = MxNodeFactory.create((String)FINANCINGCATEGORY, (String)"");
        this.setFtype(fTypeNode);
        MxNode typeNode = MxNodeFactory.create((String)PORTFOLIOTYPE, (String)"1");
        this.setType(typeNode);
        MxNode periodNode = MxNodeFactory.create((String)PORTFOLIOVALPERIOD, (String)VALPERIOD_DEFAULT);
        this.setToPeriod(periodNode);
        node = MxNodeFactory.create((String)NON_TRADABLE_ASSETS, (String)NON_TRADABLE_ASSETS_NO);
        this.setNonTradableAsset(node);
        node = MxNodeFactory.create((String)DATA_SOURCE);
        this.setDataSource(node);
    }

    public Portfolio() {
        MxNode node = MxNodeFactory.create((String)NON_TRADABLE_ASSETS, (String)NON_TRADABLE_ASSETS_NO);
        this.setNonTradableAsset(node);
        node = MxNodeFactory.create((String)DATA_SOURCE);
        this.setDataSource(node);
    }

    public void update(Object obj) {
        if (obj instanceof Portfolio) {
            Portfolio portfolio = (Portfolio)Portfolio.class.cast(obj);
            this.update(portfolio);
            this.changed();
        } else if (obj instanceof PPortfolio.PortfolioDetails) {
            PPortfolio.PortfolioDetails portfolio = (PPortfolio.PortfolioDetails)PPortfolio.PortfolioDetails.class.cast(obj);
            this.update(portfolio);
            this.changed();
        }
    }

    public void update(Portfolio portfolio, boolean k) {
        if (k) {
            this.getType().setRaw(portfolio.getType().getRaw());
            this.getToPeriod().setRaw(portfolio.getToPeriod().getRaw());
            this.setTotalPeriod(portfolio.getTotalPeriod());
            this.setValPeriod(portfolio.getValPeriod());
            this.setBenchmarkList(portfolio.getBenchmarkList());
            this.setBenchmarkType(portfolio.getBenchmarkType());
        } else {
            this.setId(portfolio.getId());
            this.setName(portfolio.getName());
            this.setPartyId(portfolio.getPartyId());
            this.setPartyName(portfolio.getPartyName());
            this.setCreator(portfolio.getCreator());
            this.setCreateTime(portfolio.getCreateTime());
            this.setUpdater(portfolio.getUpdater());
            this.setUpdateTime(portfolio.getUpdateTime());
            this.setDes(portfolio.getDes());
            this.getFtype().setRaw(portfolio.getFtype().getRaw());
            this.getStatus().setRaw(portfolio.getStatus().getRaw());
            this.setShares(portfolio.getShares());
            this.setIsVerifyFund(portfolio.getIsVerifyFund());
            this.setIsVerifySecu(portfolio.getIsVerifySecu());
            this.setExportSettlement(portfolio.getExportSettlement());
            this.setAssetAmt(portfolio.getAssetAmt());
            this.setAvailable(portfolio.getAvailable());
        }
    }

    private void update(PPortfolio.PortfolioDetails portfolioParties) {
        PPortfolio.Portfolio portfolio = portfolioParties.getPortfolio();
        this.setId(portfolio.getPortfolioId());
        this.setName(portfolio.getPortfolioName());
        this.setPartyId(portfolioParties.getPartyId());
        this.setPartyName(portfolioParties.getPartyName());
        this.setCreator(portfolio.getCreator());
        this.setCreateTime(portfolio.getCreateTime());
        this.setUpdater(portfolio.getLastUpdater());
        this.setUpdateTime(portfolio.getLastUpdateTime());
        this.setDes(portfolio.getDescription());
        this.getFtype().setRaw(Integer.toString(portfolio.getFinancingCategory()));
        this.getStatus().setRaw(Integer.toString(portfolio.getStatus()));
        this.getType().setRaw(Integer.toString(portfolio.getType()));
        this.setShares(StringUtils.toStr((double)portfolio.getShares(), (int)4));
        this.setTotalPeriod(Integer.toString(portfolio.getTotalPeriod()));
        this.setValPeriod(Integer.toString(portfolio.getValidityPeriod()));
        this.getToPeriod().setRaw(Integer.toString(portfolio.getTotalPeriod() == -1 ? -1 : 1));
        this.setBenchmarkList((List<String>)portfolio.getBenchmarkList());
        this.setBenchmarkType(portfolio.getBenchmarkType());
        this.setIsVerifyFund(portfolio.getIsVerifyFund());
        this.setIsVerifySecu(portfolio.getIsVerifySecu());
        this.setExportSettlement(portfolio.getExportSettlementFlag());
        int carryType = portfolio.getCarryOver().getCarryTypeValue();
        this.setCarryCode(carryType == 0 ? 1 : carryType);
        this.setCarryYears(String.valueOf((int)portfolio.getCarryOver().getCarryYears()));
        this.setCarryDay(portfolio.getCarryOver().getFirstCarryDay());
        this.setExternalAsset(portfolio.getIsExternalPortfolio());
        if (portfolio.getNonTradableAssetsCount() > 0) {
            String nta = portfolio.getNonTradableAssets(0);
            this.getNonTradableAsset().setRaw(nta.isEmpty() ? NON_TRADABLE_ASSETS_NO : nta);
        }
        if (portfolio.getExtPortfolio().getDataSourceValue() != 0) {
            this.getDataSource().setRaw(String.valueOf(portfolio.getExtPortfolio().getDataSourceValue()));
        }
        String exter = portfolio.getExtPortfolio().getExternalPortfolioId();
        String name = portfolio.getExtPortfolio().getExternalPortfolioName();
        String investor = portfolio.getExtPortfolio().getExternalPortfolioInvestorId();
        this.setExternalAccnt(String.valueOf(exter) + " " + name + " " + investor);
        this.setExternalId(portfolio.getExtPortfolio().getManualPortfolioId());
        this.setExternalName(portfolio.getExtPortfolio().getManualPortfolioName());
    }

    private void update(Portfolio portfolio) {
        this.setId(portfolio.getId());
        this.setName(portfolio.getName());
        this.setPartyId(portfolio.getPartyId());
        this.setPartyName(portfolio.getPartyName());
        this.setCreator(portfolio.getCreator());
        this.setCreateTime(portfolio.getCreateTime());
        this.setUpdater(portfolio.getUpdater());
        this.setUpdateTime(portfolio.getUpdateTime());
        this.setDes(portfolio.getDes());
        this.getFtype().setRaw(portfolio.getFtype().getRaw());
        this.getStatus().setRaw(portfolio.getStatus().getRaw());
        this.getType().setRaw(portfolio.getType().getRaw());
        this.setShares(portfolio.getShares());
        this.getToPeriod().setRaw(portfolio.getToPeriod().getRaw());
        this.setTotalPeriod(portfolio.getTotalPeriod());
        this.setValPeriod(portfolio.getValPeriod());
        this.setBenchmarkList(portfolio.getBenchmarkList());
        this.setBenchmarkType(portfolio.getBenchmarkType());
        this.setIsVerifyFund(portfolio.getIsVerifyFund());
        this.setIsVerifySecu(portfolio.getIsVerifySecu());
        this.setExportSettlement(portfolio.getExportSettlement());
        this.setValPeriod(portfolio.getValPeriod());
        this.setAssetAmt(portfolio.getAssetAmt());
        this.setAvailable(portfolio.getAvailable());
        this.setHkAvailable(portfolio.getHkAvailable());
        this.setCarryCode(portfolio.getCarryCode());
        this.setCarryYears(portfolio.getCarryYears());
        this.setCarryDay(portfolio.getCarryDay());
        this.setExternalAsset(portfolio.isExternalAsset());
        this.getNonTradableAsset().setRaw(portfolio.getNonTradableAsset().getRaw());
        this.getNonTradableAsset().setRaw(portfolio.getNonTradableAsset().getRaw());
        this.getDataSource().setRaw(portfolio.getDataSource().getRaw());
        this.setExternalAccnt(portfolio.getExternalAccnt());
        this.setExternalId(portfolio.getExternalId());
        this.setExternalName(portfolio.getExternalName());
    }

    public String toString() {
        return (String)this.name.get();
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty partyIdProperty() {
        return this.partyId;
    }

    public final String getPartyId() {
        return (String)this.partyIdProperty().get();
    }

    public final void setPartyId(String partyId) {
        this.partyIdProperty().set((Object)partyId);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty creatorProperty() {
        return this.creator;
    }

    public final String getCreator() {
        return (String)this.creatorProperty().get();
    }

    public final void setCreator(String creator) {
        this.creatorProperty().set((Object)creator);
    }

    public final StringProperty createTimeProperty() {
        return this.createTime;
    }

    public final String getCreateTime() {
        return (String)this.createTimeProperty().get();
    }

    public final void setCreateTime(String createTime) {
        this.createTimeProperty().set((Object)createTime);
    }

    public final StringProperty updaterProperty() {
        return this.updater;
    }

    public final String getUpdater() {
        return (String)this.updaterProperty().get();
    }

    public final void setUpdater(String updater) {
        this.updaterProperty().set((Object)updater);
    }

    public final StringProperty updateTimeProperty() {
        return this.updateTime;
    }

    public final String getUpdateTime() {
        return (String)this.updateTimeProperty().get();
    }

    public final void setUpdateTime(String updateTime) {
        this.updateTimeProperty().set((Object)updateTime);
    }

    public final StringProperty desProperty() {
        return this.des;
    }

    public final String getDes() {
        return (String)this.desProperty().get();
    }

    public final void setDes(String des) {
        this.desProperty().set((Object)des);
    }

    public final String getPartyName() {
        return (String)this.partyNameProperty().get();
    }

    public final void setPartyName(String partyName) {
        this.partyNameProperty().set((Object)partyName);
    }

    public final StringProperty partyNameProperty() {
        return this.partyName;
    }

    public final ObjectProperty<MxNode> fTypeProperty() {
        return this.fType;
    }

    public final MxNode getFtype() {
        return (MxNode)this.fTypeProperty().get();
    }

    public final void setFtype(MxNode fType) {
        this.fTypeProperty().set((Object)fType);
    }

    @Override
    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o != null && o instanceof Portfolio) {
            Portfolio u = (Portfolio)o;
            if (Integer.parseInt(u.getId().substring(1)) < Integer.parseInt(this.getId().substring(1))) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : ((String)this.id.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Portfolio other = (Portfolio)obj;
        return !(this.id.get() == null ? other.id.get() != null : !((String)this.id.get()).equals(other.id.get()));
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final ObjectProperty<MxNode> toPeriodProperty() {
        return this.toPeriod;
    }

    public final MxNode getToPeriod() {
        return (MxNode)this.toPeriodProperty().get();
    }

    public final void setToPeriod(MxNode validityPeriod) {
        this.toPeriodProperty().set((Object)validityPeriod);
    }

    public List<String> getBenchmarkList() {
        return this.benchmarkList;
    }

    public void setBenchmarkList(List<String> benchmarkList) {
        this.benchmarkList = benchmarkList;
    }

    public final StringProperty sharesProperty() {
        return this.shares;
    }

    public final String getShares() {
        return (String)this.sharesProperty().get();
    }

    public final void setShares(String shares) {
        this.sharesProperty().set((Object)shares);
    }

    public final IntegerProperty isVerifyFundProperty() {
        return this.isVerifyFund;
    }

    public final int getIsVerifyFund() {
        return this.isVerifyFundProperty().get();
    }

    public final void setIsVerifyFund(int isVerifyFund) {
        this.isVerifyFundProperty().set(isVerifyFund);
    }

    public final IntegerProperty isVerifySecuProperty() {
        return this.isVerifySecu;
    }

    public final int getIsVerifySecu() {
        return this.isVerifySecuProperty().get();
    }

    public final void setIsVerifySecu(int isVerifySecu) {
        this.isVerifySecuProperty().set(isVerifySecu);
    }

    public DoubleProperty assetAmtProperty() {
        return this.assetAmt;
    }

    public double getAssetAmt() {
        return this.assetAmtProperty().get();
    }

    public void setAssetAmt(double assetAmt) {
        this.assetAmtProperty().set(assetAmt);
    }

    public DoubleProperty availableProperty() {
        return this.available;
    }

    public double getAvailable() {
        return this.availableProperty().get();
    }

    public void setAvailable(double available) {
        this.availableProperty().set(available);
    }

    public final StringProperty totalPeriodProperty() {
        return this.totalPeriod;
    }

    public final String getTotalPeriod() {
        return (String)this.totalPeriodProperty().get();
    }

    public final void setTotalPeriod(String totalPeriod) {
        this.totalPeriodProperty().set((Object)totalPeriod);
    }

    public final StringProperty valPeriodProperty() {
        return this.valPeriod;
    }

    public final String getValPeriod() {
        return (String)this.valPeriodProperty().get();
    }

    public final void setValPeriod(String valPeriod) {
        this.valPeriodProperty().set((Object)valPeriod);
    }

    public final IntegerProperty benchmarkTypeProperty() {
        return this.benchmarkType;
    }

    public final int getBenchmarkType() {
        return this.benchmarkTypeProperty().get();
    }

    public final void setBenchmarkType(int benchmarkType) {
        this.benchmarkTypeProperty().set(benchmarkType);
    }

    public final IntegerProperty carryCodeProperty() {
        return this.carryCode;
    }

    public final int getCarryCode() {
        return this.carryCodeProperty().get();
    }

    public final void setCarryCode(int carryCode) {
        this.carryCodeProperty().set(carryCode);
    }

    public final StringProperty carryDayProperty() {
        return this.carryDay;
    }

    public final String getCarryDay() {
        return (String)this.carryDayProperty().get();
    }

    public final void setCarryDay(String carryDay) {
        this.carryDayProperty().set((Object)carryDay);
    }

    public final StringProperty carryYearsProperty() {
        return this.carryYears;
    }

    public final String getCarryYears() {
        return (String)this.carryYearsProperty().get();
    }

    public final void setCarryYears(String carryYears) {
        this.carryYearsProperty().set((Object)carryYears);
    }

    public final DoubleProperty hkAvailableProperty() {
        return this.hkAvailable;
    }

    public final double getHkAvailable() {
        return this.hkAvailableProperty().get();
    }

    public final void setHkAvailable(double hkAvailable) {
        this.hkAvailableProperty().set(hkAvailable);
    }

    public final IntegerProperty exportSettlementProperty() {
        return this.exportSettlement;
    }

    public final int getExportSettlement() {
        return this.exportSettlementProperty().get();
    }

    public final void setExportSettlement(int exportSettlement) {
        this.exportSettlementProperty().set(exportSettlement);
    }

    public final ObjectProperty<MxNode> nonTradableAssetProperty() {
        return this.nonTradableAsset;
    }

    public final MxNode getNonTradableAsset() {
        return (MxNode)this.nonTradableAssetProperty().get();
    }

    public final void setNonTradableAsset(MxNode nonTradableAsset) {
        this.nonTradableAssetProperty().set((Object)nonTradableAsset);
    }

    public final ObjectProperty<MxNode> dataSourceProperty() {
        return this.dataSource;
    }

    public final MxNode getDataSource() {
        return (MxNode)this.dataSourceProperty().get();
    }

    public final void setDataSource(MxNode dataSource) {
        this.dataSourceProperty().set((Object)dataSource);
    }

    public final StringProperty externalAccntProperty() {
        return this.externalPort;
    }

    public final String getExternalAccnt() {
        return (String)this.externalAccntProperty().get();
    }

    public final void setExternalAccnt(String externalAccnt) {
        this.externalAccntProperty().set((Object)externalAccnt);
    }

    public boolean isExternalAsset() {
        return this.externalAsset;
    }

    public void setExternalAsset(boolean externalAsset) {
        this.externalAsset = externalAsset;
    }

    public StringProperty showNameProperty() {
        return new SimpleStringProperty(this.getName());
    }

    public DoubleProperty extAvailableProperty() {
        return this.extAvailable;
    }

    public double getExtAvailable() {
        return this.extAvailableProperty().get();
    }

    public void setExtAvailable(double extAvailable) {
        this.extAvailableProperty().set(extAvailable);
    }

    public DoubleProperty hkExtAvailableProperty() {
        return this.hkExtAvailable;
    }

    public double getHkExtAvailable() {
        return this.hkExtAvailableProperty().get();
    }

    public void setHkExtAvailable(double hkExtAvailable) {
        this.hkExtAvailableProperty().set(hkExtAvailable);
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }
}

