/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MsgSetting
extends MxChgObj
implements Comparable<Object> {
    private int id;
    private StringProperty name = new SimpleStringProperty("\u9ed8\u8ba4\u540d\u79f0");
    private StringProperty content = new SimpleStringProperty("");
    private ObjectProperty<MxNode> level = new SimpleObjectProperty();
    private StringProperty interval = new SimpleStringProperty("");
    private ObjectProperty<MxNode> type = new SimpleObjectProperty();
    private ObjectProperty<MxNode> subType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> notifyWay = new SimpleObjectProperty();
    private BooleanProperty email = new SimpleBooleanProperty(false);
    private BooleanProperty msg = new SimpleBooleanProperty(false);
    private BooleanProperty forcedPush = new SimpleBooleanProperty(true);
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)new Color(1.0, 1.0, 1.0, 1.0));
    private BooleanProperty ring = new SimpleBooleanProperty(false);
    private StringProperty ringName = new SimpleStringProperty("instruction_notice.wav");
    private BooleanProperty custom = new SimpleBooleanProperty(false);
    private BooleanProperty reset = new SimpleBooleanProperty(false);
    private StringProperty creator = new SimpleStringProperty("");
    private StringProperty createTime = new SimpleStringProperty("");
    private StringProperty updater = new SimpleStringProperty("");
    private StringProperty updateTime = new SimpleStringProperty("");
    public static final String LEVEL = "msg_level";
    public static final String TYPE = "msg_type";
    public static final String SUBTYPE = "msg_subtype";
    public static final String NOTIFY = "msg_notify";
    public static final String DEFAULT = "1";
    private SimpleDateFormat formatterOne = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat formatterTwo = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    @PostConstruct
    public void init() {
        this.setLevel(MxNodeFactory.create((String)LEVEL, (String)DEFAULT));
        this.setType(MxNodeFactory.create((String)TYPE, (String)DEFAULT));
        this.setSubType(MxNodeFactory.create((String)SUBTYPE, (String)""));
        this.setNotifyWay(MxNodeFactory.create((String)NOTIFY, (String)"0"));
    }

    public void update(Object obj) {
        if (obj instanceof PMisc.MsgSetting) {
            PMisc.MsgSetting msg = (PMisc.MsgSetting)PMisc.MsgSetting.class.cast(obj);
            this.update(msg);
            this.changed();
        } else if (obj instanceof MsgSetting) {
            MsgSetting msg = (MsgSetting)MsgSetting.class.cast(obj);
            this.update(msg);
            this.changed();
        }
    }

    private void update(PMisc.MsgSetting msg) {
        this.setId(msg.getId());
        this.setName(msg.getName());
        this.setContent(msg.getContent());
        this.getLevel().setRaw(Integer.toString(msg.getLevelValue()));
        this.getType().setRaw(Integer.toString(msg.getTypeValue()));
        this.getSubType().setRaw(Integer.toString(msg.getSubTypeValue()));
        this.getNotifyWay().setRaw(Integer.toString(msg.getNotifyWay()));
        this.setInterval(Integer.toString(msg.getInterval()));
        this.setEmail(msg.getOtherPushWay() == 1 || msg.getOtherPushWay() == 3);
        this.setMsg(msg.getOtherPushWay() == 2 || msg.getOtherPushWay() == 3);
        this.setColor(Color.valueOf((String)msg.getColor()));
        this.setRing(msg.getRingingType() == 1);
        this.setRingName(msg.getRingingName());
        this.setForcedPush(msg.getHasForcedPush());
        this.setCustom(msg.getHasCustomConfigPermit());
        this.setReset(msg.getHasAutoResetPermit());
        this.setCreator(msg.getCreator());
        this.setUpdater(msg.getLastUpdater());
        try {
            this.setCreateTime(this.formatterOne.format(this.formatterTwo.parse(msg.getCreateTime())));
            if (!msg.getLastUpdateTime().isEmpty()) {
                this.setUpdateTime(this.formatterOne.format(this.formatterTwo.parse(msg.getLastUpdateTime())));
            }
        }
        catch (ParseException e) {
            this.setCreateTime(msg.getCreateTime());
            this.setUpdateTime(msg.getLastUpdateTime());
            e.printStackTrace();
        }
    }

    private void update(MsgSetting msg) {
        this.setId(msg.getId());
        this.setName(msg.getName());
        this.setContent(msg.getContent());
        this.getLevel().setRaw(msg.getLevel().getRaw());
        this.getType().setRaw(msg.getType().getRaw());
        this.getSubType().setRaw(msg.getSubType().getRaw());
        this.getNotifyWay().setRaw(msg.getNotifyWay().getRaw());
        this.setInterval(msg.getInterval());
        this.setEmail(msg.isEmail());
        this.setMsg(msg.isMsg());
        this.setColor(msg.getColor());
        this.setRing(msg.isRing());
        this.setRingName(msg.getRingName());
        this.setForcedPush(msg.isForcedPush());
        this.setCustom(msg.isCustom());
        this.setReset(msg.isReset());
        this.setCreator(msg.getCreator());
        this.setCreateTime(msg.getCreateTime());
        this.setUpdater(msg.getUpdater());
        this.setUpdateTime(msg.getUpdateTime());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty contentProperty() {
        return this.content;
    }

    public final String getContent() {
        return (String)this.contentProperty().get();
    }

    public final void setContent(String content) {
        this.contentProperty().set((Object)content);
    }

    public final ObjectProperty<MxNode> levelProperty() {
        return this.level;
    }

    public final MxNode getLevel() {
        return (MxNode)this.levelProperty().get();
    }

    public final void setLevel(MxNode level) {
        this.levelProperty().set((Object)level);
    }

    public final StringProperty intervalProperty() {
        return this.interval;
    }

    public final String getInterval() {
        return (String)this.intervalProperty().get();
    }

    public final void setInterval(String interval) {
        this.intervalProperty().set((Object)interval);
    }

    public final ObjectProperty<MxNode> typeProperty() {
        return this.type;
    }

    public final MxNode getType() {
        return (MxNode)this.typeProperty().get();
    }

    public final void setType(MxNode type) {
        this.typeProperty().set((Object)type);
    }

    public final ObjectProperty<MxNode> subTypeProperty() {
        return this.subType;
    }

    public final MxNode getSubType() {
        return (MxNode)this.subTypeProperty().get();
    }

    public final void setSubType(MxNode subType) {
        this.subTypeProperty().set((Object)subType);
    }

    public final ObjectProperty<MxNode> notifyWayProperty() {
        return this.notifyWay;
    }

    public final MxNode getNotifyWay() {
        return (MxNode)this.notifyWayProperty().get();
    }

    public final void setNotifyWay(MxNode notifyWay) {
        this.notifyWayProperty().set((Object)notifyWay);
    }

    public final BooleanProperty emailProperty() {
        return this.email;
    }

    public final boolean isEmail() {
        return this.emailProperty().get();
    }

    public final void setEmail(boolean email) {
        this.emailProperty().set(email);
    }

    public final BooleanProperty msgProperty() {
        return this.msg;
    }

    public final boolean isMsg() {
        return this.msgProperty().get();
    }

    public final void setMsg(boolean msg) {
        this.msgProperty().set(msg);
    }

    public final BooleanProperty ringProperty() {
        return this.ring;
    }

    public final boolean isRing() {
        return this.ringProperty().get();
    }

    public final void setRing(boolean ring) {
        this.ringProperty().set(ring);
    }

    public final StringProperty ringNameProperty() {
        return this.ringName;
    }

    public final String getRingName() {
        return (String)this.ringNameProperty().get();
    }

    public final void setRingName(String ringName) {
        this.ringNameProperty().set((Object)ringName);
    }

    public final StringProperty creatorProperty() {
        return this.creator;
    }

    public final String getCreator() {
        return (String)this.creatorProperty().get();
    }

    public final void setCreator(String creator) {
        this.creatorProperty().set((Object)creator);
    }

    public final StringProperty createTimeProperty() {
        return this.createTime;
    }

    public final String getCreateTime() {
        return (String)this.createTimeProperty().get();
    }

    public final void setCreateTime(String createTime) {
        this.createTimeProperty().set((Object)createTime);
    }

    public final StringProperty updaterProperty() {
        return this.updater;
    }

    public final String getUpdater() {
        return (String)this.updaterProperty().get();
    }

    public final void setUpdater(String updater) {
        this.updaterProperty().set((Object)updater);
    }

    public final StringProperty updateTimeProperty() {
        return this.updateTime;
    }

    public final String getUpdateTime() {
        return (String)this.updateTimeProperty().get();
    }

    public final void setUpdateTime(String updateTime) {
        this.updateTimeProperty().set((Object)updateTime);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MsgSetting other = (MsgSetting)obj;
        return this.id == other.id;
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final Color getColor() {
        return (Color)this.colorProperty().get();
    }

    public final void setColor(Color color) {
        this.colorProperty().set((Object)color);
    }

    @Override
    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o != null && o instanceof MsgSetting) {
            MsgSetting u = (MsgSetting)o;
            if (u.getId() < this.getId()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public final BooleanProperty forcedPushProperty() {
        return this.forcedPush;
    }

    public final boolean isForcedPush() {
        return this.forcedPushProperty().get();
    }

    public final void setForcedPush(boolean forcedPush) {
        this.forcedPushProperty().set(forcedPush);
    }

    public final BooleanProperty customProperty() {
        return this.custom;
    }

    public final boolean isCustom() {
        return this.customProperty().get();
    }

    public final void setCustom(boolean custom) {
        this.customProperty().set(custom);
    }

    public final BooleanProperty resetProperty() {
        return this.reset;
    }

    public final boolean isReset() {
        return this.resetProperty().get();
    }

    public final void setReset(boolean reset) {
        this.resetProperty().set(reset);
    }
}

