/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.proto.PBase;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.FxUtils;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;

public class LoggerMsgPage<T>
extends MxChgObj {
    private StringProperty beginDate = new SimpleStringProperty("");
    private StringProperty endDate = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private IntegerProperty currentPage = new SimpleIntegerProperty(0);
    private IntegerProperty pageSize = new SimpleIntegerProperty(100);
    private IntegerProperty pageCount = new SimpleIntegerProperty(1);
    private IntegerProperty totalCount = new SimpleIntegerProperty(0);
    private IntegerProperty start = new SimpleIntegerProperty(1);
    private IntegerProperty end = new SimpleIntegerProperty(0);
    private IntegerProperty mod = new SimpleIntegerProperty(100);
    private ObservableList<T> dataList = FxUtils.newList();
    private boolean protect = true;

    public LoggerMsgPage() {
        this.currentPage.addListener(ob -> this.updateData());
        this.pageSize.addListener(ob -> {
            this.compPageCount();
            this.clear();
            this.query();
        });
    }

    public void clear() {
        this.protect = false;
        this.dataList.clear();
        this.currentPage.set(0);
        this.protect = true;
    }

    private void updateData() {
        this.query();
    }

    public void updateData(List<T> list) {
        this.protect = false;
        this.compPageCount();
        this.protect = true;
        this.dataList.setAll(list);
    }

    private void compPageCount() {
        int tatol = this.totalCount.get();
        if (tatol == 0) {
            this.pageCount.set(1);
            return;
        }
        int size = this.pageSize.get();
        int page = size == 0 ? 0 : tatol / size;
        int remainder = tatol % this.pageSize.get();
        page = remainder == 0 ? page : ++page;
        this.pageCount.set(page);
    }

    public ObservableList<T> getDataList() {
        return this.dataList;
    }

    public void query() {
        if (this.protect) {
            this.changed();
        }
    }

    public void initParam() {
        int size = this.pageSize.get();
        int start = size * this.currentPage.get() + 1;
        int end = start + size;
        this.setStart(start);
        this.setEnd(end);
        this.setMod(size);
    }

    public void updatePage(PBase.Page.Builder builder) {
        int start = this.getStart();
        int size = this.getPageSize();
        int mod = this.getMod();
        if (mod < 150) {
            size = mod;
        }
        if (mod > 150) {
            size = 150;
        }
        builder.setStartRow(start);
        builder.setPageSize(size);
        this.setMod(mod - size);
        this.setStart(start + size);
    }

    public void updatePager(PBase.Pager.Builder builder) {
        int start = this.getStart();
        int size = this.getPageSize();
        int mod = this.getMod();
        if (mod < 150) {
            size = mod;
        }
        if (mod > 150) {
            size = 150;
        }
        builder.setPageSize(size);
        builder.setStartRow(start);
        builder.setNextId("0");
        this.setMod(mod - size);
        this.setStart(start + size);
    }

    public boolean hasNext(int total) {
        this.setTotalCount(total);
        if (this.getEnd() > total) {
            return this.getStart() < total;
        }
        return this.getStart() < this.getEnd();
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public Integer getCurrentPage() {
        return this.currentPageProperty().get();
    }

    public void setCurrentPage(Integer currentPage) {
        int max = this.getPageCount() - 1;
        int page = currentPage;
        if (page > max) {
            page = max;
        } else if (currentPage < 0) {
            page = 0;
        }
        this.currentPageProperty().set(page);
    }

    public IntegerProperty pageSizeProperty() {
        return this.pageSize;
    }

    public Integer getPageSize() {
        return this.pageSizeProperty().get();
    }

    public void setPageSize(Integer pageSize) {
        this.pageSizeProperty().set(pageSize.intValue());
    }

    public IntegerProperty totalCountProperty() {
        return this.totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCountProperty().get();
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCountProperty().set(totalCount.intValue());
    }

    public StringProperty beginDateProperty() {
        return this.beginDate;
    }

    public String getBeginDate() {
        return (String)this.beginDateProperty().get();
    }

    public void setBeginDate(String beginDate) {
        this.beginDateProperty().set((Object)beginDate);
    }

    public StringProperty userIdProperty() {
        return this.userId;
    }

    public String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public StringProperty endDateProperty() {
        return this.endDate;
    }

    public String getEndDate() {
        return (String)this.endDateProperty().get();
    }

    public void setEndDate(String endDate) {
        this.endDateProperty().set((Object)endDate);
    }

    public final IntegerProperty pageCountProperty() {
        return this.pageCount;
    }

    public final int getPageCount() {
        return this.pageCountProperty().get();
    }

    public final void setPageCount(int pageCount) {
        this.pageCountProperty().set(pageCount);
    }

    public final IntegerProperty startProperty() {
        return this.start;
    }

    public final int getStart() {
        return this.startProperty().get();
    }

    public final void setStart(int start) {
        this.startProperty().set(start);
    }

    public final IntegerProperty endProperty() {
        return this.end;
    }

    public final int getEnd() {
        return this.endProperty().get();
    }

    public final void setEnd(int end) {
        this.endProperty().set(end);
    }

    public final IntegerProperty modProperty() {
        return this.mod;
    }

    public final int getMod() {
        return this.modProperty().get();
    }

    public final void setMod(int mod) {
        this.modProperty().set(mod);
    }
}

