/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.message.PAccount;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.query.Sofp;
import cms.tmx.http.query.marginxt.XtSofp;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.CounterNameUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class FundAccount
extends MxChgSelObj {
    public static final int ACCEPTED_RISK_AGREEMENT = 1;
    private StringProperty extAccntId = new SimpleStringProperty("");
    private String oldExtAccntId = "";
    private boolean newAccntIdFlag = false;
    private StringProperty parentId = new SimpleStringProperty("");
    private StringProperty currencyId = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty marketGrp = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private IntegerProperty flags = new SimpleIntegerProperty();
    private StringProperty brokerId = new SimpleStringProperty("");
    private StringProperty pwd = new SimpleStringProperty("");
    private StringProperty investmarkets = new SimpleStringProperty("");
    private StringProperty investId = new SimpleStringProperty("");
    private DoubleProperty assetAmt = new SimpleDoubleProperty();
    private DoubleProperty newAssetAmt = new SimpleDoubleProperty();
    private StringProperty accountName = new SimpleStringProperty("");
    private DoubleProperty available = new SimpleDoubleProperty();
    private DoubleProperty hkAvailable = new SimpleDoubleProperty();
    private DoubleProperty withdrawQuota = new SimpleDoubleProperty();
    private StringProperty productName = new SimpleStringProperty("");
    private String productId = "";
    private StringProperty counterId = new SimpleStringProperty("");
    private StringProperty counterName = new SimpleStringProperty("");
    private int riskAgreement;
    private boolean isNew = false;
    private boolean neeqEnable = false;
    private boolean otcEnable = false;
    private boolean externalAsset = false;
    private String newCashAccntId = "";
    private boolean fileOrderManualConfirm = true;
    private DoubleProperty balanceNew = new SimpleDoubleProperty();
    private DoubleProperty availableNew = new SimpleDoubleProperty();
    private DoubleProperty marginAvlNew = new SimpleDoubleProperty();
    private DoubleProperty fcreditAvlNew = new SimpleDoubleProperty();
    private DoubleProperty dcreditAvlNew = new SimpleDoubleProperty();
    private DoubleProperty ftotalDebtsNew = new SimpleDoubleProperty();
    private DoubleProperty dtotalDebtsNew = new SimpleDoubleProperty();
    private DoubleProperty totalAssetNew = new SimpleDoubleProperty();
    private DoubleProperty repayCashAvl = new SimpleDoubleProperty();
    private DoubleProperty dsaleAmtBal = new SimpleDoubleProperty();
    private DoubleProperty posBuyAvl = new SimpleDoubleProperty();
    private DoubleProperty balanceNewXt = new SimpleDoubleProperty();
    private DoubleProperty availableNewXt = new SimpleDoubleProperty();
    private DoubleProperty marginAvlNewXt = new SimpleDoubleProperty();
    private DoubleProperty fcreditAvlNewXt = new SimpleDoubleProperty();
    private DoubleProperty dcreditAvlNewXt = new SimpleDoubleProperty();
    private DoubleProperty ftotalDebtsNewXt = new SimpleDoubleProperty();
    private DoubleProperty dtotalDebtsNewXt = new SimpleDoubleProperty();
    private DoubleProperty totalAssetNewXt = new SimpleDoubleProperty();
    private DoubleProperty repayCashAvlXt = new SimpleDoubleProperty();
    private DoubleProperty dsaleAmtBalXt = new SimpleDoubleProperty();
    private DoubleProperty posBuyAvlXt = new SimpleDoubleProperty();
    private DoubleProperty creditFundFee = new SimpleDoubleProperty();
    private DoubleProperty creditStockFee = new SimpleDoubleProperty();
    private DoubleProperty creditFundFeeCanReturn = new SimpleDoubleProperty();
    private DoubleProperty creditStockFeeCanReturn = new SimpleDoubleProperty();
    private DoubleProperty ftotalOrgDebtsNewXt = new SimpleDoubleProperty();
    private DoubleProperty dtotalOrgDebtsNewXt = new SimpleDoubleProperty();
    private DoubleProperty capitalization = new SimpleDoubleProperty();
    private DoubleProperty buyCostAmt = new SimpleDoubleProperty();
    private DoubleProperty floatPl = new SimpleDoubleProperty();
    private DoubleProperty realPl = new SimpleDoubleProperty();
    private DoubleProperty totalPl = new SimpleDoubleProperty();
    private StringProperty email = new SimpleStringProperty("");
    private Long emailId;

    public void update(Object obj) {
        if (obj instanceof PAccount.ExtFundAccnt) {
            PAccount.ExtFundAccnt fundAccnt = (PAccount.ExtFundAccnt)PAccount.ExtFundAccnt.class.cast(obj);
            this.update(fundAccnt);
            this.changed();
        } else if (obj instanceof FundAccount) {
            FundAccount fundAccnt = (FundAccount)((Object)FundAccount.class.cast(obj));
            this.update(fundAccnt);
            this.changed();
        } else if (obj instanceof Sofp) {
            Sofp sofp = (Sofp)Sofp.class.cast(obj);
            this.update(sofp);
            this.changed();
        } else if (obj instanceof Position) {
            Position position = (Position)Position.class.cast(obj);
            this.update(position);
            this.changed();
        } else if (obj instanceof CashAccnt) {
            this.update((CashAccnt)CashAccnt.class.cast(obj));
        } else if (obj instanceof XtSofp) {
            XtSofp sofp = (XtSofp)XtSofp.class.cast(obj);
            this.update(sofp);
            this.changed();
        }
    }

    private void update(CashAccnt fundAccnt) {
        this.setNewAccntIdFlag(true);
        this.setNewCashAccntId(fundAccnt.getCashAccntId());
    }

    public void updateCash(CashAccnt cash) {
        this.setExtAccntId(cash.getAccntId());
        this.setNewCashAccntId(cash.getCashAccntId());
        this.setAccountName(cash.getCashAccntName());
        this.setCurrencyId(cash.getCurrencyId());
        this.setMarket(cash.getMarket());
        this.setMarketGrp(cash.getMarketGroup());
        this.setBrokerId(cash.getBrokerId());
        this.setInvestId(cash.getInvestorId());
        this.setFlags(cash.getFlags());
        this.setPwd(cash.getPassword());
        this.setNewAccntIdFlag(true);
        MxNode createNew = MxNodeFactory.createNew((String)"accnt_status", (String)String.valueOf(cash.getStatus()));
        createNew.removeOthers(String.valueOf(cash.getStatus()));
        this.setStatus(createNew);
    }

    private void update(Position position) {
        this.setAvailable(position.getCashAvail());
        this.setWithdrawQuota(position.getCashWithDraw());
    }

    private void update(Sofp sofp) {
        this.setBalanceNew(sofp.getBalance());
        this.setAvailableNew(sofp.getAvailable());
        this.setMarginAvlNew(sofp.getMarginAvl());
        this.setFcreditAvlNew(sofp.getFcreditAvl());
        this.setDcreditAvlNew(sofp.getDcreditAvl());
        this.setFtotalDebtsNew(sofp.getFtotalDebts());
        this.setDtotalDebtsNew(sofp.getDtotalDebts());
        this.setTotalAssetNew(sofp.getTotalAsset());
        this.setRepayCashAvl(sofp.getRepayCashAvl());
        this.setDsaleAmtBal(sofp.getDsaleAmtBal());
        this.setPosBuyAvl(sofp.getDsaleAmtBal() + sofp.getAvailable());
    }

    private void update(XtSofp sofp) {
        this.setAvailableNewXt(sofp.getFundAvail());
        this.setMarginAvlNewXt(sofp.getMarginAvail());
        this.setFcreditAvlNewXt(sofp.getCreditFundAvailQuota());
        this.setDcreditAvlNewXt(sofp.getCreditStockAvailQuota());
        this.setFtotalDebtsNewXt(sofp.getCreditFundDebt());
        this.setDtotalDebtsNewXt(sofp.getCreditStockDebt());
        this.setFtotalOrgDebtsNewXt(sofp.getCreditFundOrgDebt());
        this.setDtotalOrgDebtsNewXt(sofp.getCreditStockOrgDebt());
        this.setTotalAssetNewXt(sofp.getTotalAsset());
        this.setRepayCashAvlXt(sofp.getRepayFundAvail());
        this.setDsaleAmtBalXt(sofp.getAvailSellBalance());
        this.setPosBuyAvlXt(sofp.getTotalSellBalance() + sofp.getFundAvail());
        this.setCreditFundFee(sofp.getCreditFundFee());
        this.setCreditStockFee(sofp.getCreditStockFee());
        this.setCreditFundFeeCanReturn(sofp.getCreditFundRepayableFee());
        this.setCreditStockFeeCanReturn(sofp.getCreditStockRepayableFee());
    }

    private void update(PAccount.ExtFundAccnt fundAccnt) {
        this.setExtAccntId(fundAccnt.getExtAccntId());
        this.setOldExtAccntId(fundAccnt.getExtAccntId());
        this.setParentId(fundAccnt.getParentAccntId());
        this.setCurrencyId(fundAccnt.getCurrencyId());
        this.setMarket(fundAccnt.getMarket());
        this.setMarketGrp(fundAccnt.getMarketGrp());
        this.getStatus().setRaw(Integer.toString(fundAccnt.getStatus()));
        this.setFlags(fundAccnt.getFlags());
        this.setBrokerId(fundAccnt.getBrokerId());
        this.setPwd(fundAccnt.getPassword());
        this.setInvestmarkets(fundAccnt.getInvestableMarkets());
        this.setInvestId(fundAccnt.getInvestorId());
        this.setAccountName(fundAccnt.getSettlementBankName());
        this.setRiskAgreement(fundAccnt.getRiskAgreement());
        this.setProductName(fundAccnt.getProductName());
        this.setProductId(fundAccnt.getProductId());
        this.setCounterId(fundAccnt.getCounterId());
        this.setCounterName(CounterNameUtils.getCounterName((String)this.getInvestId(), (String)this.getCounterId()));
    }

    private void update(FundAccount fundAccnt) {
        this.setNewAccntIdFlag(fundAccnt.isNewAccntIdFlag());
        this.setNeeqEnable(fundAccnt.isNeeqEnable());
        this.setOtcEnable(fundAccnt.isOtcEnable());
        this.setFileOrderManualConfirm(fundAccnt.isFileOrderManualConfirm());
        this.setNewCashAccntId(fundAccnt.getNewCashAccntId());
        this.setExtAccntId(fundAccnt.getExtAccntId());
        this.setOldExtAccntId(fundAccnt.getOldExtAccntId());
        this.setParentId(fundAccnt.getParentId());
        this.setCurrencyId(fundAccnt.getCurrencyId());
        this.setMarket(fundAccnt.getMarket());
        this.setMarketGrp(fundAccnt.getMarketGrp());
        this.getStatus().setRaw(fundAccnt.getStatus().getRaw());
        this.setFlags(fundAccnt.getFlags());
        this.setBrokerId(fundAccnt.getBrokerId());
        this.setPwd(fundAccnt.getPwd());
        this.setInvestmarkets(fundAccnt.getInvestmarkets());
        this.setInvestId(fundAccnt.getInvestId());
        this.setAssetAmt(fundAccnt.getAssetAmt());
        this.setAccountName(fundAccnt.getAccountName());
        this.setExternalAsset(fundAccnt.isExternalAsset());
        this.setRiskAgreement(fundAccnt.getRiskAgreement());
        this.setProductName(fundAccnt.getProductName());
        this.setProductId(fundAccnt.getProductId());
        this.setCounterId(fundAccnt.getCounterId());
        this.setCounterName(fundAccnt.getCounterName());
        this.setNew(fundAccnt.isNew());
        this.setAvailable(fundAccnt.getAvailable());
        this.setHkAvailable(fundAccnt.getHkAvailable());
        this.setWithdrawQuota(fundAccnt.getWithdrawQuota());
        this.setBalanceNew(fundAccnt.getBalanceNew());
        this.setAvailableNew(fundAccnt.getAvailableNew());
        this.setMarginAvlNew(fundAccnt.getMarginAvlNew());
        this.setFcreditAvlNew(fundAccnt.getFcreditAvlNew());
        this.setDcreditAvlNew(fundAccnt.getDcreditAvlNew());
        this.setFtotalDebtsNew(fundAccnt.getFtotalDebtsNew());
        this.setDtotalDebtsNew(fundAccnt.getDtotalDebtsNew());
        this.setTotalAssetNew(fundAccnt.getTotalAssetNew());
        this.setRepayCashAvl(fundAccnt.getRepayCashAvl());
        this.setCapitalization(fundAccnt.getCapitalization());
        this.setBuyCostAmt(fundAccnt.getBuyCostAmt());
        this.setFloatPl(fundAccnt.getFloatPl());
        this.setRealPl(fundAccnt.getRealPl());
        this.setTotalPl(fundAccnt.getTotalPl());
        this.setAvailableNewXt(fundAccnt.getAvailableNewXt());
        this.setMarginAvlNewXt(fundAccnt.getMarginAvlNewXt());
        this.setFcreditAvlNewXt(fundAccnt.getFcreditAvlNewXt());
        this.setDcreditAvlNewXt(fundAccnt.getDcreditAvlNewXt());
        this.setFtotalDebtsNewXt(fundAccnt.getFtotalDebtsNewXt());
        this.setDtotalDebtsNewXt(fundAccnt.getDtotalDebtsNewXt());
        this.setTotalAssetNewXt(fundAccnt.getTotalAssetNewXt());
        this.setRepayCashAvlXt(fundAccnt.getRepayCashAvlXt());
        this.setDsaleAmtBalXt(fundAccnt.getDsaleAmtBalXt());
        this.setPosBuyAvlXt(fundAccnt.getPosBuyAvlXt());
        this.setCreditFundFee(fundAccnt.getCreditFundFee());
        this.setCreditStockFee(fundAccnt.getCreditStockFee());
        this.setCreditFundFeeCanReturn(fundAccnt.getCreditFundFeeCanReturn());
        this.setCreditStockFeeCanReturn(fundAccnt.getCreditStockFeeCanReturn());
        this.setFtotalOrgDebtsNewXt(fundAccnt.getFtotalOrgDebtsNewXt());
        this.setDtotalOrgDebtsNewXt(fundAccnt.getDtotalOrgDebtsNewXt());
        this.setEmail(fundAccnt.getEmail());
        this.setEmailId(fundAccnt.getEmailId());
    }

    public static boolean isNewFrame(FundAccount fund) {
        return fund != null && "99999-02-01".equals(fund.getCounterId()) || "99999-04-01".equals(fund.getCounterId()) || "55555-04-01".equals(fund.getCounterId()) || "99999-03-01".equals(fund.getCounterId()) || "99999-02-02".equals(fund.getCounterId()) || "55555-04-01".equals(fund.getCounterId()) || "99988-01-01".equals(fund.getCounterId()) || "99988-01-02".equals(fund.getCounterId()) || "66668-01-01".equals(fund.getCounterId()) || "99999-02-03".equals(fund.getCounterId());
    }

    public final StringProperty extAccntIdProperty() {
        return this.extAccntId;
    }

    public final String getExtAccntId() {
        return (String)this.extAccntIdProperty().get();
    }

    public final void setExtAccntId(String extAccntId) {
        this.extAccntIdProperty().set((Object)extAccntId);
    }

    public final StringProperty parentIdProperty() {
        return this.parentId;
    }

    public final String getParentId() {
        return (String)this.parentIdProperty().get();
    }

    public final void setParentId(String parentId) {
        this.parentIdProperty().set((Object)parentId);
    }

    public final StringProperty currencyIdProperty() {
        return this.currencyId;
    }

    public final String getCurrencyId() {
        return (String)this.currencyIdProperty().get();
    }

    public final void setCurrencyId(String currencyId) {
        this.currencyIdProperty().set((Object)currencyId);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public final String getMarketGrp() {
        return (String)this.marketGrpProperty().get();
    }

    public final void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set((Object)marketGrp);
    }

    public final IntegerProperty flagsProperty() {
        return this.flags;
    }

    public final int getFlags() {
        return this.flagsProperty().get();
    }

    public final void setFlags(int flags) {
        this.flagsProperty().set(flags);
    }

    public final StringProperty brokerIdProperty() {
        return this.brokerId;
    }

    public final String getBrokerId() {
        return (String)this.brokerIdProperty().get();
    }

    public final void setBrokerId(String brokerId) {
        this.brokerIdProperty().set((Object)brokerId);
    }

    public final StringProperty pwdProperty() {
        return this.pwd;
    }

    public final String getPwd() {
        return (String)this.pwdProperty().get();
    }

    public final void setPwd(String pwd) {
        this.pwdProperty().set((Object)pwd);
    }

    public final StringProperty investmarketsProperty() {
        return this.investmarkets;
    }

    public final String getInvestmarkets() {
        return (String)this.investmarketsProperty().get();
    }

    public final void setInvestmarkets(String investmarkets) {
        this.investmarketsProperty().set((Object)investmarkets);
    }

    public final StringProperty investIdProperty() {
        return this.investId;
    }

    public final String getInvestId() {
        return (String)this.investIdProperty().get();
    }

    public final void setInvestId(String investId) {
        this.investIdProperty().set((Object)investId);
    }

    public String toString() {
        return this.getInvestId();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.extAccntId.get() == null ? 0 : ((String)this.extAccntId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FundAccount other = (FundAccount)((Object)obj);
        return !(this.extAccntId.get() == null ? other.extAccntId.get() != null : !((String)this.extAccntId.get()).equals(other.extAccntId.get()));
    }

    public ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final DoubleProperty assetAmtProperty() {
        return this.assetAmt;
    }

    public final double getAssetAmt() {
        return this.assetAmtProperty().get();
    }

    public final void setAssetAmt(double assetAmt) {
        this.assetAmtProperty().set(assetAmt);
    }

    public final StringProperty accountNameProperty() {
        return this.accountName;
    }

    public final String getAccountName() {
        return (String)this.accountNameProperty().get();
    }

    public final void setAccountName(String accountName) {
        this.accountNameProperty().set((Object)accountName);
    }

    public final DoubleProperty availableProperty() {
        return this.available;
    }

    public final double getAvailable() {
        return this.availableProperty().get();
    }

    public final void setAvailable(double available) {
        this.availableProperty().set(available);
    }

    public int getRiskAgreement() {
        return this.riskAgreement;
    }

    public void setRiskAgreement(int riskAgreement) {
        this.riskAgreement = riskAgreement;
    }

    public DoubleProperty withdrawQuotaProperty() {
        return this.withdrawQuota;
    }

    public double getWithdrawQuota() {
        return this.withdrawQuotaProperty().get();
    }

    public void setWithdrawQuota(double withdrawQuota) {
        this.withdrawQuotaProperty().set(withdrawQuota);
    }

    public StringProperty productNameProperty() {
        return this.productName;
    }

    public String getProductName() {
        return (String)this.productNameProperty().get();
    }

    public void setProductName(String productName) {
        this.productNameProperty().set((Object)productName);
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public final StringProperty counterIdProperty() {
        return this.counterId;
    }

    public final String getCounterId() {
        return (String)this.counterIdProperty().get();
    }

    public final void setCounterId(String counterId) {
        this.counterIdProperty().set((Object)counterId);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public final DoubleProperty balanceNewProperty() {
        return this.balanceNew;
    }

    public final double getBalanceNew() {
        return this.balanceNewProperty().get();
    }

    public final void setBalanceNew(double balanceNew) {
        this.balanceNewProperty().set(balanceNew);
    }

    public final DoubleProperty availableNewProperty() {
        return this.availableNew;
    }

    public final double getAvailableNew() {
        return this.availableNewProperty().get();
    }

    public final void setAvailableNew(double availableNew) {
        this.availableNewProperty().set(availableNew);
    }

    public final DoubleProperty marginAvlNewProperty() {
        return this.marginAvlNew;
    }

    public final double getMarginAvlNew() {
        return this.marginAvlNewProperty().get();
    }

    public final void setMarginAvlNew(double marginAvlNew) {
        this.marginAvlNewProperty().set(marginAvlNew);
    }

    public final DoubleProperty fcreditAvlNewProperty() {
        return this.fcreditAvlNew;
    }

    public final double getFcreditAvlNew() {
        return this.fcreditAvlNewProperty().get();
    }

    public final void setFcreditAvlNew(double fcreditAvlNew) {
        this.fcreditAvlNewProperty().set(fcreditAvlNew);
    }

    public final DoubleProperty dcreditAvlNewProperty() {
        return this.dcreditAvlNew;
    }

    public final double getDcreditAvlNew() {
        return this.dcreditAvlNewProperty().get();
    }

    public final void setDcreditAvlNew(double dcreditAvlNew) {
        this.dcreditAvlNewProperty().set(dcreditAvlNew);
    }

    public final DoubleProperty ftotalDebtsNewProperty() {
        return this.ftotalDebtsNew;
    }

    public final double getFtotalDebtsNew() {
        return this.ftotalDebtsNewProperty().get();
    }

    public final void setFtotalDebtsNew(double ftotalDebtsNew) {
        this.ftotalDebtsNewProperty().set(ftotalDebtsNew);
    }

    public final DoubleProperty dtotalDebtsNewProperty() {
        return this.dtotalDebtsNew;
    }

    public final double getDtotalDebtsNew() {
        return this.dtotalDebtsNewProperty().get();
    }

    public final void setDtotalDebtsNew(double dtotalDebtsNew) {
        this.dtotalDebtsNewProperty().set(dtotalDebtsNew);
    }

    public final DoubleProperty totalAssetNewProperty() {
        return this.totalAssetNew;
    }

    public final double getTotalAssetNew() {
        return this.totalAssetNewProperty().get();
    }

    public final void setTotalAssetNew(double totalAssetNew) {
        this.totalAssetNewProperty().set(totalAssetNew);
    }

    public final DoubleProperty repayCashAvlProperty() {
        return this.repayCashAvl;
    }

    public final double getRepayCashAvl() {
        return this.repayCashAvlProperty().get();
    }

    public final void setRepayCashAvl(double repayCashAvl) {
        this.repayCashAvlProperty().set(repayCashAvl);
    }

    public String getOldExtAccntId() {
        return this.oldExtAccntId;
    }

    public void setOldExtAccntId(String oldExtAccntId) {
        this.oldExtAccntId = oldExtAccntId;
    }

    public boolean isNewAccntIdFlag() {
        return this.newAccntIdFlag;
    }

    public void setNewAccntIdFlag(boolean newAccntIdFlag) {
        this.newAccntIdFlag = newAccntIdFlag;
    }

    public final DoubleProperty buyCostAmtProperty() {
        return this.buyCostAmt;
    }

    public final double getBuyCostAmt() {
        return this.buyCostAmtProperty().get();
    }

    public final void setBuyCostAmt(double buyCostAmt) {
        this.buyCostAmtProperty().set(buyCostAmt);
    }

    public final DoubleProperty floatPlProperty() {
        return this.floatPl;
    }

    public final double getFloatPl() {
        return this.floatPlProperty().get();
    }

    public final void setFloatPl(double floatPl) {
        this.floatPlProperty().set(floatPl);
    }

    public final DoubleProperty realPlProperty() {
        return this.realPl;
    }

    public final double getRealPl() {
        return this.realPlProperty().get();
    }

    public final void setRealPl(double realPl) {
        this.realPlProperty().set(realPl);
    }

    public final DoubleProperty totalPlProperty() {
        return this.totalPl;
    }

    public final double getTotalPl() {
        return this.totalPlProperty().get();
    }

    public final void setTotalPl(double totalPl) {
        this.totalPlProperty().set(totalPl);
    }

    public final DoubleProperty capitalizationProperty() {
        return this.capitalization;
    }

    public final double getCapitalization() {
        return this.capitalizationProperty().get();
    }

    public final void setCapitalization(double capitalization) {
        this.capitalizationProperty().set(capitalization);
    }

    public final DoubleProperty hkAvailableProperty() {
        return this.hkAvailable;
    }

    public final double getHkAvailable() {
        return this.hkAvailableProperty().get();
    }

    public final void setHkAvailable(double hkAvailable) {
        this.hkAvailableProperty().set(hkAvailable);
    }

    public boolean isNeeqEnable() {
        return this.neeqEnable;
    }

    public void setNeeqEnable(boolean neeqEnable) {
        this.neeqEnable = neeqEnable;
    }

    public String getNewCashAccntId() {
        return this.newCashAccntId;
    }

    public void setNewCashAccntId(String newCashAccntId) {
        this.newCashAccntId = newCashAccntId;
    }

    public DoubleProperty newAssetAmtProperty() {
        return this.newAssetAmt;
    }

    public double getNewAssetAmt() {
        return this.newAssetAmtProperty().get();
    }

    public void setNewAssetAmt(double newAssetAmt) {
        this.newAssetAmtProperty().set(newAssetAmt);
    }

    public final DoubleProperty dsaleAmtBalProperty() {
        return this.dsaleAmtBal;
    }

    public final double getDsaleAmtBal() {
        return this.dsaleAmtBalProperty().get();
    }

    public final void setDsaleAmtBal(double dsaleAmtBal) {
        this.dsaleAmtBalProperty().set(dsaleAmtBal);
    }

    public final DoubleProperty posBuyAvlProperty() {
        return this.posBuyAvl;
    }

    public final double getPosBuyAvl() {
        return this.posBuyAvlProperty().get();
    }

    public final void setPosBuyAvl(double posBuyAvl) {
        this.posBuyAvlProperty().set(posBuyAvl);
    }

    public boolean isExternalAsset() {
        return this.externalAsset;
    }

    public void setExternalAsset(boolean externalAsset) {
        this.externalAsset = externalAsset;
    }

    public boolean isOtcEnable() {
        return this.otcEnable;
    }

    public void setOtcEnable(boolean otcEnable) {
        this.otcEnable = otcEnable;
    }

    public boolean isFileOrderManualConfirm() {
        return this.fileOrderManualConfirm;
    }

    public void setFileOrderManualConfirm(boolean fileOrderManualConfirm) {
        this.fileOrderManualConfirm = fileOrderManualConfirm;
    }

    public StringProperty counterNameProperty() {
        return this.counterName;
    }

    public String getCounterName() {
        return (String)this.counterNameProperty().get();
    }

    public void setCounterName(String counterName) {
        this.counterNameProperty().set((Object)counterName);
    }

    public final DoubleProperty balanceNewXtProperty() {
        return this.balanceNewXt;
    }

    public final double getBalanceNewXt() {
        return this.balanceNewXtProperty().get();
    }

    public final void setBalanceNewXt(double balanceNewXt) {
        this.balanceNewXtProperty().set(balanceNewXt);
    }

    public final DoubleProperty availableNewXtProperty() {
        return this.availableNewXt;
    }

    public final double getAvailableNewXt() {
        return this.availableNewXtProperty().get();
    }

    public final void setAvailableNewXt(double availableNewXt) {
        this.availableNewXtProperty().set(availableNewXt);
    }

    public final DoubleProperty marginAvlNewXtProperty() {
        return this.marginAvlNewXt;
    }

    public final double getMarginAvlNewXt() {
        return this.marginAvlNewXtProperty().get();
    }

    public final void setMarginAvlNewXt(double marginAvlNewXt) {
        this.marginAvlNewXtProperty().set(marginAvlNewXt);
    }

    public final DoubleProperty fcreditAvlNewXtProperty() {
        return this.fcreditAvlNewXt;
    }

    public final double getFcreditAvlNewXt() {
        return this.fcreditAvlNewXtProperty().get();
    }

    public final void setFcreditAvlNewXt(double fcreditAvlNewXt) {
        this.fcreditAvlNewXtProperty().set(fcreditAvlNewXt);
    }

    public final DoubleProperty dcreditAvlNewXtProperty() {
        return this.dcreditAvlNewXt;
    }

    public final double getDcreditAvlNewXt() {
        return this.dcreditAvlNewXtProperty().get();
    }

    public final void setDcreditAvlNewXt(double dcreditAvlNewXt) {
        this.dcreditAvlNewXtProperty().set(dcreditAvlNewXt);
    }

    public final DoubleProperty ftotalDebtsNewXtProperty() {
        return this.ftotalDebtsNewXt;
    }

    public final double getFtotalDebtsNewXt() {
        return this.ftotalDebtsNewXtProperty().get();
    }

    public final void setFtotalDebtsNewXt(double ftotalDebtsNewXt) {
        this.ftotalDebtsNewXtProperty().set(ftotalDebtsNewXt);
    }

    public final DoubleProperty dtotalDebtsNewXtProperty() {
        return this.dtotalDebtsNewXt;
    }

    public final double getDtotalDebtsNewXt() {
        return this.dtotalDebtsNewXtProperty().get();
    }

    public final void setDtotalDebtsNewXt(double dtotalDebtsNewXt) {
        this.dtotalDebtsNewXtProperty().set(dtotalDebtsNewXt);
    }

    public final DoubleProperty totalAssetNewXtProperty() {
        return this.totalAssetNewXt;
    }

    public final double getTotalAssetNewXt() {
        return this.totalAssetNewXtProperty().get();
    }

    public final void setTotalAssetNewXt(double totalAssetNewXt) {
        this.totalAssetNewXtProperty().set(totalAssetNewXt);
    }

    public final DoubleProperty repayCashAvlXtProperty() {
        return this.repayCashAvlXt;
    }

    public final double getRepayCashAvlXt() {
        return this.repayCashAvlXtProperty().get();
    }

    public final void setRepayCashAvlXt(double repayCashAvlXt) {
        this.repayCashAvlXtProperty().set(repayCashAvlXt);
    }

    public final DoubleProperty dsaleAmtBalXtProperty() {
        return this.dsaleAmtBalXt;
    }

    public final double getDsaleAmtBalXt() {
        return this.dsaleAmtBalXtProperty().get();
    }

    public final void setDsaleAmtBalXt(double dsaleAmtBalXt) {
        this.dsaleAmtBalXtProperty().set(dsaleAmtBalXt);
    }

    public final DoubleProperty posBuyAvlXtProperty() {
        return this.posBuyAvlXt;
    }

    public final double getPosBuyAvlXt() {
        return this.posBuyAvlXtProperty().get();
    }

    public final void setPosBuyAvlXt(double posBuyAvlXt) {
        this.posBuyAvlXtProperty().set(posBuyAvlXt);
    }

    public final DoubleProperty creditFundFeeProperty() {
        return this.creditFundFee;
    }

    public final double getCreditFundFee() {
        return this.creditFundFeeProperty().get();
    }

    public final void setCreditFundFee(double creditFundFee) {
        this.creditFundFeeProperty().set(creditFundFee);
    }

    public final DoubleProperty creditStockFeeProperty() {
        return this.creditStockFee;
    }

    public final double getCreditStockFee() {
        return this.creditStockFeeProperty().get();
    }

    public final void setCreditStockFee(double creditStockFee) {
        this.creditStockFeeProperty().set(creditStockFee);
    }

    public final DoubleProperty creditFundFeeCanReturnProperty() {
        return this.creditFundFeeCanReturn;
    }

    public final double getCreditFundFeeCanReturn() {
        return this.creditFundFeeCanReturnProperty().get();
    }

    public final void setCreditFundFeeCanReturn(double creditFundFeeCanReturn) {
        this.creditFundFeeCanReturnProperty().set(creditFundFeeCanReturn);
    }

    public final DoubleProperty creditStockFeeCanReturnProperty() {
        return this.creditStockFeeCanReturn;
    }

    public final double getCreditStockFeeCanReturn() {
        return this.creditStockFeeCanReturnProperty().get();
    }

    public final void setCreditStockFeeCanReturn(double creditStockFeeCanReturn) {
        this.creditStockFeeCanReturnProperty().set(creditStockFeeCanReturn);
    }

    public final DoubleProperty ftotalOrgDebtsNewXtProperty() {
        return this.ftotalOrgDebtsNewXt;
    }

    public final double getFtotalOrgDebtsNewXt() {
        return this.ftotalOrgDebtsNewXtProperty().get();
    }

    public final void setFtotalOrgDebtsNewXt(double ftotalOrgDebtsNewXt) {
        this.ftotalOrgDebtsNewXtProperty().set(ftotalOrgDebtsNewXt);
    }

    public final DoubleProperty dtotalOrgDebtsNewXtProperty() {
        return this.dtotalOrgDebtsNewXt;
    }

    public final double getDtotalOrgDebtsNewXt() {
        return this.dtotalOrgDebtsNewXtProperty().get();
    }

    public final void setDtotalOrgDebtsNewXt(double dtotalOrgDebtsNewXt) {
        this.dtotalOrgDebtsNewXtProperty().set(dtotalOrgDebtsNewXt);
    }

    public final StringProperty emailProperty() {
        return this.email;
    }

    public final String getEmail() {
        return (String)this.emailProperty().get();
    }

    public final void setEmail(String email) {
        this.emailProperty().set((Object)email);
    }

    public Long getEmailId() {
        return this.emailId;
    }

    public void setEmailId(Long emailId) {
        this.emailId = emailId;
    }

    public StringProperty showNameProperty() {
        if (this.getInvestId().isEmpty()) {
            return new SimpleStringProperty(this.getAccountName());
        }
        return new SimpleStringProperty(String.valueOf(this.getInvestId()) + "-" + this.getAccountName());
    }

    public String getId() {
        return this.getInvestId();
    }
}

