/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.entity.FundAccount;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpFundAccount
extends FundAccount {
    private DoubleProperty deposit = new SimpleDoubleProperty(0.0);
    private DoubleProperty withDraw = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenCash = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenCommission = new SimpleDoubleProperty(0.0);
    private DoubleProperty currentMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty cashIn = new SimpleDoubleProperty(0.0);
    private DoubleProperty commission = new SimpleDoubleProperty(0.0);
    private DoubleProperty closeProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty balance = new SimpleDoubleProperty(0.0);
    private DoubleProperty reserve = new SimpleDoubleProperty(0.0);
    private DoubleProperty credit = new SimpleDoubleProperty(0.0);
    private DoubleProperty mortgage = new SimpleDoubleProperty(0.0);
    private DoubleProperty exchangeMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty deliveryMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty exchangeDeliveryMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty reserveBalance = new SimpleDoubleProperty(0.0);
    private StringProperty tradingDay = new SimpleStringProperty("");
    private DoubleProperty positionProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty preMortgage = new SimpleDoubleProperty(0.0);
    private DoubleProperty preCredit = new SimpleDoubleProperty(0.0);
    private DoubleProperty preDeposit = new SimpleDoubleProperty(0.0);
    private DoubleProperty preBalance = new SimpleDoubleProperty(0.0);
    private DoubleProperty preMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty firstBenefit = new SimpleDoubleProperty(0.0);
    private DoubleProperty staticBenefit = new SimpleDoubleProperty(0.0);
    private DoubleProperty dynamicBenefit = new SimpleDoubleProperty(0.0);
    private DoubleProperty marginRatio = new SimpleDoubleProperty(0.0);
    private static final Logger logger = LogManager.getLogger(CtpFundAccount.class);

    @Override
    public void update(Object obj) {
        try {
            super.update(obj);
            if (obj instanceof CtpFundAccount) {
                CtpFundAccount ctpFundAccnt = (CtpFundAccount)((Object)CtpFundAccount.class.cast(obj));
                this.update(ctpFundAccnt);
                return;
            }
            PAccount.ExtFundAccnt fundAccnt = (PAccount.ExtFundAccnt)PAccount.ExtFundAccnt.class.cast(obj);
            PCtpExtra.CTPExtFundAccnt ctp = (PCtpExtra.CTPExtFundAccnt)fundAccnt.getObject().unpack(PCtpExtra.CTPExtFundAccnt.class);
            PCtpExtra.CTPFundAccntExtra ctpFund = (PCtpExtra.CTPFundAccntExtra)PCtpExtra.CTPFundAccntExtra.class.cast(ctp.getExtra());
            this.update(ctpFund);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error(e.getMessage());
        }
    }

    private void update(PCtpExtra.CTPFundAccntExtra ctp) {
        this.setCloseProfit(ctp.getCloseProfit());
        this.setPositionProfit(ctp.getPositionProfit());
        this.setAvailable(ctp.getAvailable());
        this.setTotalProfit(this.getCloseProfit() + this.getPositionProfit());
        this.setExchangeMargin(ctp.getExchangeMargin());
        this.setPreBalance(ctp.getPreBalance());
        this.setPreMargin(ctp.getPreMargin());
        this.setCurrentMargin(ctp.getCurrentMargin());
        this.setFirstBenefit(ctp.getPreBalance() + ctp.getPreMargin());
        this.setStaticBenefit(ctp.getPreBalance() - ctp.getPreCredit() - ctp.getPreMortgage() + ctp.getMortgage() + ctp.getDeposit() - ctp.getWithDraw());
        this.setDynamicBenefit(this.getStaticBenefit() + ctp.getCloseProfit() + ctp.getPositionProfit() - ctp.getCommission());
        this.setMarginRatio(ctp.getCurrentMargin() / this.getDynamicBenefit());
    }

    private void update(CtpFundAccount ctp) {
        this.setCloseProfit(ctp.getCloseProfit());
        this.setPositionProfit(ctp.getPositionProfit());
        this.setAvailable(ctp.getAvailable());
        this.setTotalProfit(this.getCloseProfit() + this.getPositionProfit());
        this.setExchangeMargin(ctp.getExchangeMargin());
        this.setPreBalance(ctp.getPreBalance());
        this.setPreMargin(ctp.getPreMargin());
        this.setCurrentMargin(ctp.getCurrentMargin());
        this.setFirstBenefit(ctp.getPreBalance() + ctp.getPreMargin());
        this.setStaticBenefit(ctp.getStaticBenefit());
        this.setDynamicBenefit(ctp.getDynamicBenefit());
        this.setMarginRatio(ctp.getMarginRatio());
    }

    public DoubleProperty depositProperty() {
        return this.deposit;
    }

    public double getDeposit() {
        return this.depositProperty().get();
    }

    public void setDeposit(double deposit) {
        this.depositProperty().set(deposit);
    }

    public DoubleProperty withDrawProperty() {
        return this.withDraw;
    }

    public double getWithDraw() {
        return this.withDrawProperty().get();
    }

    public void setWithDraw(double withDraw) {
        this.withDrawProperty().set(withDraw);
    }

    public DoubleProperty frozenMarginProperty() {
        return this.frozenMargin;
    }

    public double getFrozenMargin() {
        return this.frozenMarginProperty().get();
    }

    public void setFrozenMargin(double frozenMargin) {
        this.frozenMarginProperty().set(frozenMargin);
    }

    public DoubleProperty frozenCashProperty() {
        return this.frozenCash;
    }

    public double getFrozenCash() {
        return this.frozenCashProperty().get();
    }

    public void setFrozenCash(double frozenCash) {
        this.frozenCashProperty().set(frozenCash);
    }

    public DoubleProperty frozenCommissionProperty() {
        return this.frozenCommission;
    }

    public double getFrozenCommission() {
        return this.frozenCommissionProperty().get();
    }

    public void setFrozenCommission(double frozenCommission) {
        this.frozenCommissionProperty().set(frozenCommission);
    }

    public DoubleProperty currentMarginProperty() {
        return this.currentMargin;
    }

    public double getCurrentMargin() {
        return this.currentMarginProperty().get();
    }

    public void setCurrentMargin(double currentMargin) {
        this.currentMarginProperty().set(currentMargin);
    }

    public DoubleProperty cashInProperty() {
        return this.cashIn;
    }

    public double getCashIn() {
        return this.cashInProperty().get();
    }

    public void setCashIn(double cashIn) {
        this.cashInProperty().set(cashIn);
    }

    public DoubleProperty commissionProperty() {
        return this.commission;
    }

    public double getCommission() {
        return this.commissionProperty().get();
    }

    public void setCommission(double commission) {
        this.commissionProperty().set(commission);
    }

    public DoubleProperty closeProfitProperty() {
        return this.closeProfit;
    }

    public double getCloseProfit() {
        return this.closeProfitProperty().get();
    }

    public void setCloseProfit(double closeProfit) {
        this.closeProfitProperty().set(closeProfit);
    }

    public DoubleProperty balanceProperty() {
        return this.balance;
    }

    public double getBalance() {
        return this.balanceProperty().get();
    }

    public void setBalance(double balance) {
        this.balanceProperty().set(balance);
    }

    public DoubleProperty reserveProperty() {
        return this.reserve;
    }

    public double getReserve() {
        return this.reserveProperty().get();
    }

    public void setReserve(double reserve) {
        this.reserveProperty().set(reserve);
    }

    public DoubleProperty creditProperty() {
        return this.credit;
    }

    public double getCredit() {
        return this.creditProperty().get();
    }

    public void setCredit(double credit) {
        this.creditProperty().set(credit);
    }

    public DoubleProperty mortgageProperty() {
        return this.mortgage;
    }

    public double getMortgage() {
        return this.mortgageProperty().get();
    }

    public void setMortgage(double mortgage) {
        this.mortgageProperty().set(mortgage);
    }

    public DoubleProperty exchangeMarginProperty() {
        return this.exchangeMargin;
    }

    public double getExchangeMargin() {
        return this.exchangeMarginProperty().get();
    }

    public void setExchangeMargin(double exchangeMargin) {
        this.exchangeMarginProperty().set(exchangeMargin);
    }

    public DoubleProperty deliveryMarginProperty() {
        return this.deliveryMargin;
    }

    public double getDeliveryMargin() {
        return this.deliveryMarginProperty().get();
    }

    public void setDeliveryMargin(double deliveryMargin) {
        this.deliveryMarginProperty().set(deliveryMargin);
    }

    public DoubleProperty exchangeDeliveryMarginProperty() {
        return this.exchangeDeliveryMargin;
    }

    public double getExchangeDeliveryMargin() {
        return this.exchangeDeliveryMarginProperty().get();
    }

    public void setExchangeDeliveryMargin(double exchangeDeliveryMargin) {
        this.exchangeDeliveryMarginProperty().set(exchangeDeliveryMargin);
    }

    public DoubleProperty reserveBalanceProperty() {
        return this.reserveBalance;
    }

    public double getReserveBalance() {
        return this.reserveBalanceProperty().get();
    }

    public void setReserveBalance(double reserveBalance) {
        this.reserveBalanceProperty().set(reserveBalance);
    }

    public StringProperty tradingDayProperty() {
        return this.tradingDay;
    }

    public String getTradingDay() {
        return (String)this.tradingDayProperty().get();
    }

    public void setTradingDay(String tradingDay) {
        this.tradingDayProperty().set((Object)tradingDay);
    }

    public DoubleProperty positionProfitProperty() {
        return this.positionProfit;
    }

    public double getPositionProfit() {
        return this.positionProfitProperty().get();
    }

    public void setPositionProfit(double positionProfit) {
        this.positionProfitProperty().set(positionProfit);
    }

    public DoubleProperty preMortgageProperty() {
        return this.preMortgage;
    }

    public double getPreMortgage() {
        return this.preMortgageProperty().get();
    }

    public void setPreMortgage(double preMortgage) {
        this.preMortgageProperty().set(preMortgage);
    }

    public DoubleProperty preCreditProperty() {
        return this.preCredit;
    }

    public double getPreCredit() {
        return this.preCreditProperty().get();
    }

    public void setPreCredit(double preCredit) {
        this.preCreditProperty().set(preCredit);
    }

    public DoubleProperty preDepositProperty() {
        return this.preDeposit;
    }

    public double getPreDeposit() {
        return this.preDepositProperty().get();
    }

    public void setPreDeposit(double preDeposit) {
        this.preDepositProperty().set(preDeposit);
    }

    public DoubleProperty preBalanceProperty() {
        return this.preBalance;
    }

    public double getPreBalance() {
        return this.preBalanceProperty().get();
    }

    public void setPreBalance(double preBalance) {
        this.preBalanceProperty().set(preBalance);
    }

    public DoubleProperty preMarginProperty() {
        return this.preMargin;
    }

    public double getPreMargin() {
        return this.preMarginProperty().get();
    }

    public void setPreMargin(double preMargin) {
        this.preMarginProperty().set(preMargin);
    }

    public DoubleProperty totalProfitProperty() {
        return this.totalProfit;
    }

    public double getTotalProfit() {
        return this.totalProfitProperty().get();
    }

    public void setTotalProfit(double totalProfit) {
        this.totalProfitProperty().set(totalProfit);
    }

    public DoubleProperty firstBenefitProperty() {
        return this.firstBenefit;
    }

    public double getFirstBenefit() {
        return this.firstBenefitProperty().get();
    }

    public void setFirstBenefit(double firstBenefit) {
        this.firstBenefitProperty().set(firstBenefit);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final DoubleProperty dynamicBenefitProperty() {
        return this.dynamicBenefit;
    }

    public final double getDynamicBenefit() {
        return this.dynamicBenefitProperty().get();
    }

    public final void setDynamicBenefit(double dynamicBenefit) {
        this.dynamicBenefitProperty().set(dynamicBenefit);
    }

    public final DoubleProperty staticBenefitProperty() {
        return this.staticBenefit;
    }

    public final double getStaticBenefit() {
        return this.staticBenefitProperty().get();
    }

    public final void setStaticBenefit(double staticBenefit) {
        this.staticBenefitProperty().set(staticBenefit);
    }

    public final DoubleProperty marginRatioProperty() {
        return this.marginRatio;
    }

    public final double getMarginRatio() {
        return this.marginRatioProperty().get();
    }

    public final void setMarginRatio(double marginRatio) {
        this.marginRatioProperty().set(marginRatio);
    }
}

