/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.protobuf.InvalidProtocolBufferException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcsSubFundAccount
extends CcsFundAccount
implements Comparable<CcsSubFundAccount> {
    private static final Logger logger = LogManager.getLogger(CcsSubFundAccount.class);
    private StringProperty subAccntId = new SimpleStringProperty("");
    private StringProperty subAccntName = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty parentExtAccntId = new SimpleStringProperty("");
    private StringProperty parentSubAccntId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> subFlag = new SimpleObjectProperty();
    private ObjectProperty<MxNode> subStatus = new SimpleObjectProperty();
    private ObjectProperty<MxNode> isZeroAccnt = new SimpleObjectProperty();
    private DoubleProperty subFrozenAmount = new SimpleDoubleProperty();
    @Inject
    private MObjFactory of;

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.subAccntId.get() == null ? 0 : ((String)this.subAccntId.get()).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CcsSubFundAccount other = (CcsSubFundAccount)obj;
        return !(this.subAccntId.get() == null ? other.subAccntId.get() != null : !((String)this.subAccntId.get()).equals(other.subAccntId.get()));
    }

    @PostConstruct
    private void init() {
        MxNode node = MxNodeFactory.create((String)"sub_accnt_status", (String)"0");
        this.setSubStatus(node);
        node = MxNodeFactory.create((String)"sub_accnt_flag", (String)"0");
        this.setSubFlag(node);
        node = MxNodeFactory.create((String)"sub_is_zero_accnt", (String)"0");
        this.setIsZeroAccnt(node);
    }

    @Override
    public void update(Object obj) {
        if (obj instanceof PAccount.SubFundAccnt) {
            PAccount.SubFundAccnt subFundAccnt = (PAccount.SubFundAccnt)PAccount.SubFundAccnt.class.cast(obj);
            this.update(subFundAccnt);
            try {
                PCcsExtra.CcsSubFundAccntExtra ccsExFundAccnt = (PCcsExtra.CcsSubFundAccntExtra)subFundAccnt.getObject().unpack(PCcsExtra.CcsSubFundAccntExtra.class);
                PCcsExtra.CcsFundAccnt ccsFundAccnt = (PCcsExtra.CcsFundAccnt)PCcsExtra.CcsFundAccnt.class.cast(ccsExFundAccnt.getFundAccnt());
                this.update(ccsFundAccnt);
            }
            catch (InvalidProtocolBufferException e) {
                logger.error("\u6295\u7ec4\u4e8c\u7ea7\u8d44\u91d1\u8d26\u53f7\u83b7\u53d6\u8d44\u91d1\u660e\u7ec6\u5931\u8d25" + e.getMessage());
            }
            this.changed();
        } else if (obj instanceof CcsSubFundAccount) {
            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(obj);
            this.update(subFundAccnt);
            this.changed();
        } else if (obj instanceof CashAccnt) {
            this.update((CashAccnt)CashAccnt.class.cast(obj));
        }
    }

    private void update(PAccount.SubFundAccnt subFundAccnt) {
        this.setParentId(subFundAccnt.getParentExtAccntId());
        this.setExtAccntId(subFundAccnt.getExtAccntId());
        this.setOldExtAccntId(subFundAccnt.getExtAccntId());
        this.setCurrencyId(subFundAccnt.getCurrencyId());
        this.setInvestId(subFundAccnt.getInvestorId());
        this.setCounterId(subFundAccnt.getTradePlatformId());
        this.setSubAccntId(subFundAccnt.getSubAccntId());
        this.setSubAccntName(subFundAccnt.getSubAccntName());
        this.setPortfolioId(subFundAccnt.getPortfolioId());
        this.setParentExtAccntId(subFundAccnt.getParentExtAccntId());
        this.setParentSubAccntId(subFundAccnt.getParentSubAccntId());
        this.getSubFlag().setRaw(Integer.toString(subFundAccnt.getFlags()));
        this.getSubStatus().setRaw(Integer.toString(subFundAccnt.getStatus()));
        this.getIsZeroAccnt().setRaw(Integer.toString(subFundAccnt.getIsZeroAccnt()));
    }

    private void update(CcsSubFundAccount subFundAccnt) {
        this.setSubAccntId(subFundAccnt.getSubAccntId());
        this.setSubAccntName(subFundAccnt.getSubAccntName());
        this.setCurrencyId(subFundAccnt.getCurrencyId());
        this.setPortfolioId(subFundAccnt.getPortfolioId());
        this.setPortfolioName(subFundAccnt.getPortfolioName());
        this.setParentExtAccntId(subFundAccnt.getParentExtAccntId());
        this.setParentSubAccntId(subFundAccnt.getParentSubAccntId());
        this.setParentId(subFundAccnt.getParentId());
        this.setExtAccntId(subFundAccnt.getExtAccntId());
        this.setInvestId(subFundAccnt.getInvestId());
        this.setAssetAmt(subFundAccnt.getAssetAmt());
        this.setAvailable(subFundAccnt.getAvailable());
        this.setHkAvailable(subFundAccnt.getAvailable());
        this.setWithdrawQuota(subFundAccnt.getWithdrawQuota());
        this.setSubFrozenAmount(subFundAccnt.getSubFrozenAmount());
        this.getSubFlag().setRaw(subFundAccnt.getSubFlag().getRaw());
        this.getSubStatus().setRaw(subFundAccnt.getSubStatus().getRaw());
        this.getIsZeroAccnt().setRaw(subFundAccnt.getIsZeroAccnt().getRaw());
        this.setTradingDay(subFundAccnt.getTradingDay());
    }

    private void update(PCcsExtra.CcsFundAccnt ccsFundAccnt) {
        this.setAvailable(ccsFundAccnt.getAvailable());
        this.setHkAvailable(ccsFundAccnt.getHkAvailable());
        this.setSubFrozenAmount(ccsFundAccnt.getFrozenAmount());
        this.setTradingDay(ccsFundAccnt.getTradingDay());
        this.setWithdrawQuota(ccsFundAccnt.getWithdrawQuota());
        this.setPreBalance(ccsFundAccnt.getPreBalance());
        this.setCurrency(ccsFundAccnt.getCurrency());
    }

    private void update(CashAccnt fundAccnt) {
        this.setNewAccntIdFlag(true);
        this.setNewCashAccntId(fundAccnt.getCashAccntId());
    }

    public final StringProperty subAccntIdProperty() {
        return this.subAccntId;
    }

    public final String getSubAccntId() {
        return (String)this.subAccntIdProperty().get();
    }

    public final void setSubAccntId(String subAccntId) {
        this.subAccntIdProperty().set((Object)subAccntId);
    }

    public final StringProperty subAccntNameProperty() {
        return this.subAccntName;
    }

    public final String getSubAccntName() {
        return (String)this.subAccntNameProperty().get();
    }

    public final void setSubAccntName(String subAccntName) {
        this.subAccntNameProperty().set((Object)subAccntName);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty parentSubAccntIdProperty() {
        return this.parentSubAccntId;
    }

    public final String getParentSubAccntId() {
        return (String)this.parentSubAccntIdProperty().get();
    }

    public final void setParentSubAccntId(String parentSubAccntId) {
        this.parentSubAccntIdProperty().set((Object)parentSubAccntId);
    }

    public final ObjectProperty<MxNode> subFlagProperty() {
        return this.subFlag;
    }

    public final MxNode getSubFlag() {
        return (MxNode)this.subFlagProperty().get();
    }

    public final void setSubFlag(MxNode subFlag) {
        this.subFlagProperty().set((Object)subFlag);
    }

    public final ObjectProperty<MxNode> subStatusProperty() {
        return this.subStatus;
    }

    public final MxNode getSubStatus() {
        return (MxNode)this.subStatusProperty().get();
    }

    public final void setSubStatus(MxNode subStatus) {
        this.subStatusProperty().set((Object)subStatus);
    }

    public final ObjectProperty<MxNode> isZeroAccntProperty() {
        return this.isZeroAccnt;
    }

    public final MxNode getIsZeroAccnt() {
        return (MxNode)this.isZeroAccntProperty().get();
    }

    public final void setIsZeroAccnt(MxNode isZeroAccnt) {
        this.isZeroAccntProperty().set((Object)isZeroAccnt);
    }

    public final DoubleProperty subFrozenAmountProperty() {
        return this.subFrozenAmount;
    }

    public final double getSubFrozenAmount() {
        return this.subFrozenAmountProperty().get();
    }

    public final void setSubFrozenAmount(double subFrozenAmount) {
        this.subFrozenAmountProperty().set(subFrozenAmount);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    @Override
    public int compareTo(CcsSubFundAccount o) {
        return this.getSubAccntId().compareTo(o.getSubAccntId());
    }

    public final StringProperty parentExtAccntIdProperty() {
        return this.parentExtAccntId;
    }

    public final String getParentExtAccntId() {
        return (String)this.parentExtAccntIdProperty().get();
    }

    public final void setParentExtAccntId(String parentExtAccntId) {
        this.parentExtAccntIdProperty().set((Object)parentExtAccntId);
    }
}

