/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PMarketService;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsCommission
extends MxChgSelObj {
    private StringProperty currency = new SimpleStringProperty("");
    private StringProperty curStr = new SimpleStringProperty("");
    private DoubleProperty buy_commission_rate = new SimpleDoubleProperty(0.0);
    private DoubleProperty sell_commission_rate = new SimpleDoubleProperty(0.0);
    private DoubleProperty min_buy_commission = new SimpleDoubleProperty(0.0);
    private DoubleProperty min_sell_commission = new SimpleDoubleProperty(0.0);
    private DoubleProperty buy_transfer_fee_rate = new SimpleDoubleProperty(0.0);
    private DoubleProperty sell_transfer_fee_rate = new SimpleDoubleProperty(0.0);
    private DoubleProperty min_buy_transfer_fee = new SimpleDoubleProperty(0.0);
    private DoubleProperty min_sell_transfer_fee = new SimpleDoubleProperty(0.0);
    private DoubleProperty buy_stamp_tax_rate = new SimpleDoubleProperty(0.0);
    private DoubleProperty sell_stamp_tax_rate = new SimpleDoubleProperty(0.0);
    private StringProperty market_grp = new SimpleStringProperty("");
    private StringProperty ext_accnt_id = new SimpleStringProperty("");
    private StringProperty type = new SimpleStringProperty("");
    private StringProperty time = new SimpleStringProperty("");
    private static final Logger logger = LogManager.getLogger(CcsCommission.class);
    private static MxNode nodeCur;
    public static final String CURRENCY_TYPE = "currency_type";

    @PostConstruct
    public void init() {
        nodeCur = MxNodeFactory.create((String)CURRENCY_TYPE, (String)"");
    }

    public void update(Object obj) {
        try {
            Object commission;
            if (obj instanceof PMarketService.Commission) {
                commission = (PMarketService.Commission)PMarketService.Commission.class.cast(obj);
                this.update((PMarketService.Commission)commission);
                PCcsExtra.CcsCommissionExtra ccs = (PCcsExtra.CcsCommissionExtra)commission.getObject().unpack(PCcsExtra.CcsCommissionExtra.class);
                this.update(ccs);
                this.changed();
            }
            if (obj instanceof CcsCommission) {
                commission = (CcsCommission)((Object)CcsCommission.class.cast(obj));
                this.update((CcsCommission)((Object)commission));
                this.changed();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void update(CcsCommission ccs) {
        this.setCurrency(ccs.getCurrency());
        this.setCurStr(this.currencyParse());
        this.setBuy_commission_rate(ccs.getBuy_commission_rate());
        this.setSell_commission_rate(ccs.getSell_commission_rate());
        this.setMin_buy_commission(ccs.getMin_buy_commission());
        this.setMin_sell_commission(ccs.getMin_buy_commission());
        this.setBuy_transfer_fee_rate(ccs.getBuy_transfer_fee_rate());
        this.setSell_transfer_fee_rate(ccs.getBuy_transfer_fee_rate());
        this.setMin_buy_transfer_fee(ccs.getMin_buy_transfer_fee());
        this.setMin_sell_transfer_fee(ccs.getMin_buy_transfer_fee());
        this.setBuy_stamp_tax_rate(ccs.getBuy_stamp_tax_rate());
        this.setSell_stamp_tax_rate(ccs.getSell_stamp_tax_rate());
        this.setExt_accnt_id(ccs.getExt_accnt_id());
        this.setMarket_grp(ccs.getMarket_grp());
        this.setType(ccs.getType());
        this.setTime(ccs.getTime());
    }

    private void update(PCcsExtra.CcsCommissionExtra ccs) {
        this.setCurrency(ccs.getCurrency());
        this.setCurStr(this.currencyParse());
        this.setBuy_commission_rate(ccs.getBuyCommissionRate());
        this.setSell_commission_rate(ccs.getSellCommissionRate());
        this.setMin_buy_commission(ccs.getMinBuyCommission());
        this.setMin_sell_commission(ccs.getMinSellCommission());
        this.setBuy_transfer_fee_rate(ccs.getBuyTransferFeeRate());
        this.setSell_transfer_fee_rate(ccs.getSellTransferFeeRate());
        this.setMin_buy_transfer_fee(ccs.getMinBuyTransferFee());
        this.setMin_sell_transfer_fee(ccs.getMinSellTransferFee());
        this.setBuy_stamp_tax_rate(ccs.getBuyStampTaxRate());
        this.setSell_stamp_tax_rate(ccs.getSellStampTaxRate());
        this.setTime(ccs.getLastModifyDatetime());
    }

    private void update(PMarketService.Commission commission) {
        this.setExt_accnt_id(commission.getExtAccntId());
        this.setMarket_grp(commission.getMarketGrp());
        this.setType(commission.getType());
        this.setTime(commission.getLastModifyDatetime());
    }

    private String currencyParse() {
        String cur = this.getCurrency();
        nodeCur.setRaw(cur);
        String name = nodeCur.getValue();
        return name;
    }

    public final DoubleProperty buy_commission_rateProperty() {
        return this.buy_commission_rate;
    }

    public final double getBuy_commission_rate() {
        return this.buy_commission_rateProperty().get();
    }

    public final void setBuy_commission_rate(double buy_commission_rate) {
        this.buy_commission_rateProperty().set(buy_commission_rate);
    }

    public final DoubleProperty sell_commission_rateProperty() {
        return this.sell_commission_rate;
    }

    public final double getSell_commission_rate() {
        return this.sell_commission_rateProperty().get();
    }

    public final void setSell_commission_rate(double sell_commission_rate) {
        this.sell_commission_rateProperty().set(sell_commission_rate);
    }

    public final DoubleProperty min_buy_commissionProperty() {
        return this.min_buy_commission;
    }

    public final double getMin_buy_commission() {
        return this.min_buy_commissionProperty().get();
    }

    public final void setMin_buy_commission(double min_buy_commission) {
        this.min_buy_commissionProperty().set(min_buy_commission);
    }

    public final DoubleProperty min_sell_commissionProperty() {
        return this.min_sell_commission;
    }

    public final double getMin_sell_commission() {
        return this.min_sell_commissionProperty().get();
    }

    public final void setMin_sell_commission(double min_sell_commission) {
        this.min_sell_commissionProperty().set(min_sell_commission);
    }

    public final DoubleProperty buy_transfer_fee_rateProperty() {
        return this.buy_transfer_fee_rate;
    }

    public final double getBuy_transfer_fee_rate() {
        return this.buy_transfer_fee_rateProperty().get();
    }

    public final void setBuy_transfer_fee_rate(double buy_transfer_fee_rate) {
        this.buy_transfer_fee_rateProperty().set(buy_transfer_fee_rate);
    }

    public final DoubleProperty sell_transfer_fee_rateProperty() {
        return this.sell_transfer_fee_rate;
    }

    public final double getSell_transfer_fee_rate() {
        return this.sell_transfer_fee_rateProperty().get();
    }

    public final void setSell_transfer_fee_rate(double sell_transfer_fee_rate) {
        this.sell_transfer_fee_rateProperty().set(sell_transfer_fee_rate);
    }

    public final DoubleProperty min_buy_transfer_feeProperty() {
        return this.min_buy_transfer_fee;
    }

    public final double getMin_buy_transfer_fee() {
        return this.min_buy_transfer_feeProperty().get();
    }

    public final void setMin_buy_transfer_fee(double min_buy_transfer_fee) {
        this.min_buy_transfer_feeProperty().set(min_buy_transfer_fee);
    }

    public final DoubleProperty min_sell_transfer_feeProperty() {
        return this.min_sell_transfer_fee;
    }

    public final double getMin_sell_transfer_fee() {
        return this.min_sell_transfer_feeProperty().get();
    }

    public final void setMin_sell_transfer_fee(double min_sell_transfer_fee) {
        this.min_sell_transfer_feeProperty().set(min_sell_transfer_fee);
    }

    public final DoubleProperty buy_stamp_tax_rateProperty() {
        return this.buy_stamp_tax_rate;
    }

    public final double getBuy_stamp_tax_rate() {
        return this.buy_stamp_tax_rateProperty().get();
    }

    public final void setBuy_stamp_tax_rate(double buy_stamp_tax_rate) {
        this.buy_stamp_tax_rateProperty().set(buy_stamp_tax_rate);
    }

    public final DoubleProperty sell_stamp_tax_rateProperty() {
        return this.sell_stamp_tax_rate;
    }

    public final double getSell_stamp_tax_rate() {
        return this.sell_stamp_tax_rateProperty().get();
    }

    public final void setSell_stamp_tax_rate(double sell_stamp_tax_rate) {
        this.sell_stamp_tax_rateProperty().set(sell_stamp_tax_rate);
    }

    public final StringProperty market_grpProperty() {
        return this.market_grp;
    }

    public final String getMarket_grp() {
        return (String)this.market_grpProperty().get();
    }

    public final void setMarket_grp(String market_grp) {
        this.market_grpProperty().set((Object)market_grp);
    }

    public final StringProperty ext_accnt_idProperty() {
        return this.ext_accnt_id;
    }

    public final String getExt_accnt_id() {
        return (String)this.ext_accnt_idProperty().get();
    }

    public final void setExt_accnt_id(String ext_accnt_id) {
        this.ext_accnt_idProperty().set((Object)ext_accnt_id);
    }

    public final StringProperty curStrProperty() {
        return this.curStr;
    }

    public final String getCurStr() {
        return (String)this.curStrProperty().get();
    }

    public final void setCurStr(String curStr) {
        this.curStrProperty().set((Object)curStr);
    }

    public final StringProperty currencyProperty() {
        return this.currency;
    }

    public final String getCurrency() {
        return (String)this.currencyProperty().get();
    }

    public final void setCurrency(String currency) {
        this.currencyProperty().set((Object)currency);
    }

    public final StringProperty typeProperty() {
        return this.type;
    }

    public final String getType() {
        return (String)this.typeProperty().get();
    }

    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final StringProperty timeProperty() {
        return this.time;
    }

    public final String getTime() {
        return (String)this.timeProperty().get();
    }

    public final void setTime(String time) {
        this.timeProperty().set((Object)time);
    }
}

