/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.proto.broker.PBroker;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Broker
extends MxChgObj {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty fullName = new SimpleStringProperty("");
    private StringProperty typeStr = new SimpleStringProperty();
    private StringProperty creator = new SimpleStringProperty("");
    private StringProperty createTime = new SimpleStringProperty("");
    private StringProperty lastUpdater = new SimpleStringProperty("");
    private StringProperty lastUpdateTime = new SimpleStringProperty("");
    private List<String> types = new LinkedList<String>();
    private static MxNode typeNode;

    @PostConstruct
    public void init() {
        typeNode = MxNodeFactory.create((String)"business_type", (String)"Futures");
    }

    public void update(Object obj) {
        if (obj instanceof PBroker.Broker) {
            PBroker.Broker accnt = (PBroker.Broker)PBroker.Broker.class.cast(obj);
            this.update(accnt);
            this.changed();
        } else if (obj instanceof Broker) {
            Broker b = (Broker)((Object)Broker.class.cast(obj));
            this.update(b);
        }
    }

    private void update(PBroker.Broker broker) {
        this.setId(broker.getId());
        this.setName(broker.getName());
        this.setFullName(broker.getFullName());
        this.setCode(broker.getBrokerId());
        this.setTypes((List<String>)broker.getBusinessTypesList());
        this.setTypeStr(this.typeParse());
        this.setCreator(broker.getCreator());
        this.setCreateTime(broker.getCreateTime());
        this.setLastUpdater(broker.getLastUpdater());
        this.setLastUpdateTime(broker.getLastUpdateTime());
    }

    private void update(Broker broker) {
        this.setId(broker.getId());
        this.setName(broker.getName());
        this.setFullName(broker.getFullName());
        this.setCode(broker.getCode());
        this.setTypes(broker.getTypes());
        this.setTypeStr(this.typeParse());
        this.setCreator(broker.getCreator());
        this.setCreateTime(broker.getCreateTime());
        this.setLastUpdater(broker.getLastUpdater());
        this.setLastUpdateTime(broker.getLastUpdateTime());
    }

    private String typeParse() {
        List<String> list = this.getTypes();
        LinkedList<String> listName = new LinkedList<String>();
        for (String english : list) {
            typeNode.setRaw(english);
            listName.add(typeNode.getValue());
        }
        String strName = ((Object)listName).toString();
        return strName.substring(1, strName.length() - 1);
    }

    public String toString() {
        return (String)this.name.get();
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty fullNameProperty() {
        return this.fullName;
    }

    public final String getFullName() {
        return (String)this.fullNameProperty().get();
    }

    public final void setFullName(String fullName) {
        this.fullNameProperty().set((Object)fullName);
    }

    public final StringProperty creatorProperty() {
        return this.creator;
    }

    public final String getCreator() {
        return (String)this.creatorProperty().get();
    }

    public final void setCreator(String creator) {
        this.creatorProperty().set((Object)creator);
    }

    public final StringProperty createTimeProperty() {
        return this.createTime;
    }

    public final String getCreateTime() {
        return (String)this.createTimeProperty().get();
    }

    public final void setCreateTime(String createTime) {
        this.createTimeProperty().set((Object)createTime);
    }

    public final StringProperty lastUpdaterProperty() {
        return this.lastUpdater;
    }

    public final String getLastUpdater() {
        return (String)this.lastUpdaterProperty().get();
    }

    public final void setLastUpdater(String lastUpdater) {
        this.lastUpdaterProperty().set((Object)lastUpdater);
    }

    public final StringProperty lastUpdateTimeProperty() {
        return this.lastUpdateTime;
    }

    public final String getLastUpdateTime() {
        return (String)this.lastUpdateTimeProperty().get();
    }

    public final void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTimeProperty().set((Object)lastUpdateTime);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id.get() == null ? 0 : ((String)this.id.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Broker other = (Broker)((Object)obj);
        return !(this.id.get() == null ? other.id.get() != null : !((String)this.id.get()).equals(other.id.get()));
    }

    public final StringProperty typeStrProperty() {
        return this.typeStr;
    }

    public final String getTypeStr() {
        return (String)this.typeStrProperty().get();
    }

    public final void setTypeStr(String typeStr) {
        this.typeStrProperty().set((Object)typeStr);
    }
}

