/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.TradeCaptureReportAdvice;
import cms.tmx.javafx.obj.MxObject;

public class BlockTradeParam
extends MxObject {
    public static final int TRADE_REPORT_SUB_TYPE_NO_SPECIAL_INT = 3;
    private FundAccount fundAccount;
    private SecAccount secAccount;
    private String marketGrp = "";
    private Instrument instrument = new Instrument();
    private String extAccntId = "";
    private String extSecAccntId = "";
    private String investorId = "";
    private String subAccntId = "";
    private String subSecAccntId = "";
    private String portfolioId = "";
    private int side;
    private int tradeReportType = 1;
    private int trdType;
    private int trdSubType;
    private int shareHolderType;
    private double price;
    private long orderQty;
    double cashOrderQty;
    private String confirmId = "";
    private String partyId = "";
    private boolean agreeProtocol;
    private int applType;
    private String instructionPanelType = "";
    private String flowAttriId = "";
    private String stepAttrId = "";
    private String otherTrader = "";
    private String resourceId = "";
    private String referenceId = "";
    private String action = "";
    private boolean isRtgs;

    public PPostTrade.TradeCaptureReport.Builder getTradeCaptureReportBuilder() {
        PPostTrade.TradeCaptureReport.Builder tradeBuilder = PPostTrade.TradeCaptureReport.newBuilder();
        tradeBuilder.setMarketGrp(this.getMarketGrp());
        tradeBuilder.setTrdSubType(PField.TradeReportSubType.forNumber((int)this.getTrdSubType()));
        tradeBuilder.setApplType(this.getApplType());
        tradeBuilder.setRtgsFlag(this.isRtgs ? 1 : 0);
        PComponent.Instrument.Builder insBuilder = this.instrument.getBuilder();
        insBuilder.setMarketGroup(this.getMarketGrp());
        tradeBuilder.setInstrument(insBuilder.build());
        PPostTrade.TrdCapRptSides.Builder sidesBuilder = PPostTrade.TrdCapRptSides.newBuilder();
        PPostTrade.TrdCapRptSide.Builder sideBuilder = PPostTrade.TrdCapRptSide.newBuilder();
        sideBuilder.setSide(PField.Side.forNumber((int)this.getSide()));
        PPostTrade.Trader.Builder tb = PPostTrade.Trader.newBuilder();
        tb.setTraderId(this.otherTrader);
        tradeBuilder.setTrader(tb.build());
        PComponent.PartyIDs.Builder partyIdsBuilder = PComponent.PartyIDs.newBuilder();
        PComponent.PartyID.Builder idBuilder = PComponent.PartyID.newBuilder();
        idBuilder.setPartyId(this.getPartyId());
        idBuilder.setPartyRole("COUNTERPARTY");
        partyIdsBuilder.addPartyId(idBuilder.build());
        sideBuilder.setPartyIds(partyIdsBuilder.build());
        sidesBuilder.addSide(sideBuilder.build());
        tradeBuilder.setSides(sidesBuilder.build());
        tradeBuilder.setExtAccntId(this.getExtAccntId());
        tradeBuilder.setInvestorId(this.getInvestorId());
        tradeBuilder.setExtSecAccntId(this.getExtSecAccntId());
        tradeBuilder.setSubAccntId(this.getSubAccntId());
        tradeBuilder.setSubSecAccntId(this.getSubSecAccntId());
        tradeBuilder.setPortfolioId(this.getPortfolioId());
        tradeBuilder.setResourceId(this.getResourceId());
        tradeBuilder.setReference(this.getReferenceId());
        tradeBuilder.setTradeReportType(PField.TradeReportType.forNumber((int)this.getTradeReportType()));
        tradeBuilder.setTrdType(this.getTrdType());
        tradeBuilder.setTrdSubType(PField.TradeReportSubType.forNumber((int)this.getTrdSubType()));
        tradeBuilder.setLastPx(this.getPrice());
        tradeBuilder.setLastQty((double)this.getOrderQty());
        tradeBuilder.setCashOrderQty(this.getCashOrderQty());
        tradeBuilder.setConfirmId(this.getConfirmId());
        return tradeBuilder;
    }

    public int getActionId() {
        int actionId = 0;
        if ("2".equals(this.instructionPanelType)) {
            actionId = 20;
        } else if ("1".equals(this.instructionPanelType)) {
            actionId = 21;
        }
        return actionId;
    }

    public String getMarketGrp() {
        return this.marketGrp;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrp = marketGrp;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public int getSide() {
        return this.side;
    }

    public void setSide(int side) {
        this.side = side;
    }

    public int getTradeReportType() {
        return this.tradeReportType;
    }

    public void setTradeReportType(int tradeReportType) {
        this.tradeReportType = tradeReportType;
    }

    public int getTrdType() {
        return this.trdType;
    }

    public void setTrdType(int trdType) {
        this.trdType = trdType;
    }

    public int getTrdSubType() {
        return this.trdSubType;
    }

    public void setTrdSubType(int trdSubType) {
        this.trdSubType = trdSubType;
    }

    public int getShareHolderType() {
        return this.shareHolderType;
    }

    public void setShareHolderType(int shareHolderType) {
        this.shareHolderType = shareHolderType;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public long getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(long orderQty) {
        this.orderQty = orderQty;
    }

    public double getCashOrderQty() {
        return this.cashOrderQty;
    }

    public void setCashOrderQty(double cashOrderQty) {
        this.cashOrderQty = cashOrderQty;
    }

    public String getConfirmId() {
        return this.confirmId;
    }

    public void setConfirmId(String confirmId) {
        this.confirmId = confirmId;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public boolean isAgreeProtocol() {
        return this.agreeProtocol;
    }

    public void setAgreeProtocol(boolean agreeProtocol) {
        this.agreeProtocol = agreeProtocol;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public FundAccount getFundAccount() {
        return this.fundAccount;
    }

    public void setFundAccount(FundAccount fundAccount) {
        this.fundAccount = fundAccount;
    }

    public SecAccount getSecAccount() {
        return this.secAccount;
    }

    public void setSecAccount(SecAccount secAccount) {
        this.secAccount = secAccount;
    }

    public int getApplType() {
        return this.applType;
    }

    public void setApplType(int applType) {
        this.applType = applType;
    }

    public TradeCaptureReportAdvice getAdvice() {
        TradeCaptureReportAdvice advice = new TradeCaptureReportAdvice();
        advice.setAccntLevel(0);
        advice.setAppID(this.getInstrument().getApplId());
        advice.setInstructionPanelType(this.getInstructionPanelType());
        advice.setFlowAttriId(this.getFlowAttriId());
        advice.setInstructionType(32);
        advice.setMarket(this.getInstrument().getMarket().getRaw());
        advice.setOrderAvailableQuantity(this.getOrderQty());
        advice.setOrderQty(this.getOrderQty());
        advice.setPrice(this.getPrice());
        advice.setSecId(this.getInstrument().getSecId());
        advice.setSecName(this.getInstrument().getSymbol());
        advice.setSecType(this.getInstrument().getSecType());
        advice.setSide(this.getSide());
        advice.setStepAttrId(this.getStepAttrId());
        advice.setRtgsFlag(this.isRtgs ? 1 : 0);
        advice.setApplType(this.getApplType());
        AccntSecInfo accSecInfo = this.getAccSecInfo();
        advice.getAccSecInfoList().add(accSecInfo);
        advice.setTradeReportSubType(this.getTrdSubType());
        advice.setHolderFlag(this.shareHolderType);
        advice.setConfirmId(this.getConfirmId());
        advice.setPartyId(this.getPartyId());
        advice.setOtherTrader(this.otherTrader);
        return advice;
    }

    private AccntSecInfo getAccSecInfo() {
        AccntSecInfo accSecInfo = new AccntSecInfo();
        accSecInfo.setAccntId(this.getExtAccntId());
        accSecInfo.setInvestorId(this.getInvestorId());
        accSecInfo.setMarket(this.getInstrument().getMarket().getRaw());
        accSecInfo.setOrderAvailableQuantity(this.getOrderQty());
        accSecInfo.setOrderQty(this.getOrderQty());
        accSecInfo.setParentId(this.getFundAccount().getParentId());
        accSecInfo.setSecAccntId(this.getExtSecAccntId());
        return accSecInfo;
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public String getFlowAttriId() {
        return this.flowAttriId;
    }

    public void setFlowAttriId(String flowAttriId) {
        this.flowAttriId = flowAttriId;
    }

    public String getStepAttrId() {
        return this.stepAttrId;
    }

    public void setStepAttrId(String stepAttrId) {
        this.stepAttrId = stepAttrId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isRtgs() {
        return this.isRtgs;
    }

    public void setRtgs(boolean isRtgs) {
        this.isRtgs = isRtgs;
    }

    public String getOtherTrader() {
        return this.otherTrader;
    }

    public void setOtherTrader(String otherTrader) {
        this.otherTrader = otherTrader;
    }
}

