/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.http.accnt.dto.AccntSession;
import cms.tmx.http.query.marginxt.XtAccLoginStatus;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AccountStatus
extends MxChgObj {
    private static final String LOGIN_ERROR_43 = "1043";
    private StringProperty investorId = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private StringProperty loginErrorInfo = new SimpleStringProperty("");
    private String newLoginErrorInfo = "";
    private StringProperty brokerId = new SimpleStringProperty("");

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)"accnt_flag", (String)"0");
        this.setStatus(node);
    }

    public void update(Object obj) {
        if (obj instanceof PMainTenance.AccntStatus) {
            PMainTenance.AccntStatus accntStatus = (PMainTenance.AccntStatus)PMainTenance.AccntStatus.class.cast(obj);
            this.update(accntStatus);
            this.changed();
        } else if (obj instanceof AccountStatus) {
            AccountStatus account = (AccountStatus)((Object)AccountStatus.class.cast(obj));
            this.update(account);
        } else if (obj instanceof AccntSession) {
            AccntSession account = (AccntSession)AccntSession.class.cast(obj);
            this.update(account);
        } else if (obj instanceof XtAccLoginStatus) {
            XtAccLoginStatus account = (XtAccLoginStatus)XtAccLoginStatus.class.cast(obj);
            this.update(account);
        }
    }

    private void update(AccntSession accountSession) {
        this.setInvestorId(accountSession.getInvestorId());
        this.logger.info(String.valueOf(accountSession.getInvestorId()) + " | " + accountSession.getState());
        if (accountSession.getOpStatus() != null) {
            this.logger.info(accountSession.getOpStatus().getReason());
            this.getStatus().setRaw((String)AccntSession.LOGIN_STATE_MAP.get(accountSession.getState()));
        }
        this.setNewLoginErrorInfo(accountSession.getOpStatus().getReason());
    }

    private void update(PMainTenance.AccntStatus accntStatus) {
        this.setInvestorId(accntStatus.getInvestorId());
        this.getStatus().setRaw(String.valueOf(accntStatus.getStatus()));
        this.setLoginErrorInfo(accntStatus.getErrorInfo());
        this.setBrokerId(accntStatus.getBrokerId());
    }

    private void update(AccountStatus accntStatus) {
        this.setInvestorId(accntStatus.getInvestorId());
        this.setStatus(accntStatus.getStatus());
        this.setLoginErrorInfo(accntStatus.getLoginErrorInfo());
        this.setNewLoginErrorInfo(accntStatus.getNewLoginErrorInfo());
        this.setBrokerId(accntStatus.getBrokerId());
    }

    private void update(XtAccLoginStatus accStatus) {
        this.setInvestorId(accStatus.getInvestorId());
        this.logger.info(String.valueOf(accStatus.getInvestorId()) + " | " + accStatus.getStatus());
        if (accStatus.getStatus() != null && accStatus.getStatus() >= 0) {
            this.getStatus().setRaw("XT" + accStatus.getStatus());
        } else {
            this.getStatus().setRaw("0");
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.investorId.get() == null ? 0 : ((String)this.investorId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AccountStatus other = (AccountStatus)((Object)obj);
        return !(this.investorId.get() == null ? other.investorId.get() != null : !((String)this.investorId.get()).equals(other.investorId.get()));
    }

    public String toString() {
        return String.valueOf((String)this.investorId.get()) + this.status.get();
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final StringProperty loginErrorInfoProperty() {
        return this.loginErrorInfo;
    }

    public final String getLoginErrorInfo() {
        return (String)this.loginErrorInfoProperty().get();
    }

    public final void setLoginErrorInfo(String loginErrorInfo) {
        this.loginErrorInfoProperty().set((Object)loginErrorInfo);
    }

    public StringProperty brokerIdProperty() {
        return this.brokerId;
    }

    public String getBrokerId() {
        return (String)this.brokerIdProperty().get();
    }

    public void setBrokerId(String brokerId) {
        this.brokerIdProperty().set((Object)brokerId);
    }

    public String getNewLoginErrorInfo() {
        return this.newLoginErrorInfo;
    }

    public void setNewLoginErrorInfo(String newLoginErrorInfo) {
        this.newLoginErrorInfo = newLoginErrorInfo;
    }
}

