/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.entity;

import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.account.PExtAccnt;
import cms.tmx.http.accnt.Accnt;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Account
extends MxChgSelObj {
    private StringProperty id = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty pwd = new SimpleStringProperty("");
    private StringProperty openTime = new SimpleStringProperty("");
    private StringProperty closeTime = new SimpleStringProperty("");
    private StringProperty closeReason = new SimpleStringProperty("");
    private StringProperty creator = new SimpleStringProperty("");
    private StringProperty createTime = new SimpleStringProperty("");
    private StringProperty updater = new SimpleStringProperty("");
    private StringProperty updateTime = new SimpleStringProperty("");
    private StringProperty brokerId = new SimpleStringProperty("");
    private StringProperty tradePlatformId = new SimpleStringProperty("");
    private StringProperty partyId = new SimpleStringProperty("");
    private StringProperty partyName = new SimpleStringProperty("");
    private StringProperty curCode = new SimpleStringProperty("");
    private StringProperty curStr = new SimpleStringProperty("");
    private IntegerProperty carryCode = new SimpleIntegerProperty();
    private StringProperty carryYears = new SimpleStringProperty("");
    private StringProperty carryDay = new SimpleStringProperty("");
    private ObjectProperty<MxNode> status = new SimpleObjectProperty();
    private ObjectProperty<MxNode> flag = new SimpleObjectProperty();
    private ObjectProperty<MxNode> neeqFlag = new SimpleObjectProperty();
    private ObjectProperty<MxNode> otcFlag = new SimpleObjectProperty();
    private StringProperty secExchange = new SimpleStringProperty("");
    private List<String> secExc = new LinkedList<String>();
    private List<String> currency = new LinkedList<String>();
    private ObjectProperty<MxNode> nodeMarket = new SimpleObjectProperty();
    private ObjectProperty<MxNode> nodeCurrency = new SimpleObjectProperty();
    private StringProperty loginErrorInfo = new SimpleStringProperty("");
    private String newLoginErrorInfo = "";
    private String otcLoginErrorInfo = "";
    private StringProperty productId = new SimpleStringProperty("");
    private StringProperty productName = new SimpleStringProperty("");
    private boolean neeqEnable = false;
    private boolean multiCenter = false;
    private boolean otcEnable = false;
    private boolean externalOrderFlags = false;
    private boolean fileOrderManualConfirmation = true;
    private ObjectProperty<MxNode> nonTradableAsset = new SimpleObjectProperty();
    private boolean externalAsset;
    private ObjectProperty<MxNode> dataSource = new SimpleObjectProperty();
    private StringProperty externalAccnt = new SimpleStringProperty("");
    public static final String CURRENCY_TYPE = "currency_type";
    public static final String MARKET_CODE = "market_code";
    public static final String MARKET_Q = "XSHG";
    public static final String MARKET_NEEQ = "NEEQ";
    public static final String CURRENCY_TYPE_RMB = "CNY";
    public static final String CURRENCY_TYPE_USD = "USD";
    public static final String CURRENCY_TYPE_HKD = "HKD";
    public static final String STATUS = "accnt_status";
    public static final String STATUS_Q = "1";
    public static final String CARRY_TYPE = "carry_type";
    public static final String CARRY_OVER_NOT_AND_YEARS = "1";
    public static final String CARRY_OVER_SINGLE_YEARS = "2";
    public static final String CARRY_OVER_MANY_YEARS = "3";
    public static final String NON_TRADABLE_ASSETS = "non_tradable_assets";
    public static final String NON_TRADABLE_ASSETS_NO = "0";
    public static final String DATA_SOURCE = "accnt_data_source";
    public static final String DATA_SOURCE_AUTO = "1";
    public static final String DATA_SOURCE_MANUAL = "2";
    @Inject
    private MObjFactory of;
    private static MxNode nodeMar;
    private static MxNode nodeCur;
    private static MxNode nodeCar;

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.create((String)STATUS, (String)"1");
        this.setStatus(node);
        node = MxNodeFactory.create((String)"accnt_flag", (String)"1");
        this.setFlag(node);
        this.setNeeqFlag(node);
        this.setOtcFlag(node);
        nodeMar = MxNodeFactory.create((String)MARKET_CODE, (String)"");
        nodeCur = MxNodeFactory.create((String)CURRENCY_TYPE, (String)"");
        nodeCar = MxNodeFactory.create((String)CARRY_TYPE, (String)"");
        node = MxNodeFactory.create((String)NON_TRADABLE_ASSETS, (String)NON_TRADABLE_ASSETS_NO);
        this.setNonTradableAsset(node);
        node = MxNodeFactory.create((String)DATA_SOURCE);
        this.setDataSource(node);
    }

    public Account() {
        MxNode node = MxNodeFactory.create((String)NON_TRADABLE_ASSETS, (String)NON_TRADABLE_ASSETS_NO);
        this.setNonTradableAsset(node);
        node = MxNodeFactory.create((String)DATA_SOURCE);
        this.setDataSource(node);
    }

    public void update(Object obj) {
        if (obj instanceof PExtAccnt.ExtAccntDetails) {
            PExtAccnt.ExtAccntDetails accntParties = (PExtAccnt.ExtAccntDetails)PExtAccnt.ExtAccntDetails.class.cast(obj);
            this.update(accntParties);
            this.changed();
        } else if (obj instanceof Account) {
            Account account = (Account)((Object)Account.class.cast(obj));
            this.update(account);
        }
    }

    private void update(PExtAccnt.ExtAccntDetails accntParties) {
        PExtAccnt.ExtAccnt extAccnt = accntParties.getExtAccnt();
        this.setId(accntParties.getExtAccnt().getAccntId());
        this.setInvestorId(accntParties.getExtAccnt().getInvestorId());
        this.setName(accntParties.getExtAccnt().getAccntName());
        this.setPwd(accntParties.getExtAccnt().getPassword());
        this.setOpenTime(accntParties.getExtAccnt().getOpenTime());
        this.setCloseReason(accntParties.getExtAccnt().getCloseReason());
        this.getStatus().setRaw(Integer.toString(accntParties.getExtAccnt().getStatus()));
        this.setSecExc((List<String>)accntParties.getExtAccnt().getSecExchangeList());
        this.setSecExchange(this.marketParse());
        this.setNeeqEnable(accntParties.getExtAccnt().getNeeqEnable() > 0);
        this.setOtcEnable(accntParties.getExtAccnt().getOtcEnable() > 0);
        this.setFileOrderManualConfirmation(accntParties.getExtAccnt().getFileorderManualConfirmEnable() == 0);
        this.setExternalOrderFlags(accntParties.getExtAccnt().getExternalOrderFlags() == 0);
        this.setExternalAsset(extAccnt.getIsExternalAccnt());
        if (extAccnt.getNonTradableAssetsCount() > 0) {
            String nta = extAccnt.getNonTradableAssets(0);
            this.getNonTradableAsset().setRaw(nta.isEmpty() ? NON_TRADABLE_ASSETS_NO : nta);
        }
        if (extAccnt.getExternalAccnt().getDataSourceValue() != 0) {
            this.getDataSource().setRaw(String.valueOf(extAccnt.getExternalAccnt().getDataSourceValue()));
        }
        String exter = extAccnt.getExternalAccnt().getRelatedAccntId();
        String name = extAccnt.getExternalAccnt().getRelatedAccntName();
        String investor = extAccnt.getExternalAccnt().getRelatedInvestorId();
        this.setExternalAccnt(String.valueOf(exter) + " " + name + " " + investor);
        this.setCurrency((List<String>)accntParties.getExtAccnt().getCurrencyList());
        this.setCurStr(this.currencyParse());
        this.setPartyId(accntParties.getPartyId());
        this.setPartyName(accntParties.getPartyName());
        this.setCloseTime(accntParties.getExtAccnt().getCloseTime());
        this.setCreator(accntParties.getExtAccnt().getCreator());
        this.setBrokerId(accntParties.getExtAccnt().getBrokerId());
        this.setTradePlatformId(accntParties.getExtAccnt().getTradePlatformId());
        this.setCreateTime(accntParties.getExtAccnt().getCreateTime());
        this.setUpdater(accntParties.getExtAccnt().getLastUpdater());
        this.setUpdateTime(accntParties.getExtAccnt().getLastUpdateTime());
        this.setProductId(accntParties.getProductId());
        this.setProductName(accntParties.getProductName());
        int carryType = accntParties.getExtAccnt().getCarryOver().getCarryTypeValue();
        this.setCarryCode(carryType == 0 ? 1 : carryType);
        this.setCarryYears(String.valueOf((int)accntParties.getExtAccnt().getCarryOver().getCarryYears()));
        this.setCarryDay(accntParties.getExtAccnt().getCarryOver().getFirstCarryDay());
        this.setMultiCenter(accntParties.getExtAccnt().getMultiCenterEnable() > 0);
    }

    private void update(Account account) {
        this.setId(account.getId());
        this.setInvestorId(account.getInvestorId());
        this.setName(account.getName());
        this.setPwd(account.getPwd());
        this.setOpenTime(account.getOpenTime());
        this.setCloseReason(account.getCloseReason());
        this.getStatus().setRaw(account.getStatus().getRaw());
        this.setSecExc(account.getSecExc());
        this.setNeeqEnable(account.isNeeqEnable());
        this.setOtcEnable(account.isOtcEnable());
        this.setMultiCenter(account.isMultiCenter());
        this.setExternalOrderFlags(account.isExternalOrderFlags());
        this.setCurrency(account.getCurrency());
        this.setSecExchange(account.getSecExchange());
        this.getNonTradableAsset().setRaw(account.getNonTradableAsset().getRaw());
        this.setExternalAsset(account.isExternalAsset());
        this.getDataSource().setRaw(account.getDataSource().getRaw());
        this.setExternalAccnt(account.getExternalAccnt());
        this.setCurStr(this.currencyParse());
        this.setPartyId(account.getPartyId());
        this.setFlag(account.getFlag());
        this.setNeeqFlag(account.getNeeqFlag());
        this.getOtcFlag().setRaw(account.getOtcFlag().getRaw());
        this.setFileOrderManualConfirmation(account.isFileOrderManualConfirmation());
        this.setPartyName(account.getPartyName());
        this.setCloseTime(account.getCloseTime());
        this.setCreator(account.getCreator());
        this.setBrokerId(account.getBrokerId());
        this.setTradePlatformId(account.getTradePlatformId());
        this.setCreateTime(account.getCreateTime());
        this.setUpdater(account.getUpdater());
        this.setUpdateTime(account.getUpdateTime());
        this.setProductId(account.getProductId());
        this.setProductName(account.getProductName());
        if (account.getCarryCode() != 0) {
            this.setCarryCode(account.getCarryCode());
            this.setCarryYears(account.getCarryYears());
            this.setCarryDay(account.getCarryDay());
        }
    }

    public Accnt toAccnt(String accntId) {
        Accnt accnt = new Accnt();
        accnt.setAccntId(accntId);
        accnt.setPlatformId(this.getTradePlatformId());
        accnt.setExchanges(StringUtils.join((Object[])this.getSecExc().toArray(), (String)";"));
        accnt.setPartyId(this.getPartyId());
        accnt.setInvestorId(this.getInvestorId());
        accnt.setFlags(Integer.valueOf("1").intValue());
        accnt.setStatus(Integer.valueOf("1").intValue());
        accnt.setAccntName(this.getName());
        accnt.setPassword(this.getPwd());
        return accnt;
    }

    public CashAccnt toCashAccnt() {
        CashAccnt accnt = new CashAccnt();
        accnt.setAccntId(this.getId());
        String type = MarketUtils.getMarketGroup((String)this.getSecExc().get(0));
        accnt.setMarketGroup(type);
        accnt.setRefExtId(this.getExtAccntId(type));
        accnt.setBrokerId(this.getBrokerId());
        accnt.setPassword(this.getPwd());
        accnt.setFlags(Integer.valueOf("1").intValue());
        accnt.setStatus(Integer.valueOf("1").intValue());
        accnt.setInvestorId(this.getInvestorId());
        String excStr = this.getSecExc().toString();
        excStr = excStr.substring(1, excStr.length() - 1);
        accnt.setInvestableMarkets(excStr);
        accnt.setCurrencyId(this.getCurCode());
        accnt.setInvestorCashId(this.getInvestorId());
        accnt.setPlatformId(this.getTradePlatformId());
        return accnt;
    }

    /*
     * Exception decompiling
     */
    public String getExtAccntId(String marketGroup) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl54 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl54 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String currencyParse() {
        List<String> list = this.getCurrency();
        LinkedList<String> listName = new LinkedList<String>();
        for (String english : list) {
            this.getNodeCurrency().setRaw(english);
            listName.add(this.getNodeCurrency().getValue());
        }
        String strName = ((Object)listName).toString();
        return strName.substring(1, strName.length() - 1);
    }

    private String marketParse() {
        List<String> list = this.getSecExc();
        LinkedList<String> listName = new LinkedList<String>();
        for (String english : list) {
            this.getNodeMarket().setRaw(english);
            listName.add(this.getNodeMarket().getValue());
        }
        String strName = ((Object)listName).toString();
        return strName.substring(1, strName.length() - 1);
    }

    public String toString() {
        return (String)this.investorId.get();
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final String getId() {
        return (String)this.idProperty().get();
    }

    public final void setId(String id) {
        this.idProperty().set((Object)id);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty openTimeProperty() {
        return this.openTime;
    }

    public final String getOpenTime() {
        return (String)this.openTimeProperty().get();
    }

    public final void setOpenTime(String openTime) {
        this.openTimeProperty().set((Object)openTime);
    }

    public final StringProperty closeTimeProperty() {
        return this.closeTime;
    }

    public final String getCloseTime() {
        return (String)this.closeTimeProperty().get();
    }

    public final void setCloseTime(String closeTime) {
        this.closeTimeProperty().set((Object)closeTime);
    }

    public final StringProperty closeReasonProperty() {
        return this.closeReason;
    }

    public final String getCloseReason() {
        return (String)this.closeReasonProperty().get();
    }

    public final void setCloseReason(String closeReason) {
        this.closeReasonProperty().set((Object)closeReason);
    }

    public final StringProperty creatorProperty() {
        return this.creator;
    }

    public final String getCreator() {
        return (String)this.creatorProperty().get();
    }

    public final void setCreator(String creator) {
        this.creatorProperty().set((Object)creator);
    }

    public final StringProperty createTimeProperty() {
        return this.createTime;
    }

    public final String getCreateTime() {
        return (String)this.createTimeProperty().get();
    }

    public final void setCreateTime(String createTime) {
        this.createTimeProperty().set((Object)createTime);
    }

    public final StringProperty updaterProperty() {
        return this.updater;
    }

    public final String getUpdater() {
        return (String)this.updaterProperty().get();
    }

    public final void setUpdater(String updater) {
        this.updaterProperty().set((Object)updater);
    }

    public final StringProperty updateTimeProperty() {
        return this.updateTime;
    }

    public final String getUpdateTime() {
        return (String)this.updateTimeProperty().get();
    }

    public final void setUpdateTime(String updateTime) {
        this.updateTimeProperty().set((Object)updateTime);
    }

    public final StringProperty secExchangeProperty() {
        return this.secExchange;
    }

    public final String getSecExchange() {
        return (String)this.secExchangeProperty().get();
    }

    public final void setSecExchange(String secExchange) {
        this.secExchangeProperty().set((Object)secExchange);
    }

    public List<String> getSecExc() {
        return this.secExc;
    }

    public void setSecExc(List<String> secExc) {
        this.secExc = secExc;
    }

    public final StringProperty brokerIdProperty() {
        return this.brokerId;
    }

    public final String getBrokerId() {
        return (String)this.brokerIdProperty().get();
    }

    public final void setBrokerId(String brokerId) {
        this.brokerIdProperty().set((Object)brokerId);
    }

    public final StringProperty partyIdProperty() {
        return this.partyId;
    }

    public final String getPartyId() {
        return (String)this.partyIdProperty().get();
    }

    public final void setPartyId(String partyId) {
        this.partyIdProperty().set((Object)partyId);
    }

    public final StringProperty pwdProperty() {
        return this.pwd;
    }

    public final String getPwd() {
        return (String)this.pwdProperty().get();
    }

    public final void setPwd(String pwd) {
        this.pwdProperty().set((Object)pwd);
    }

    public List<String> getCurrency() {
        return this.currency;
    }

    public void setCurrency(List<String> currency) {
        this.currency = currency;
    }

    public StringProperty partyNameProperty() {
        return this.partyName;
    }

    public String getPartyName() {
        return (String)this.partyNameProperty().get();
    }

    public void setPartyName(String partyName) {
        this.partyNameProperty().set((Object)partyName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.investorId.get() == null ? 0 : ((String)this.investorId.get()).hashCode());
        result = 31 * result + (this.brokerId.get() == null ? 0 : ((String)this.brokerId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)((Object)obj);
        if (this.investorId.get() == null ? other.investorId.get() != null : !((String)this.investorId.get()).equals(other.investorId.get())) {
            return false;
        }
        return !(this.brokerId.get() == null ? other.brokerId.get() != null : !((String)this.brokerId.get()).equals(other.brokerId.get()));
    }

    public StringProperty curCodeProperty() {
        return this.curCode;
    }

    public String getCurCode() {
        return (String)this.curCodeProperty().get();
    }

    public void setCurCode(String curCode) {
        this.curCodeProperty().set((Object)curCode);
    }

    public StringProperty curStrProperty() {
        return this.curStr;
    }

    public String getCurStr() {
        return (String)this.curStrProperty().get();
    }

    public void setCurStr(String curStr) {
        this.curStrProperty().set((Object)curStr);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final ObjectProperty<MxNode> statusProperty() {
        return this.status;
    }

    public final MxNode getStatus() {
        return (MxNode)this.statusProperty().get();
    }

    public final void setStatus(MxNode status) {
        this.statusProperty().set((Object)status);
    }

    public final ObjectProperty<MxNode> flagProperty() {
        return this.flag;
    }

    public final MxNode getFlag() {
        return (MxNode)this.flagProperty().get();
    }

    public final void setFlag(MxNode flag) {
        this.flagProperty().set((Object)flag);
    }

    public final StringProperty loginErrorInfoProperty() {
        return this.loginErrorInfo;
    }

    public final String getLoginErrorInfo() {
        return (String)this.loginErrorInfoProperty().get();
    }

    public final void setLoginErrorInfo(String loginErrorInfo) {
        this.loginErrorInfoProperty().set((Object)loginErrorInfo);
    }

    public final StringProperty tradePlatformIdProperty() {
        return this.tradePlatformId;
    }

    public final String getTradePlatformId() {
        return (String)this.tradePlatformIdProperty().get();
    }

    public final void setTradePlatformId(String tradePlatformId) {
        this.tradePlatformIdProperty().set((Object)tradePlatformId);
    }

    public final ObjectProperty<MxNode> nodeMarketProperty() {
        return this.nodeMarket;
    }

    public final MxNode getNodeMarket() {
        return (MxNode)this.nodeMarketProperty().get();
    }

    public final void setNodeMarket(MxNode nodeMarket) {
        this.nodeMarketProperty().set((Object)nodeMarket);
    }

    public final ObjectProperty<MxNode> nodeCurrencyProperty() {
        return this.nodeCurrency;
    }

    public final MxNode getNodeCurrency() {
        return (MxNode)this.nodeCurrencyProperty().get();
    }

    public final void setNodeCurrency(MxNode nodeCurrency) {
        this.nodeCurrencyProperty().set((Object)nodeCurrency);
    }

    public final StringProperty productIdProperty() {
        return this.productId;
    }

    public final String getProductId() {
        return (String)this.productIdProperty().get();
    }

    public final void setProductId(String productId) {
        this.productIdProperty().set((Object)productId);
    }

    public final StringProperty productNameProperty() {
        return this.productName;
    }

    public final String getProductName() {
        return (String)this.productNameProperty().get();
    }

    public final void setProductName(String productName) {
        this.productNameProperty().set((Object)productName);
    }

    public static boolean isNewFrame(Account account) {
        return account != null && ("99999-02-01".equals(account.getTradePlatformId()) || "99999-04-01".equals(account.getTradePlatformId()) || "55555-04-01".equals(account.getTradePlatformId()) || "66668-01-01".equals(account.getTradePlatformId()) || "99988-01-01".equals(account.getTradePlatformId()) || "99988-01-02".equals(account.getTradePlatformId()) || "99999-03-01".equals(account.getTradePlatformId()) || "99999-02-02".equals(account.getTradePlatformId()) || "99999-02-03".equals(account.getTradePlatformId()));
    }

    public static boolean isOtc(Account accnt) {
        return "99999-04-01".equals(accnt.getTradePlatformId()) || "55555-04-01".equals(accnt.getTradePlatformId());
    }

    public final IntegerProperty carryCodeProperty() {
        return this.carryCode;
    }

    public final int getCarryCode() {
        return this.carryCodeProperty().get();
    }

    public final void setCarryCode(int carryCode) {
        this.carryCodeProperty().set(carryCode);
    }

    public final StringProperty carryDayProperty() {
        return this.carryDay;
    }

    public final String getCarryDay() {
        return (String)this.carryDayProperty().get();
    }

    public final void setCarryDay(String carryDay) {
        this.carryDayProperty().set((Object)carryDay);
    }

    public final StringProperty carryYearsProperty() {
        return this.carryYears;
    }

    public final String getCarryYears() {
        return (String)this.carryYearsProperty().get();
    }

    public final void setCarryYears(String carryYears) {
        this.carryYearsProperty().set((Object)carryYears);
    }

    public boolean isNeeqEnable() {
        return this.neeqEnable;
    }

    public void setNeeqEnable(boolean neeqEnable) {
        this.neeqEnable = neeqEnable;
    }

    public ObjectProperty<MxNode> neeqFlagProperty() {
        return this.neeqFlag;
    }

    public MxNode getNeeqFlag() {
        return (MxNode)this.neeqFlagProperty().get();
    }

    public void setNeeqFlag(MxNode neeqFlag) {
        this.neeqFlagProperty().set((Object)neeqFlag);
    }

    public boolean isExternalAsset() {
        return this.externalAsset;
    }

    public void setExternalAsset(boolean externalAsset) {
        this.externalAsset = externalAsset;
    }

    public final ObjectProperty<MxNode> dataSourceProperty() {
        return this.dataSource;
    }

    public final MxNode getDataSource() {
        return (MxNode)this.dataSourceProperty().get();
    }

    public final void setDataSource(MxNode dataSource) {
        this.dataSourceProperty().set((Object)dataSource);
    }

    public final StringProperty externalAccntProperty() {
        return this.externalAccnt;
    }

    public final String getExternalAccnt() {
        return (String)this.externalAccntProperty().get();
    }

    public final void setExternalAccnt(String externalAccnt) {
        this.externalAccntProperty().set((Object)externalAccnt);
    }

    public final ObjectProperty<MxNode> nonTradableAssetProperty() {
        return this.nonTradableAsset;
    }

    public final MxNode getNonTradableAsset() {
        return (MxNode)this.nonTradableAssetProperty().get();
    }

    public final void setNonTradableAsset(MxNode nonTradableAsset) {
        this.nonTradableAssetProperty().set((Object)nonTradableAsset);
    }

    public boolean isOtcEnable() {
        return this.otcEnable;
    }

    public void setOtcEnable(boolean otcEnable) {
        this.otcEnable = otcEnable;
    }

    public ObjectProperty<MxNode> otcFlagProperty() {
        return this.otcFlag;
    }

    public MxNode getOtcFlag() {
        return (MxNode)this.otcFlagProperty().get();
    }

    public void setOtcFlag(MxNode otcFlag) {
        this.otcFlagProperty().set((Object)otcFlag);
    }

    public boolean isExternalOrderFlags() {
        return this.externalOrderFlags;
    }

    public void setExternalOrderFlags(boolean externalOrderFlags) {
        this.externalOrderFlags = externalOrderFlags;
    }

    public String getNewLoginErrorInfo() {
        return this.newLoginErrorInfo;
    }

    public String getOtcLoginErrorInfo() {
        return this.otcLoginErrorInfo;
    }

    public void setNewLoginErrorInfo(String newLoginErrorInfo) {
        this.newLoginErrorInfo = newLoginErrorInfo;
    }

    public void setOtcLoginErrorInfo(String otcLoginErrorInfo) {
        this.otcLoginErrorInfo = otcLoginErrorInfo;
    }

    public boolean isFileOrderManualConfirmation() {
        return this.fileOrderManualConfirmation;
    }

    public void setFileOrderManualConfirmation(boolean fileOrderManualConfirmation) {
        this.fileOrderManualConfirmation = fileOrderManualConfirmation;
    }

    public boolean isMultiCenter() {
        return this.multiCenter;
    }

    public void setMultiCenter(boolean multiCenter) {
        this.multiCenter = multiCenter;
    }

    public StringProperty showNameProperty() {
        if (this.getInvestorId().isEmpty()) {
            return new SimpleStringProperty(this.getName());
        }
        return new SimpleStringProperty(String.valueOf(this.getInvestorId()) + "-" + this.getName());
    }
}

