/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.rights.imp;

import cms.tmx.entity.FuncModule;
import cms.tmx.rights.IUiRightService;
import cms.tmx.rights.imp.RightServiceImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.scene.control.Control;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

@Creatable
@Singleton
public class UiRightServiceImpl
implements IUiRightService {
    @Inject
    private RightServiceImpl rsi;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    private List<FuncModule> funcList = new LinkedList<FuncModule>();
    private Set<String> rightList = new HashSet<String>();
    private static final String MARK = "_";
    private MPartStack stack;

    @PostConstruct
    private void init() {
        this.rsi.downProperty().addListener((observ, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.funcList = this.rsi.getUserFuncList();
                this.initRightList();
            }
        });
    }

    @Override
    public boolean registerCheck(Control control, String ... mxControl) {
        List<String> conts = Arrays.asList(mxControl);
        for (String string : conts) {
            if (!this.rightList.contains(string)) continue;
            return true;
        }
        control.disableProperty().unbind();
        control.visibleProperty().unbind();
        control.setDisable(true);
        control.setVisible(false);
        return false;
    }

    @Override
    public boolean registerCheck(Pane pane, String ... mxControl) {
        List<String> conts = Arrays.asList(mxControl);
        for (String string : conts) {
            if (!this.rightList.contains(string)) continue;
            return true;
        }
        pane.disableProperty().unbind();
        pane.visibleProperty().unbind();
        pane.setDisable(true);
        pane.setVisible(false);
        pane.setMaxWidth(0.0);
        pane.setMinWidth(0.0);
        pane.setPrefWidth(0.0);
        return false;
    }

    @Override
    public boolean registerCheckNotHide(Control control, String mxControl) {
        if (this.rightList.contains(mxControl)) {
            return true;
        }
        control.disableProperty().unbind();
        control.setDisable(true);
        return false;
    }

    @Override
    public void registerCheckPart(MPart part) {
        String partId;
        List list = this.ms.findElements((MUIElement)this.app, part.getParent().getElementId(), MPartStack.class, null);
        if (list.isEmpty() || list.size() == 1) {
            this.specialCheck(part);
            return;
        }
        this.stack = (MPartStack)list.get(1);
        String string = partId = !part.getElementId().contains(":") ? part.getElementId() : part.getElementId().substring(0, part.getElementId().indexOf(58));
        if (this.rightList.contains(partId)) {
            if (!this.stack.isToBeRendered()) {
                this.stack.setToBeRendered(true);
            }
            this.stack.setVisible(true);
            part.setVisible(true);
            return;
        }
        part.setVisible(false);
        int number = 0;
        Iterator it = this.stack.getChildren().iterator();
        while (it.hasNext()) {
            MStackElement msEle = (MStackElement)it.next();
            if (!(msEle instanceof MPart)) continue;
            MPart mPart = (MPart)MPart.class.cast(msEle);
            if (mPart.isVisible()) {
                ++number;
                continue;
            }
            if (!part.getElementId().equals(mPart.getElementId())) continue;
            it.remove();
        }
        this.stack.setVisible(number != 0);
    }

    private void specialCheck(MPart part) {
        if (part instanceof MCompositePart) {
            MCompositePart compositePart = (MCompositePart)MCompositePart.class.cast(part);
            int num = 0;
            List lMParts = this.ms.findElements((MApplicationElement)compositePart, MPart.class, 4, appElement -> true);
            int i = 0;
            while (i < lMParts.size()) {
                if (this.rightList.contains(((MPart)lMParts.get(i)).getElementId()) && !compositePart.getElementId().equals(((MPart)lMParts.get(i)).getElementId())) {
                    ((MPart)lMParts.get(i)).setVisible(true);
                    ++num;
                }
                ++i;
            }
            compositePart.setVisible(num != 0);
        }
    }

    @Override
    public boolean needCheck(String id) {
        return !"cms.tmx.finance.part.homepage".equals(id) && !"cms.tmx.manage.part.main.function".equals(id) && !"cms.tmx.manage.part.MenuTree".equals(id) && !"cms.tmx.manage.part.login".equals(id);
    }

    @Override
    public boolean registerCheck(String ... mxControl) {
        List<String> conts = Arrays.asList(mxControl);
        for (String string : conts) {
            if (!this.rightList.contains(string)) continue;
            return true;
        }
        return false;
    }

    private void initRightList() {
        this.funcList.stream().filter(item -> item.getControlId() != null && !item.getControlId().getRaw().isEmpty()).forEach(item -> {
            if (item.getControlId().getRaw().contains(MARK)) {
                this.rightList.add(item.getControlId().getRaw().substring(0, item.getControlId().getRaw().indexOf(MARK)));
                this.rightList.add(item.getControlId().getRaw());
            } else {
                this.rightList.add(item.getControlId().getRaw());
            }
        });
    }

    @Override
    public boolean registerCheckTabPane(TabPane tabPane, Tab tab, String ... mxControl) {
        if (!this.registerCheck(mxControl)) {
            tabPane.getTabs().remove((Object)tab);
            return false;
        }
        return true;
    }

    @Override
    public boolean registerCheckTabContent(Tab tab, String ... mxControl) {
        boolean registerCheck = this.registerCheck(mxControl);
        tab.getContent().setDisable(!this.registerCheck(mxControl));
        return registerCheck;
    }

    @Override
    public void registerCheckAll(Control control, String ... mxControl) {
        List<String> conts = Arrays.asList(mxControl);
        boolean flag = false;
        for (String string : conts) {
            if (this.rightList.contains(string)) continue;
            flag = true;
        }
        if (flag) {
            control.disableProperty().unbind();
            control.visibleProperty().unbind();
            control.setDisable(true);
            control.setVisible(false);
        }
    }
}

