/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.rights.imp;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IFuncApi;
import cms.tmx.api.mng.IPartyApi;
import cms.tmx.api.mng.IPostApi;
import cms.tmx.api.mng.IRoleApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.SearchSuggest;
import cms.tmx.entity.factory.FuncFactory;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.javafx.utils.SceneService;
import cms.tmx.rights.IRightService;
import cms.tmx.utils.FileUtils;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class RightServiceImpl
implements IRightService {
    @Inject
    private IFuncApi funcApi;
    @Inject
    private IRoleApi roleApi;
    @Inject
    private IPostApi postApi;
    @Inject
    private IPartyApi partyApi;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private FuncFactory ff;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    private List<String> idList = new LinkedList<String>();
    private Map<String, String> mapIdentify = new HashMap<String, String>();
    private List<FuncModule> userFuncList = new LinkedList<FuncModule>();
    private Map<String, Map<String, String>> mapParse = new HashMap<String, Map<String, String>>();
    private static final Logger logger = LogManager.getLogger(RightServiceImpl.class);
    private static final int SIZE = 2;
    private BooleanProperty down = new SimpleBooleanProperty(false);
    private Map<String, FuncModule> map = new HashMap<String, FuncModule>();
    private Map<String, String> identifyToMoudelIdMap = new HashMap<String, String>();
    private List<String> collectIds = new LinkedList<String>();
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    Gson gson = new Gson();
    public static final String ROOT_ID = "F00000";
    private static final String NOT_FOUND_PART_ID = "cms.tmx.manage.part.NotFound";
    @Inject
    private EPartService ps;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    @Inject
    private SceneService service;
    private List<MStackElement> children;

    @PostConstruct
    private void init() {
        this.es.subscribe("query.menus", event -> this.initRight(event));
        this.es.subscribe("show_diskless", event -> this.showDiskLess(event));
    }

    private void initRight(MEvent event) {
        try {
            logger.info("start query all menus");
            this.userFuncList = this.getEnableFuncListByUserPost(this.baseApi.getPostId());
            logger.info("end query all menus");
            this.userFuncList.forEach(item -> {
                this.map.put(item.getId(), (FuncModule)item);
                if (item.getModuleType().getValue() == null && item.getControlId() == null) {
                    this.identifyToMoudelIdMap.put(item.getIdentifier().getRaw(), item.getId());
                }
            });
            List list = FileUtils.loadFile((Object)this, (String)"menu_id.properties");
            this.parseMsg(list);
            String buildUserFuncListString = this.buildUserFuncListString();
            this.eCore.put((Object)"user_func_list", (Object)buildUserFuncListString);
            this.down.setValue(Boolean.valueOf(true));
            this.es.subscribe("user.collect.menus", e -> this.userCollectMenus(e));
            this.es.subscribe("user.uncollect.menus", e -> this.userUnCollectMenus(e));
            this.es.subscribe("check.menus.is.collect", e -> this.checkMenusIsCollect(e));
        }
        catch (MException e2) {
            event.setDesc("\u67e5\u8be2\u529f\u80fd\u6743\u9650\u83dc\u5355\u5931\u8d25");
            event.setCode(999993);
            logger.error((Object)e2, (Throwable)e2);
        }
        catch (Exception e3) {
            event.setDesc("\u521d\u59cb\u5316\u5931\u8d25");
            event.setCode(999993);
            logger.error((Object)e3, (Throwable)e3);
        }
    }

    private synchronized void checkMenusIsCollect(MEvent event) {
        String partId = event.getStr("menuId");
        String moduleId = this.getModuleIdByPartId(partId);
        if (this.collectIds.contains(moduleId)) {
            event.setOK();
        } else {
            event.setCode(-1);
        }
    }

    private synchronized void userCollectMenus(MEvent event) {
        try {
            String partId = event.getStr("menuId");
            String moduleId = this.getModuleIdByPartId(partId);
            if (moduleId.isEmpty()) {
                event.setCode(-1);
                return;
            }
            this.postApi.userCollectMenus(moduleId);
            this.collectIds.add(moduleId);
            event.put((Object)"identify", (Object)this.getPartIdentify(partId));
            this.es.sendEvent("ADD_COLLECT_PANE", event);
            event.setOK();
        }
        catch (MException e) {
            event.setCode(-1);
            logger.error((Object)e, (Throwable)e);
        }
    }

    private synchronized void userUnCollectMenus(MEvent event) {
        try {
            String partId = event.getStr("menuId");
            String moduleId = this.getModuleIdByPartId(partId);
            if (moduleId.isEmpty()) {
                event.setCode(-1);
                return;
            }
            this.postApi.userUnCollectMenus(moduleId);
            this.collectIds.remove(moduleId);
            this.es.sendEvent("DEL_COLLECT_PANE", event);
            event.setOK();
        }
        catch (MException e) {
            event.setCode(-1);
            logger.error((Object)e, (Throwable)e);
        }
    }

    private String buildUserFuncListString() {
        LinkedList<SearchSuggest> linkedList = new LinkedList<SearchSuggest>();
        for (FuncModule func : this.userFuncList) {
            if (ROOT_ID.equals(func.getParentId()) || ROOT_ID.equals(func.getId())) continue;
            SearchSuggest suggest = new SearchSuggest();
            suggest.setFunc(true);
            suggest.setName(func.getName());
            if (func.getControlId() == null) {
                suggest.setParentName("");
                suggest.setControlId("");
            } else {
                suggest.setParentName(this.map.get(func.getParentId()).getName());
                String cId = func.getControlId().getRaw();
                if (cId.startsWith("cms")) {
                    if (cId.contains("_")) {
                        suggest.setControlId(cId.substring(0, cId.indexOf("_")));
                    } else {
                        suggest.setControlId(cId);
                    }
                } else {
                    suggest.setControlId("");
                }
            }
            if (this.mapParse.get(func.getIdentifier().getRaw()) != null) {
                suggest.setPartId(this.mapParse.get(func.getIdentifier().getRaw()).get("id"));
                suggest.setType(this.mapParse.get(func.getIdentifier().getRaw()).get("type"));
            } else {
                logger.error("\u5947\u7279\u7684func" + func);
            }
            linkedList.add(suggest);
        }
        return this.gson.toJson(linkedList);
    }

    private List<FuncModule> getFuncListByFuncIdList(List<String> list) throws MException {
        LinkedList<FuncModule> userFuncs = new LinkedList<FuncModule>();
        this.funcApi.getFuncs(PRbac.GetFuncModulesReq.Option.LIST, list).forEach(item -> {
            FuncModule func = this.ff.create();
            if (!item.getIdentifier().isEmpty() && !item.getControlId().isEmpty()) {
                MxNode node = this.ff.getNode(item.getIdentifier());
                if (node == null) {
                    node = MxNodeFactory.create((String)item.getIdentifier(), (String)"");
                    this.ff.addNode(item.getIdentifier(), node);
                }
                if (node != null) {
                    func.setControlId(node.clone());
                    func.getControlId().setRaw(item.getControlId());
                }
            }
            func.update(item);
            userFuncs.add(func);
        });
        return userFuncs;
    }

    @Override
    public List<FuncModule> getFuncListByUserPost(String postId) throws MException {
        LinkedList<String> allFuncId = new LinkedList();
        List roleListByPostId = this.roleApi.getRoleListByPostId(postId);
        for (PRbac.Role role : roleListByPostId) {
            if (!this.partyApi.checkParty(role.getPartyId())) continue;
            allFuncId.addAll(this.funcApi.getFuncByRole(role.getRoleId()));
        }
        allFuncId = allFuncId.stream().distinct().collect(Collectors.toList());
        return this.getFuncListByFuncIdList(allFuncId);
    }

    @Override
    public List<FuncModule> getEnableFuncListByUserPost(String postId) throws MException {
        List<FuncModule> allFunc = this.getFuncListByUserPost(postId);
        LinkedList<FuncModule> userFuncs = new LinkedList<FuncModule>();
        allFunc.stream().filter(item -> "1".equals(item.getStatus().getRaw())).forEach(item -> userFuncs.add((FuncModule)item));
        return userFuncs;
    }

    @Override
    public MEvent getPartConf(String identify) {
        if (identify == null || identify.isEmpty()) {
            return null;
        }
        MEvent event = new MEvent();
        for (FuncModule func : this.userFuncList) {
            if (!identify.equals(func.getIdentifier().getRaw()) || this.mapParse.get(identify) == null) continue;
            event.put((Object)"id", (Object)this.mapParse.get(identify).get("id"));
            event.put((Object)"type", (Object)this.mapParse.get(identify).get("type"));
            return event;
        }
        event.put((Object)"id", (Object)NOT_FOUND_PART_ID);
        event.put((Object)"per", (Object)("cms.tmx.per.init." + this.baseApi.getUserId()));
        return event;
    }

    @Override
    public List<String> getPartIdList() {
        return this.idList;
    }

    @Override
    public String getPartIdentify(String partId) {
        return this.mapIdentify.get(partId);
    }

    @Override
    public List<FuncModule> getUserFuncList() {
        return this.userFuncList;
    }

    private void parseMsg(List<String> list) {
        try {
            for (String line : list) {
                String raw = line.trim();
                String[] values = raw.split(",");
                if (values.length < 2) continue;
                String fucntion = values[0];
                HashMap<String, String> map = new HashMap<String, String>(500);
                int i = 1;
                while (i < values.length) {
                    String value = values[i].trim();
                    String[] pair = value.split(":");
                    if (pair.length >= 2) {
                        if ("id".equals(pair[0])) {
                            this.idList.add(pair[1]);
                            this.mapIdentify.put(pair[1], fucntion);
                        }
                        map.put(pair[0], pair[1]);
                    }
                    ++i;
                }
                this.mapParse.put(fucntion, map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public final BooleanProperty downProperty() {
        return this.down;
    }

    public final boolean isDown() {
        return this.downProperty().get();
    }

    public final void setDown(boolean down) {
        this.downProperty().set(down);
    }

    private void showDiskLess(MEvent e) {
        MPart part = this.ps.findPart("cms.tmx.diskless.part.disklessModelPart");
        if (part == null) {
            return;
        }
        String identify = this.getPartIdentify("cms.tmx.diskless.part.disklessModelPart");
        if ((this.getPartConf(identify) == null || NOT_FOUND_PART_ID.equals(this.getPartConf(identify).getStr("id"))) && this.idList.contains("cms.tmx.diskless.part.disklessModelPart")) {
            return;
        }
        Stage stage = this.of.getMainStage();
        MEvent event = new MEvent();
        event.put((Object)"close_part", (Object)false);
        if (!stage.isFullScreen()) {
            event.put((Object)"close_part", (Object)true);
            if (!part.isToBeRendered()) {
                this.refreshStackChildren(this.ms, this.app);
                this.swap(this.children, this.children.indexOf(part));
            }
            if (part != null) {
                part.setVisible(true);
                part.setToBeRendered(true);
                this.ps.showPart(part, EPartService.PartState.ACTIVATE);
            }
        }
        if (!stage.isFullScreen()) {
            stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            stage.setFullScreenExitHint("\u6309Esc\u53ef\u9000\u51fa\u5168\u5c4f\u6a21\u5f0f");
            stage.setFullScreen(!stage.isFullScreen());
            this.es.sendEvent("close_menu", event);
            this.service.disableCursor(stage);
            this.service.hideTopBottom(stage);
        }
    }

    private void refreshStackChildren(EModelService ms, MApplication app) {
        List findElements = ms.findElements((MUIElement)app, "cms.tmx.app.ps.right", MPartStack.class, null);
        if (findElements.isEmpty() || !(findElements.get(1) instanceof PartStackImpl)) {
            return;
        }
        this.children = ((PartStackImpl)PartStackImpl.class.cast(findElements.get(1))).getChildren();
    }

    public <T> void swap(List<T> list, int oldPosition) {
        T tempElement = list.get(oldPosition);
        list.remove(oldPosition);
        list.add(tempElement);
    }

    @Override
    public boolean hasRight(String partId) {
        String identify = this.getPartIdentify("cms.tmx.diskless.part.disklessModelPart");
        return this.getPartConf(identify) != null && !NOT_FOUND_PART_ID.equals(this.getPartConf(identify).getStr("id")) || !this.idList.contains("cms.tmx.diskless.part.disklessModelPart");
    }

    @Override
    public List<FuncModule> getEnableUserCollectFuncListByUserPost() throws MException {
        List<FuncModule> funcListByFuncIdList = this.getFuncListByFuncIdList(this.postApi.getUserCollectionMenus());
        LinkedList<FuncModule> userFuncs = new LinkedList<FuncModule>();
        funcListByFuncIdList.stream().filter(item -> "1".equals(item.getStatus().getRaw())).forEach(item -> userFuncs.add((FuncModule)item));
        return userFuncs;
    }

    @Override
    public List<String> getUserCollectMenus() {
        return this.collectIds;
    }

    @Override
    public String getModuleIdByIdentify(String identify) {
        String moduleId = this.identifyToMoudelIdMap.get(identify);
        if (moduleId == null) {
            return "";
        }
        return moduleId;
    }

    @Override
    public String getModuleIdByPartId(String partId) {
        String partIdentify = this.getPartIdentify(partId);
        if (partIdentify == null) {
            return "";
        }
        String moduleId = this.getModuleIdByIdentify(partIdentify);
        if (moduleId == null) {
            return "";
        }
        return moduleId;
    }
}

