/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.rights;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MAddon;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.rights.imp.RightServiceImpl;
import cms.tmx.rights.imp.UiRightServiceImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.CompositePartImpl;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CheckRightAddon
extends MAddon {
    @Inject
    private MEventService es;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    @Inject
    private RightServiceImpl rsi;
    @Inject
    private UiRightServiceImpl ursi;
    @Inject
    private IBaseApi iba;
    @Inject
    private MObjFactory of;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private static final String POINT = ".";
    private static final String NOT_FOUND_PART_ID = "cms.tmx.manage.part.NotFound";
    private static final Logger logger = LogManager.getLogger(CheckRightAddon.class);
    Map<String, MUIElement> parentIdMap = new HashMap<String, MUIElement>(1500);
    Map<String, List<String>> parentToChildrenIdMap = new HashMap<String, List<String>>(1000);
    List<String> nowIds = new LinkedList<String>();

    @PostConstruct
    private void init() {
        this.es.subscribe("ui.switch", event -> this.onSwitch(event));
        this.es.subscribe("check.rights", event -> this.checkRight(event));
        this.es.subscribe("on.exit", event -> this.savePer(event));
        this.initLoginWindow();
        super.loadDone();
    }

    private void initLoginWindow() {
        boolean isPro;
        MWindow loginPro = (MWindow)MWindow.class.cast(this.ms.find("cms.tmx.twin.login.pro", (MUIElement)this.app));
        MWindow login = (MWindow)MWindow.class.cast(this.ms.find("cms.tmx.twin.login", (MUIElement)this.app));
        boolean bl = isPro = this.eCore.getInt("client.type") == 1;
        if (loginPro != null) {
            loginPro.setVisible(isPro);
            loginPro.setToBeRendered(isPro);
        }
        if (login != null) {
            login.setVisible(!isPro);
            login.setToBeRendered(!isPro);
        }
    }

    private void savePer(MEvent event) {
        try {
            Stage stage = this.of.getMainStage();
            MProps mProps = this.initProp();
            mProps.setValue("isFullScreen", (Object)stage.isFullScreen());
            MEvent mEvent = new MEvent();
            mEvent.put((Object)"close_part", (Object)false);
            stage.setFullScreen(false);
            this.es.sendEvent("close_menu", mEvent);
            logger.info("=====CheckRightAddon exit start ==========");
            this.of.getMainStage();
            LinkedList<MUIElement> removeList = new LinkedList<MUIElement>();
            for (MUIElement element : this.app.getSnippets()) {
                if (!("cms.tmx.per.init." + this.iba.getUserId() + POINT + this.iba.getPostId()).equals(element.getElementId())) continue;
                removeList.add(element);
            }
            this.app.getSnippets().removeAll(removeList);
            MPerspective inactive = (MPerspective)MPerspective.class.cast(this.ms.find("cms.tmx.per.init." + this.iba.getUserId() + POINT + this.iba.getPostId(), (MUIElement)this.app));
            this.ms.cloneElement((MUIElement)inactive, (MSnippetContainer)this.app);
            MPerspectiveStack stack = (MPerspectiveStack)this.ms.findElements((MUIElement)this.app, "cms.tmx.perstack.main", MPerspectiveStack.class, null).get(0);
            stack.getChildren().removeAll(stack.getChildren().stream().filter(item -> item.getElementId().contains("U")).collect(Collectors.toList()));
            stack.setSelectedElement(null);
            logger.info("=====CheckRightAddon exit end ==========");
        }
        catch (Exception e) {
            logger.error("CheckRightAddon exit failed", (Throwable)e);
        }
    }

    private MProps initProp() throws IOException {
        MProps mProps = new MProps();
        Path dataPath = Paths.get(String.valueOf(this.pathBase) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + ".properties");
        File file = dataPath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            new File(String.valueOf(this.pathBase) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + ".properties").createNewFile();
        }
        mProps.load(file);
        return mProps;
    }

    private void onSwitch(MEvent event) {
        List findElements;
        this.backupCopyDefatult(this.ms, this.app);
        String userId = event.getStr("user_id");
        MPerspectiveStack stack = (MPerspectiveStack)this.ms.findElements((MUIElement)this.app, "cms.tmx.perstack.main", MPerspectiveStack.class, null).get(0);
        stack.setSelectedElement(null);
        MPerspective initPer = this.ms.findSnippet((MSnippetContainer)this.app, "cms.tmx.per.init." + userId + POINT + this.iba.getPostId()) != null ? (MPerspective)this.ms.findSnippet((MSnippetContainer)this.app, "cms.tmx.per.init." + userId + POINT + this.iba.getPostId()) : (MPerspective)this.ms.findElements((MUIElement)this.app, "cms.tmx.per.init", MPerspective.class, null).get(0);
        if (initPer != null) {
            MPerspective initPerspective = (MPerspective)this.ms.cloneElement((MUIElement)initPer, (MSnippetContainer)this.app);
            initPerspective.setElementId("cms.tmx.per.init." + userId + POINT + this.iba.getPostId());
            stack.getChildren().add(1, initPerspective);
            stack.setSelectedElement((MUIElement)initPerspective);
            initPerspective.setToBeRendered(true);
        }
        if ((findElements = this.ms.findElements((MUIElement)this.app, "cms.tmx.app.ps.right", MPartStack.class, null)).size() >= 2) {
            List now = this.ms.findElements((MApplicationElement)this.app, MPart.class, 2, appElement -> true).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MPart>(Comparator.comparing(MApplicationElement::getElementId))), ArrayList::new));
            List all = this.ms.findElements((MApplicationElement)this.app, MPart.class, 4, appElement -> true).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MPart>(Comparator.comparing(MApplicationElement::getElementId))), ArrayList::new));
            for (MPart nowPart : now) {
                this.parentIdMap.put(nowPart.getParent().getElementId(), (MUIElement)nowPart.getParent());
                this.parentIdMap.put(nowPart.getElementId(), (MUIElement)nowPart);
                this.parentToChildrenIdMap.put(nowPart.getParent().getElementId(), nowPart.getParent().getChildren().stream().map(MApplicationElement::getElementId).collect(Collectors.toList()));
                if (nowPart instanceof PartStackImpl) {
                    this.parentToChildrenIdMap.put(nowPart.getElementId(), ((PartStackImpl)PartStackImpl.class.cast(nowPart)).getChildren().stream().map(MApplicationElement::getElementId).collect(Collectors.toList()));
                } else if (nowPart instanceof CompositePartImpl) {
                    this.parentToChildrenIdMap.put(nowPart.getElementId(), ((CompositePartImpl)CompositePartImpl.class.cast(nowPart)).getChildren().stream().map(MApplicationElement::getElementId).collect(Collectors.toList()));
                }
                this.nowIds.add(nowPart.getElementId());
            }
            for (MPart mPart : all) {
                if (this.nowIds.contains(mPart.getElementId())) continue;
                if (this.parentToChildrenIdMap.get(mPart.getParent().getElementId()) == null) {
                    MPart addPart = mPart;
                    MElementContainer parent = mPart.getParent();
                    do {
                        addPart = parent;
                    } while (this.parentToChildrenIdMap.get((parent = parent.getParent()).getElementId()) == null);
                    MUIElement muiElement = this.parentIdMap.get(parent.getElementId());
                    if (muiElement instanceof PartStackImpl) {
                        ((PartStackImpl)PartStackImpl.class.cast(muiElement)).getChildren().add((MStackElement)MStackElement.class.cast(addPart));
                        continue;
                    }
                    if (!(muiElement instanceof CompositePartImpl)) continue;
                    ((CompositePartImpl)CompositePartImpl.class.cast(muiElement)).getChildren().add((MPartSashContainerElement)MPartSashContainerElement.class.cast(addPart));
                    continue;
                }
                if (this.parentToChildrenIdMap.get(mPart.getParent().getElementId()).contains(mPart.getElementId())) continue;
                MUIElement muiElement = this.parentIdMap.get(mPart.getParent().getElementId());
                if (muiElement instanceof PartStackImpl) {
                    if (mPart.getElementId().contains("cms.tmx.stock.cp.hk.trade")) continue;
                    ((PartStackImpl)PartStackImpl.class.cast(muiElement)).getChildren().add(mPart);
                    continue;
                }
                if (!(muiElement instanceof CompositePartImpl)) continue;
                ((CompositePartImpl)CompositePartImpl.class.cast(muiElement)).getChildren().add(mPart);
            }
        }
    }

    private void checkRight(MEvent event) {
        try {
            List<String> partIdList = this.rsi.getPartIdList();
            MProps mprop = this.initProp();
            List mParts = this.ms.findElements((MApplicationElement)this.app, MPart.class, 2, appElement -> true);
            for (MPart mPart : mParts) {
                String identify;
                String partId = mPart.getElementId();
                if (partId.isEmpty() || partId.contains("&_&")) continue;
                if (partId.contains(":")) {
                    partId = partId.substring(0, partId.indexOf(58));
                }
                if ("cms.tmx.diskless.part.disklessModelPart".equals(mPart.getElementId()) && !mPart.isToBeRendered()) {
                    mprop.setValue("isFullScreen", (Object)false);
                }
                if ((this.rsi.getPartConf(identify = this.rsi.getPartIdentify(partId)) == null || NOT_FOUND_PART_ID.equals(this.rsi.getPartConf(identify).getStr("id"))) && mPart.isToBeRendered() && partIdList.contains(partId)) {
                    mPart.setToBeRendered(false);
                    if ("cms.tmx.diskless.part.disklessModelPart".equals(mPart.getElementId())) {
                        mprop.setValue("isFullScreen", (Object)false);
                    }
                    if (mPart.getParent().getSelectedElement() == null || !mPart.getElementId().equals(mPart.getParent().getSelectedElement().getElementId())) continue;
                    mPart.getParent().setSelectedElement(null);
                    continue;
                }
                if (!this.ursi.needCheck(partId) || partIdList.contains(partId)) continue;
                this.ursi.registerCheckPart(mPart);
            }
            this.backupCopyUser(this.ms, this.app);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void backupCopyDefatult(EModelService ms, MApplication app) {
        List listPerStack = ms.findElements((MUIElement)app, "cms.tmx.perstack.main", MPerspectiveStack.class, null);
        MPerspectiveStack perStack = null;
        if (!listPerStack.isEmpty()) {
            perStack = (MPerspectiveStack)listPerStack.get(0);
        }
        if (perStack != null) {
            for (MPerspective per : perStack.getChildren()) {
                if (per == null || per.getElementId().contains("U")) continue;
                ms.cloneElement((MUIElement)per, (MSnippetContainer)app);
            }
        }
    }

    private void backupCopyUser(EModelService ms, MApplication app) {
        List listPerStack = ms.findElements((MUIElement)app, "cms.tmx.perstack.main", MPerspectiveStack.class, null);
        MPerspectiveStack perStack = null;
        if (!listPerStack.isEmpty()) {
            perStack = (MPerspectiveStack)listPerStack.get(0);
        }
        if (perStack != null) {
            for (MPerspective per : perStack.getChildren()) {
                if (per == null || !per.getElementId().contains("U")) continue;
                ms.cloneElement((MUIElement)per, (MSnippetContainer)app);
            }
        }
    }
}

