/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.utils.DirChooserUtil;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.javafx.LoggerInterface;
import cms.tmx.jxb.WebBrowserService;
import cms.tmx.metrics.topic.handler.impl.GetCreditTokenHandler;
import com.google.gson.Gson;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.events.ScriptContextAdapter;
import com.teamdev.jxbrowser.chromium.events.ScriptContextEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextListener;
import com.teamdev.jxbrowser.chromium.javafx.BrowserView;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Date;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;

public class CreditWebBrowserPart
extends LoggerInterface {
    @Inject
    private GetCreditTokenHandler handler;
    protected String path = "";
    @Inject
    @Optional
    protected BorderPane pane;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private WebBrowserService mis;
    @Inject
    protected MConfService cs;
    protected String url;
    protected Browser browser;
    @Inject
    protected IBaseApi baseApi;
    protected final Date start = new Date();
    private static final Gson gson = new Gson();

    public void initialize(String path) {
        this.url = path;
        this.initWebBrowser();
    }

    public String encode(String redirectUrl) {
        try {
            return URLEncoder.encode(redirectUrl, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("encode url error", (Throwable)e);
            return "";
        }
    }

    protected String getPath(String priPath) {
        return String.valueOf(this.cs.getValue("credit.url")) + "/Auth/RedirectUri?token=" + this.handler.getToken() + "&uri=" + this.encode(String.valueOf(this.cs.getValue("credit.tk.url")) + priPath);
    }

    protected String getGAPath(String priPath) {
        try {
            return String.valueOf(this.cs.getValue("xunce.url")) + "/system/cms/loginCms" + priPath + "/" + DesEncrypt.encrypt((String)this.baseApi.getUserId());
        }
        catch (Exception e) {
            this.logger.error("\u8fc5\u7b56userId \u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public void initWebBrowser() {
        Platform.runLater(() -> {
            this.logger.info("=================>  web part");
            this.browser = new Browser(BrowserType.LIGHTWEIGHT);
            this.browser.setSize((int)this.pane.getWidth(), (int)this.pane.getHeight());
            BrowserView browserView = new BrowserView(this.browser);
            browserView.getStyleClass().add((Object)"browser-view");
            this.addJsContextHandler();
            this.pane.setCenter((Node)browserView);
            if (this.cs.getValueAsBool("web.cache.disable", false)) {
                this.browser.getCacheStorage().clearCache();
            }
            this.browser.loadURL(this.path);
            if (this.cs.getValueAsBool("web.debug", false)) {
                this.setDebuggerConf();
            }
        });
    }

    protected void setDebuggerConf() {
        String remoteDebuggingURL = this.browser.getRemoteDebuggingURL();
        try {
            URI uri = new URI(remoteDebuggingURL);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        this.logger.debug("remoteDebuggingURL: " + remoteDebuggingURL);
    }

    protected void addJsContextHandler() {
        this.browser.addScriptContextListener((ScriptContextListener)new ScriptContextAdapter(){

            public void onScriptContextCreated(ScriptContextEvent event) {
                CreditWebBrowserPart.this.browser = event.getBrowser();
                JSValue window = CreditWebBrowserPart.this.browser.executeJavaScriptAndReturnValue("window");
                window.asObject().setProperty("LOGIN", (Object)CreditWebBrowserPart.this.mis.getWebLogin());
                window.asObject().setProperty("DIR_CHOOSER", (Object)new DirChooserUtil());
                window.asObject().setProperty("MSG_SERVICE", (Object)CreditWebBrowserPart.this.mis.getWebMsg());
                window.asObject().setProperty("OP_USER", (Object)gson.toJson(CreditWebBrowserPart.this.eCore.get((Object)"op_user")));
            }

            public void onScriptContextDestroyed(ScriptContextEvent event) {
                CreditWebBrowserPart.this.logger.info("ScriptContext destroyed!");
            }
        });
    }

    public void setPath(String path) {
        this.path = path;
    }

    @PreDestroy
    private void destroy() {
        if (this.pane != null) {
            this.pane.getChildren().clear();
        }
        this.mis.destroyBrowser(this.browser);
        this.logger.info("-------- WebBrowserPart: destroy called " + ((Object)((Object)this)).getClass().getSimpleName());
    }
}

