/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.jxb.OpResult;
import cms.tmx.manage.models.CustomPaneModel;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SaveCustomPaneHandler
implements WebTopicHandler {
    @Inject
    private MEventService es;
    @Inject
    private MObjFactory of;
    private CustomPaneModel dataBase;
    private static final Logger logger = LogManager.getLogger(SaveCustomPaneHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;

    @Override
    public String handle(String topic, String json) {
        try {
            this.op = new OpResult();
            this.dataBase = (CustomPaneModel)this.of.create(CustomPaneModel.class);
            logger.info(String.format("received topic: %s and param is: %s", topic, json));
            JsonObject obj = new JsonParser().parse(json).getAsJsonObject();
            String menu = obj.get("menu").toString();
            String id = obj.get("menu").getAsJsonObject().get("id").getAsString();
            String name = obj.get("menu").getAsJsonObject().get("name").getAsString();
            this.dataBase.add(id, menu, obj.toString());
            MEvent event = new MEvent();
            event.put((Object)"id", (Object)id);
            event.put((Object)"part_name", (Object)name);
            this.es.sendEvent("ADD_CUSTOM_PANE", event);
            this.op.setSuccess(true);
            this.op.setMessage("");
            return this.gson.toJson(this.op);
        }
        catch (Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u4fdd\u5b58\u6a21\u677f\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error((Object)e, (Throwable)e);
            return this.gson.toJson(this.op);
        }
    }
}

