/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.metrics.topic.handler.impl.DownloadHandlerDialog;
import cms.tmx.metrics.topic.handler.impl.OpenTabHandler;
import cms.tmx.metrics.topic.handler.impl.WebUrl;
import cms.tmx.metrics.views.CreditWebBrowserPart;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import java.io.File;
import java.net.URLDecoder;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class OpenTabOrDownloadHandler
implements WebTopicHandler {
    private static final Logger logger = LogManager.getLogger(OpenTabHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;
    @Inject
    private EPartService ps;
    @Inject
    protected MEventService es;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    private HttpClientService httpClient;

    @Override
    public String handle(String topic, String json) {
        WebUrl webUrl = (WebUrl)this.gson.fromJson(json, WebUrl.class);
        try {
            this.op = new OpResult();
            String id = "cms.tmx.metrics.part.CreditNewServerTabPane";
            Response response = this.httpClient.download(webUrl.getUrl());
            String contentType = response.headers().get("Content-Type");
            if (contentType.contains("text/html")) {
                Object object;
                MPart findPart = this.ps.findPart(id);
                if (findPart == null) {
                    this.op.setResult("\u672a\u627e\u5230\u5bf9\u5e94\u9762\u677f", false);
                    String resp = this.gson.toJson(this.op);
                    logger.info(resp);
                    return resp;
                }
                MEvent event = new MEvent();
                event.putStr("part_name", (Object)String.valueOf(webUrl.getTabName()));
                event.putStr("id", (Object)id);
                if (!findPart.isToBeRendered()) {
                    this.es.sendEvent("ui.navigate", event);
                } else {
                    this.es.sendEvent("ui.navigate.multi_open", event);
                    if (event.get(MPart.class, "new_part") != null) {
                        findPart = (MPart)event.get(MPart.class, "new_part");
                    }
                }
                if (findPart.getObject() == null) {
                    Thread.sleep(500L);
                }
                if ((object = findPart.getObject()) instanceof CreditWebBrowserPart) {
                    CreditWebBrowserPart part = (CreditWebBrowserPart)((Object)CreditWebBrowserPart.class.cast(object));
                    part.setPath(webUrl.getUrl());
                    part.initWebBrowser();
                }
            } else {
                byte[] bytes = response.body().bytes();
                FutureTask<String> downLoad = new FutureTask<String>(() -> {
                    try {
                        String header;
                        String name = webUrl.getFileName();
                        if (StringUtils.isEmpty((String)name) && (header = response.header("Content-Disposition")) != null && header.contains(";")) {
                            String[] split;
                            String[] stringArray = split = header.split(";");
                            int n = split.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String string = stringArray[n2];
                                if (string.contains("filename") || string.contains("fileName")) {
                                    name = URLDecoder.decode(string.substring(string.indexOf("=") + 1), "UTF-8");
                                    break;
                                }
                                ++n2;
                            }
                        }
                        String url = webUrl.getUrl();
                        if (StringUtils.isEmpty((String)name) && url.lastIndexOf("/") >= 0 && url.lastIndexOf("/") != url.length() - 1) {
                            name = url.substring(url.lastIndexOf("/") + 1);
                        }
                        if (bytes != null) {
                            File saveFile = ExcelUtils.saveFile((byte[])bytes, (String)name);
                            if (saveFile != null) {
                                DownloadHandlerDialog obj = (DownloadHandlerDialog)((Object)((Object)this.of.create(DownloadHandlerDialog.class)));
                                MxDialog dialog = this.df.create((DialogObj)obj, "\u6587\u4ef6");
                                dialog.getButton(ButtonType.OK).setVisible(false);
                                dialog.getButton(ButtonType.CANCEL).setVisible(false);
                                obj.setOk(dialog.getButton(ButtonType.OK));
                                obj.setCancel(dialog.getButton(ButtonType.CANCEL));
                                obj.setFile(saveFile);
                                ButtonType bt = dialog.launch();
                                bt.equals(ButtonType.OK);
                            }
                        } else {
                            this.op.setSuccess(false);
                        }
                        return this.gson.toJson(this.op);
                    }
                    catch (Exception e) {
                        this.op.setSuccess(false);
                        this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
                        logger.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                    catch (MException e1) {
                        if (e1.getCode() == 999994) {
                            this.op.setSuccess(false);
                            this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e1.getMessage());
                            logger.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e1);
                        }
                        return "";
                    }
                    return this.gson.toJson(this.op);
                });
                Platform.runLater(downLoad);
                String result = downLoad.get();
                return result;
            }
            this.op.setSuccess(true);
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
        catch (MException | Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage());
            String resp = this.gson.toJson(this.op);
            logger.info(String.valueOf(resp) + " req:" + json);
            return resp;
        }
    }
}

