/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.jxb.OpResult;
import cms.tmx.jxb.WebBrowserPart;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.metrics.topic.handler.impl.WebUrl;
import cms.tmx.metrics.views.CreditWebBrowserPart;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class OpenTabHandler
implements WebTopicHandler {
    private static final Logger logger = LogManager.getLogger(OpenTabHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;
    @Inject
    private EPartService ps;
    @Inject
    protected MEventService es;

    @Override
    public String handle(String topic, String json) {
        WebUrl webUrl = (WebUrl)this.gson.fromJson(json, WebUrl.class);
        try {
            Object object;
            this.op = new OpResult();
            String id = "";
            id = "credit".equals(webUrl.getType()) ? "cms.tmx.metrics.part.CreditNewTabPane" : ("creditServer".equals(webUrl.getType()) ? "cms.tmx.metrics.part.CreditNewServerTabPane" : "cms.tmx.metrics.part.CustomPane");
            MPart findPart = this.ps.findPart(id);
            if (findPart == null) {
                this.op.setResult("\u672a\u627e\u5230\u5bf9\u5e94\u9762\u677f", false);
                String resp = this.gson.toJson(this.op);
                logger.info(resp);
                return resp;
            }
            MEvent event = new MEvent();
            event.putStr("part_name", (Object)String.valueOf(webUrl.getTabName()));
            event.putStr("id", (Object)id);
            if (!findPart.isToBeRendered()) {
                this.es.sendEvent("ui.navigate", event);
            } else {
                event.put((Object)"url", (Object)webUrl.getUrl());
                this.es.sendEvent("ui.navigate.multi_open", event);
                if (event.get(MPart.class, "new_part") != null) {
                    findPart = (MPart)event.get(MPart.class, "new_part");
                }
            }
            if ("credit".equals(webUrl.getType())) {
                Thread.sleep(500L);
                object = findPart.getObject();
                if (object instanceof WebBrowserPart) {
                    WebBrowserPart part = (WebBrowserPart)WebBrowserPart.class.cast(object);
                    part.setUrl(webUrl.getUrl());
                    part.setType(WebBrowserPart.BrowserType.CREDIT);
                    part.setCenter();
                    part.changeHash();
                }
            } else if ("creditServer".equals(webUrl.getType())) {
                if (findPart.getObject() == null) {
                    Thread.sleep(500L);
                }
                if ((object = findPart.getObject()) instanceof CreditWebBrowserPart) {
                    CreditWebBrowserPart part = (CreditWebBrowserPart)((Object)CreditWebBrowserPart.class.cast(object));
                    part.setPath(webUrl.getUrl());
                    part.initWebBrowser();
                }
            }
            this.op.setSuccess(true);
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
        catch (Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u83b7\u53d6\u6301\u4ed3\u5f02\u5e38\uff1a" + e.getMessage());
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
    }
}

