/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.core.MEvent;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.models.WebLog;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LogHandler
implements WebTopicHandler {
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private static final Logger logger = LogManager.getLogger(LogHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;

    @Override
    public String handle(String topic, String json) {
        try {
            this.op = new OpResult();
            WebLog log = (WebLog)this.gson.fromJson(json, WebLog.class);
            switch (log.getLevel()) {
                case 1: {
                    logger.debug(log.getMessage());
                    break;
                }
                case 2: {
                    logger.info(log.getMessage());
                    break;
                }
                case 3: {
                    logger.warn(log.getMessage());
                    break;
                }
                case 4: {
                    logger.error(log.getMessage());
                    break;
                }
            }
            this.op.setSuccess(true);
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
        catch (Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u8bb0\u5f55\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
    }
}

