/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.entity.data.RefItem;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.metrics.topic.handler.impl.WebRefItem;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.value.ChangeListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class GetStarRefitemsHandler
implements WebTopicHandler {
    @Inject
    private IRefDataMng refMng;
    private static final Logger logger = LogManager.getLogger(GetStarRefitemsHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;
    private ReentrantLock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    ChangeListener<? super Boolean> refLis = (ob, oldV, newV) -> {
        this.lock.lock();
        try {
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    };

    @Override
    public String handle(String topic, String json) {
        logger.info("\u7b97\u6cd5\u7f51\u9875\u83b7\u53d6\u9759\u6001\u884c\u60c5\u5f00\u59cb");
        try {
            this.op = new OpResult();
            LinkedList<WebRefItem> list = new LinkedList<WebRefItem>();
            Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
            if (items.isEmpty()) {
                this.lock.lock();
                try {
                    this.refMng.doneProperty().addListener(this.refLis);
                    logger.info("\u5f00\u59cb\u7b49\u5f85");
                    this.cond.await(20000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.lock.unlock();
                }
                logger.info("\u7b49\u5f85\u5b8c\u6bd5" + items.size());
                items = this.refMng.getItems(new String[]{"STOCK"});
                if (items.isEmpty()) {
                    this.op.setSuccess(false);
                    this.op.setMessage("\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                    String resp = this.gson.toJson(this.op);
                    logger.info(resp);
                    return resp;
                }
            }
            for (RefItem refItem : items) {
                list.add(new WebRefItem(refItem));
            }
            this.op.setRes(list);
            this.op.setSuccess(true);
            String resp = this.gson.toJson(this.op);
            logger.info("\u7b97\u6cd5\u7f51\u9875\u83b7\u53d6\u9759\u6001\u884c\u60c5\u6210\u529f\uff0csize\uff1a" + list.size());
            return resp;
        }
        catch (Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u83b7\u53d6\u9759\u6001\u884c\u60c5\u5f02\u5e38\uff1a" + e.getMessage());
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
    }
}

