/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.define.BsDict;
import cms.tmx.entity.web.algo.WebOpUser;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.utils.CommUtils;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class GetOpUserHandler
implements WebTopicHandler {
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private IBaseApi iBaseApi;
    @Inject
    private MConfService cs;
    private static final Logger logger = LogManager.getLogger(GetOpUserHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;

    @Override
    public String handle(String topic, String json) {
        try {
            this.op = new OpResult();
            WebOpUser opUser = (WebOpUser)this.eCore.get(WebOpUser.class, "op_user");
            if (opUser == null) {
                opUser = this.buildWebOpUser();
            }
            if (opUser == null) {
                this.op.setSuccess(false);
                this.op.setMessage("\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u8005\u4fe1\u606f");
                String resp = this.gson.toJson(this.op);
                logger.info(resp);
                return resp;
            }
            this.op.setRes((Object)opUser);
            this.op.setSuccess(true);
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
        catch (Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u83b7\u53d6\u64cd\u4f5c\u8005\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            String resp = this.gson.toJson(this.op);
            logger.info(resp);
            return resp;
        }
    }

    private WebOpUser buildWebOpUser() {
        if (this.eCore.get((Object)"SESSION_ID") != null) {
            WebOpUser webOpUser = new WebOpUser();
            webOpUser.setUserId(this.iBaseApi.getUserId());
            webOpUser.setPostId(this.iBaseApi.getPostId());
            webOpUser.setUuid(this.eCore.getStr("uuid"));
            webOpUser.setSessionId((byte[])this.eCore.get((Object)"SESSION_ID"));
            webOpUser.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
            webOpUser.setMac(CommUtils.getMAC());
            webOpUser.setSn(CommUtils.getSerialNumber());
            webOpUser.setLocalIp(CommUtils.getIP());
            webOpUser.setCpu(CommUtils.getCPUSerial());
            webOpUser.setSno("");
            webOpUser.setPort(String.valueOf(this.eCore.getInt("port")));
            webOpUser.setPcn(CommUtils.getPCName());
            webOpUser.setPi(CommUtils.getPI());
            webOpUser.setVol(CommUtils.getVolNew());
            webOpUser.setOsv(CommUtils.getOSV());
            webOpUser.setTerminalType("PC");
            webOpUser.setTerminalName("T-master");
            webOpUser.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
            Integer level = (Integer)BsDict.LogMap.get(LogManager.getRootLogger().getLevel().toString());
            if (level != null) {
                webOpUser.setLogLevel(level.intValue());
            }
            this.eCore.put((Object)"op_user", (Object)webOpUser);
            return webOpUser;
        }
        return null;
    }
}

