/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IUserApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.utils.CmsRsa;
import cms.tmx.entity.web.credit.CreditToken;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import java.net.URLEncoder;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class GetCreditTokenHandler
implements WebTopicHandler {
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private IBaseApi iBaseApi;
    @Inject
    private IUserApi userApi;
    private static final Logger logger = LogManager.getLogger(GetCreditTokenHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;
    @Inject
    private MEventService es;
    @Inject
    private HttpClientService httpClient;
    private String creditToken;
    private String sessionId;
    private String baseUrl;
    private String tokenUrl;
    @Inject
    private MConfService ms;
    private String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnRFfOSB1wrZ98eVXcOTYln55fz/zznxN/PV+hM4b/Q7PZeSECFAHo7On12fL1UBlMIZiercvbFb5LxktpwKtMmRUarq4l7KBCF+Xijfrler+s9elgT6OJvUGQ9oU0LFTXvo4s6EKiefXxKTnLge7cvcNUAo/0FsPmuwEyZmbsqQIDAQAB";

    @PostConstruct
    private void init() {
        this.es.subscribe("stage.pre.login", event -> {
            String string = this.getToken();
        });
        this.es.subscribe("credit.login", event -> {
            String string = this.getToken();
        });
        this.baseUrl = this.ms.getValue("credit.url");
        this.tokenUrl = this.ms.getValue("credit.tk.url");
    }

    @Override
    public String handle(String topic, String json) {
        this.op = new OpResult();
        if (StringUtils.isEmpty((String)this.creditToken)) {
            this.creditToken = this.getToken();
            if ("".equals(this.creditToken)) {
                this.op.setRes((Object)"");
                this.op.setSuccess(false);
                return this.gson.toJson(this.op);
            }
        }
        this.op.setRes((Object)this.creditToken);
        this.op.setSuccess(true);
        return this.gson.toJson(this.op);
    }

    public synchronized String getToken() {
        if (StringUtils.isEmpty((String)this.baseUrl) || StringUtils.isEmpty((String)this.tokenUrl)) {
            return "";
        }
        try {
            UUID randomUUID = UUID.randomUUID();
            String userName = "";
            try {
                userName = this.userApi.getActiveUser().getUserName();
            }
            catch (MException | Exception e) {
                logger.error("\u83b7\u53d6\u7528\u6237\u540d\u51fa\u9519", e);
            }
            if (StringUtils.isEmpty((String)userName)) {
                userName = this.eCore.getStr("user_login");
            }
            String password = URLEncoder.encode(CmsRsa.encrypt((String)(String.valueOf(userName) + "@" + randomUUID), (String)this.publicKey), "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
            CreditToken token = this.httpClient.getCreditToken(String.valueOf(this.baseUrl) + "/Auth/GetAccessToken?secret=rsa&access=" + password, false);
            if (token != null && token.isOk()) {
                Response resp = this.httpClient.doPostCredit(String.valueOf(this.tokenUrl) + "/SSO/ApiSSO.ashx?token=" + token.getToken());
                String headers = resp.headers().get("Set-Cookie");
                if (!StringUtils.isEmpty((String)headers)) {
                    String[] split;
                    String[] stringArray = split = headers.split(";");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        if (string.contains("ASP.NET_SessionId") && string.contains("=")) {
                            this.sessionId = string.split("=")[1];
                            break;
                        }
                        ++n2;
                    }
                }
                if (StringUtils.isEmpty((String)this.sessionId)) {
                    logger.error("\u83b7\u53d6sessionId\u5931\u8d25" + headers);
                }
                this.creditToken = token.getToken();
                return token.getToken();
            }
            logger.error("\u83b7\u53d6\u4fe1\u7528\u7ba1\u7406\u7cfb\u7edftoken\u5931\u8d25");
            return "";
        }
        catch (MException | Exception e) {
            logger.error("\u83b7\u53d6\u4fe1\u7528\u7ba1\u7406\u7cfb\u7edftoken\u5931\u8d25", e);
            return "";
        }
    }

    public String getSessionId() {
        if (StringUtils.isEmpty((String)this.sessionId)) {
            this.getToken();
        }
        return this.sessionId;
    }
}

