/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.query.current.models.InstructionModel;
import cn.hutool.core.util.RuntimeUtil;
import java.io.File;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;

public class DownloadHandlerDialog
extends DialogObj {
    @FXML
    private Button openDirBtn;
    @FXML
    private Button openFileBtn;
    @FXML
    private Button cancelBtn;
    private File file;
    @Inject
    protected InstructionModel model;
    private Button ok;
    private Button cancel;

    @FXML
    public void initialize() {
        this.initialValues();
    }

    protected boolean isOK(ButtonType bt) {
        return true;
    }

    private void initialValues() {
        this.openDirBtn.setOnAction(e -> this.openDir());
        this.openFileBtn.setOnAction(e -> this.openFile());
        this.cancelBtn.setOnAction(e -> this.cancel());
        Platform.runLater(() -> this.openDirBtn.requestFocus());
    }

    private void cancel() {
        this.cancel.fire();
    }

    private void openDir() {
        RuntimeUtil.execForStr((String[])new String[]{"explorer " + this.file.getParent()});
        this.ok.fire();
    }

    private void openFile() {
        RuntimeUtil.execForStr((String[])new String[]{"explorer " + this.file.getAbsolutePath()});
        this.ok.fire();
    }

    public Button getOk() {
        return this.ok;
    }

    public void setOk(Button ok) {
        this.ok = ok;
    }

    public Button getCancel() {
        return this.cancel;
    }

    public void setCancel(Button cancel) {
        this.cancel = cancel;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

