/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.web.download.WebDownloadUrl;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.metrics.topic.handler.impl.DownloadHandlerDialog;
import cms.tmx.metrics.topic.handler.impl.GetCreditTokenHandler;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import java.io.File;
import java.net.URLDecoder;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DownLoadFileWithNameHandler
implements WebTopicHandler {
    @Inject
    private HttpClientService http;
    @Inject
    private GetCreditTokenHandler getToken;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    private static final Logger logger = LogManager.getLogger(DownLoadFileWithNameHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;
    @Inject
    private MxAlert alert;

    @Override
    public String handle(String topic, String json) {
        try {
            this.op = new OpResult();
            this.op.setSuccess(true);
            logger.info(String.format("received topic: %s and param is: %s", topic, json));
            WebDownloadUrl webUrl = (WebDownloadUrl)this.gson.fromJson(json, WebDownloadUrl.class);
            String sessionId = this.getToken.getSessionId();
            sessionId = "ASP.NET_SessionId=" + sessionId;
            Response response = webUrl.isReal() ? this.http.download(webUrl.getUrl(), sessionId) : this.http.doGet(webUrl.getUrl(), sessionId);
            byte[] bytes = response.body().bytes();
            FutureTask<String> downLoad = new FutureTask<String>(() -> {
                try {
                    String header;
                    String name = webUrl.getFileName();
                    if (StringUtils.isEmpty((String)name) && (header = response.header("Content-Disposition")) != null && header.contains(";")) {
                        String[] split;
                        String[] stringArray = split = header.split(";");
                        int n = split.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string = stringArray[n2];
                            if (string.contains("filename") || string.contains("fileName")) {
                                name = URLDecoder.decode(string.substring(string.indexOf("=") + 1), "UTF-8");
                                break;
                            }
                            ++n2;
                        }
                    }
                    String url = webUrl.getUrl();
                    if (StringUtils.isEmpty((String)name) && url.lastIndexOf("/") >= 0 && url.lastIndexOf("/") != url.length() - 1) {
                        name = url.substring(url.lastIndexOf("/") + 1);
                    }
                    if (bytes != null) {
                        File saveFile = ExcelUtils.saveFile((byte[])bytes, (String)URLDecoder.decode(name));
                        if (saveFile != null) {
                            DownloadHandlerDialog obj = (DownloadHandlerDialog)((Object)((Object)this.of.create(DownloadHandlerDialog.class)));
                            MxDialog dialog = this.df.create((DialogObj)obj, "\u6587\u4ef6\u5904\u7406");
                            dialog.getButton(ButtonType.OK).setVisible(false);
                            dialog.getButton(ButtonType.CANCEL).setVisible(false);
                            obj.setOk(dialog.getButton(ButtonType.OK));
                            obj.setCancel(dialog.getButton(ButtonType.CANCEL));
                            obj.setFile(saveFile);
                            ButtonType bt = dialog.launch();
                            bt.equals(ButtonType.OK);
                        }
                    } else {
                        this.op.setSuccess(false);
                    }
                    return this.gson.toJson(this.op);
                }
                catch (Exception e) {
                    this.op.setSuccess(false);
                    this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
                    logger.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
                }
                catch (MException e1) {
                    if (e1.getCode() == 999994) {
                        this.op.setSuccess(false);
                        this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e1.getMessage());
                        logger.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e1);
                    }
                    return "";
                }
                return this.gson.toJson(this.op);
            });
            Platform.runLater(downLoad);
            String result = downLoad.get();
            return result;
        }
        catch (MException | Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error((Object)e, e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            return this.gson.toJson(this.op);
        }
    }
}

