/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.topic.handler.impl;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.jxb.OpResult;
import cms.tmx.metrics.models.FileResp;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DownLoadBinaryFileHandler
implements WebTopicHandler {
    @Inject
    @Named(value="base.path")
    private String basePath;
    private static final Logger logger = LogManager.getLogger(DownLoadBinaryFileHandler.class);
    private Gson gson = new Gson();
    private OpResult<Object> op;
    @Inject
    private MxAlert alert;

    @Override
    public String handle(String topic, String json) {
        try {
            this.op = new OpResult();
            this.op.setSuccess(true);
            FileResp resp = (FileResp)this.gson.fromJson(json, FileResp.class);
            String name = resp.getName();
            if (resp.getValue() == null) {
                this.op.setSuccess(false);
                this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38");
                return this.gson.toJson(this.op);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(resp.getValue());
            FutureTask<String> downLoad = new FutureTask<String>(() -> {
                try {
                    ExcelUtils.saveFile((InputStream)inputStream, (String)name);
                }
                catch (Exception e) {
                    this.op.setSuccess(false);
                    this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
                    logger.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
                }
                catch (MException e1) {
                    if (e1.getCode() == 999994) {
                        this.op.setSuccess(false);
                        this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e1.getMessage());
                        logger.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e1);
                    }
                    return "";
                }
                return this.gson.toJson(this.op);
            });
            Platform.runLater(downLoad);
            String result = downLoad.get();
            return result;
        }
        catch (Exception e) {
            this.op.setSuccess(false);
            this.op.setMessage("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            return this.gson.toJson(this.op);
        }
    }
}

