/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.service.impl;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IUserApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.jxb.WebLoginInterface;
import cms.tmx.metrics.service.IWebLoginService;
import cms.tmx.metrics.service.impl.UserSession;
import cms.tmx.utils.CommUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.alibaba.druid.util.StringUtils;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WebLoginServiceImpl
implements IWebLoginService,
WebLoginInterface {
    private static final Logger logger = LogManager.getLogger(WebLoginServiceImpl.class);
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IUserApi userApi;
    @Inject
    private HttpClientService httpClient;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private MEventService es;
    @Inject
    private MConfService cs;
    private Gson gson = new Gson();

    public void logout() {
        UserSession userSession = new UserSession();
        userSession.setLogoutTime(System.currentTimeMillis());
        userSession.setMac(CommUtils.getMAC());
        userSession.setUserId(this.baseApi.getUserId());
        try {
            this.httpClient.doPostJson("/user/clientLogout", this.gson.toJson((Object)userSession), false);
        }
        catch (MException e) {
            logger.error("\u8c03\u7528\u7528\u6237\u767b\u51fa\u63a5\u53e3\u5931\u8d25  clientLogout " + this.baseApi.getUserId() + " " + CommUtils.getMAC(), (Throwable)e);
        }
    }

    public String loginWithUserInfoReturn() {
        boolean flag = this.httpClient.loginAndSetToken();
        if (flag) {
            UserSession userSession = this.getUserSession();
            logger.info("======== \u8bbe\u7f6e token \u6210\u529f loginWithUserInfoReturn ======== " + this.gson.toJson((Object)userSession));
            return this.gson.toJson((Object)userSession);
        }
        logger.error("======== login \u8bbe\u7f6e token fail !!!! ======== ");
        return null;
    }

    private UserSession getUserSession() {
        UserSession s = new UserSession();
        s.setUserId(this.baseApi.getUserId());
        String userName = "";
        try {
            userName = this.userApi.getActiveUser().getUserName();
        }
        catch (MException mException) {
            logger.error("======== \u83b7\u53d6\u7528\u6237\u540d\u5931\u8d25 !!!! ======== ");
        }
        s.setUserName(userName);
        s.setPostId(this.baseApi.getPostId());
        s.setPartyId(this.baseApi.getPartyId());
        s.setMac(CommUtils.getMAC());
        s.setIp(CommUtils.getIP());
        s.setOldToken(this.baseApi.getToken());
        s.setAccessToken(this.baseApi.getAccessToken());
        s.setRefreshToken(this.baseApi.getRefreshToken());
        s.setCmstmxToken(this.baseApi.getCmstmxToken());
        s.setVersion(this.baseApi.getVersion());
        String theme = this.eCore.getStr("web-theme");
        if (!StringUtils.isEmpty((String)theme)) {
            s.setTheme(theme);
        } else {
            s.setTheme("blue-theme".equals(this.cs.getUserProps().get("app_theme", "blue-theme")) ? "blue" : "white");
        }
        return s;
    }

    public boolean login() {
        boolean flag = this.httpClient.loginAndSetToken();
        logger.info("======== login \u8bbe\u7f6e token result ======== " + flag);
        this.es.postEvent("token.done", null);
        return flag;
    }
}

