/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.service.impl;

import cms.tmx.core.MAddon;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.metrics.service.IOperatingService;
import cms.tmx.metrics.service.impl.WebLoginServiceImpl;
import cms.tmx.utils.CommUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OperatingServiceImpl
extends MAddon
implements IOperatingService {
    private static final Logger logger = LogManager.getLogger(OperatingServiceImpl.class);
    @Inject
    private MEventService es;
    @Inject
    private HttpClientService httpClient;
    private Gson gson = new Gson();
    @Inject
    private MObjFactory of;
    private MxNode funModuleNode;
    @Inject
    private ExecutorService exe;
    @Inject
    private WebLoginServiceImpl webLoginService;
    AtomicBoolean connected = null;

    @PostConstruct
    private void init() {
        this.funModuleNode = MxNodeFactory.create((String)"func_module_map", (String)"");
        this.es.subscribe("module.begin", event -> this.saveModuleBegin(event));
        this.es.subscribe("module.end", event -> this.saveModuleEnd(event));
        this.es.subscribe("stage.pre.login", event -> this.saveLogin(event));
        this.es.subscribe("server.hb.fail", event -> this.saveConnectStatusChange(false));
        this.es.subscribe("server.hb.ok", event -> this.saveConnectStatusChange(true));
        this.es.subscribe("on.exit", event -> this.saveLogout(event));
        super.loadDone();
    }

    private void saveModuleEnd(MEvent event) {
        this.exe.execute(() -> {
            MxNode node = this.funModuleNode.getNode(event.getStr("moduleId"));
            if (node == null) {
                return;
            }
            String moduleId = event.getStr("moduleId");
            String beginTime = event.getStr("beginTime");
            String endTime = event.getStr("endTime");
            this.saveModuleUseTime(moduleId, node.getValue(), beginTime, endTime);
        });
    }

    private void saveModuleBegin(MEvent event) {
        this.exe.execute(() -> {
            MxNode node = this.funModuleNode.getNode(event.getStr("moduleId"));
            if (node == null) {
                return;
            }
            String moduleId = event.getStr("moduleId");
            String beginTime = event.getStr("beginTime");
            this.saveModuleUseTime(moduleId, node.getValue(), beginTime, "0");
        });
    }

    private void saveModuleUseTime(String moduleId, String moduleName, String beginTime, String endTime) {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("moduleId", moduleId);
            param.put("moduleName", moduleName);
            param.put("beginTime", beginTime);
            param.put("endTime", endTime);
            if ("0".equalsIgnoreCase(endTime)) {
                param.put("duration", "0");
            } else {
                param.put("duration", String.valueOf(Long.valueOf(endTime) - Long.valueOf(beginTime)));
            }
            param.put("mac", CommUtils.getMAC());
            param.put("date", endTime);
            param.put("ip", CommUtils.getIP());
            this.httpClient.doPostJson("/operating/saveModuleUseInfo", this.gson.toJson(param), false);
        }
        catch (MException e) {
            logger.error("\u8bb0\u5f55\u6a21\u5757\u4f7f\u7528\u6b21\u6570\u51fa\u9519" + (Object)((Object)e));
        }
    }

    public void menuSelected(MEvent event) {
    }

    public void saveLogin(MEvent event) {
        this.exe.execute(() -> this.webLoginService.login());
    }

    public void saveConnectStatusChange(boolean isConnected) {
        if (this.connected == null) {
            this.connected = new AtomicBoolean(isConnected);
        } else if (this.connected.get() != isConnected && this.connected.compareAndSet(!isConnected, isConnected) && this.connected.get()) {
            logger.info(" \u76d1\u542c\u72b6\u6001 to reConnected and saveLoginInfo " + isConnected);
            this.exe.execute(() -> {
                HashMap<String, Long> param = new HashMap<String, Long>();
                param.put("loginTime", System.currentTimeMillis());
                try {
                    this.httpClient.doPostJson("/operating/updateLoginCount", this.gson.toJson(param), false);
                }
                catch (MException e) {
                    logger.error("\u8c03\u7528\u7528\u6237\u767b\u9646\u6b21\u6570\u63a5\u53e3\u5931\u8d25 updateLoginCount " + param, (Throwable)e);
                }
            });
        }
    }

    public void saveLogout(MEvent event) {
        logger.info("=====OperatingServiceImpl exit start ==========");
        this.webLoginService.logout();
        logger.info("=====OperatingServiceImpl exit end ==========");
    }
}

