/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxFileChooser;
import cms.tmx.core.MConfService;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.finance.Annex;
import cms.tmx.javafx.MxModel;
import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ReportMng
extends MxModel {
    private Gson gson = new Gson();
    private static final Logger logger = LogManager.getLogger(ReportMng.class);
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private MxFileChooser mfc;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="base.path")
    private String baseDir;

    public void alert(Alert.AlertType type, String msg) {
        Platform.runLater(() -> this.alert.alert(type, msg));
    }

    public void download(String json) {
        Annex annex = (Annex)this.gson.fromJson(json, Annex.class);
        Platform.runLater(() -> {
            try {
                File file = this.mfc.saveFile(annex.getUrl(), annex.getFormat(), annex.getName(), this.getDirectory());
                if (file != null) {
                    this.cs.setValue("download", (Object)file.getParentFile());
                    this.alert.alert(Alert.AlertType.INFORMATION, "\u4fdd\u5b58\u6210\u529f");
                }
            }
            catch (Exception e) {
                logger.error("save file error " + json, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        });
    }

    private File getDirectory() {
        String saveDir = this.cs.getValue("download");
        if (saveDir.isEmpty()) {
            saveDir = Paths.get(this.baseDir, "download").toString();
            this.cs.setValue("download", (Object)saveDir);
        }
        File folder = new File(saveDir);
        folder.mkdirs();
        return folder;
    }
}

