/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.addons;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MAddon;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.datatype.proto.unify_risk.PUnifyRiskService;
import cms.tmx.entity.notice.StaticRiskReport;
import cms.tmx.jxb.IBrowserUpdater;
import cms.tmx.jxb.WebBrowserPart;
import cms.tmx.jxb.WebBrowserService;
import cms.tmx.jxb.WebBrowserServiceImp;
import cms.tmx.jxb.WebLoginInterface;
import cms.tmx.jxb.WebMsgInterface;
import cms.tmx.metrics.addons.HeartBeatMng;
import cms.tmx.metrics.service.impl.WebLoginServiceImpl;
import cms.tmx.metrics.service.impl.WebMsgServiceImpl;
import cms.tmx.metrics.topic.handler.WebTopicHandler;
import cms.tmx.metrics.topic.handler.impl.WebTopicHandlerImpl;
import cms.tmx.metrics.views.CustomizePanePart;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.WebStorage;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import java.util.List;
import javafx.application.Platform;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class WebAddon
extends MAddon {
    @Inject
    private IEclipseContext ctxt;
    @Inject
    private WebBrowserServiceImp serviceWB;
    @Inject
    private WebTopicHandlerImpl handler;
    @Inject
    private WebLoginServiceImpl serviceLogin;
    @Inject
    private WebMsgServiceImpl serviceMsg;
    @Inject
    private IBaseApi apiBase;
    @Inject
    private EPartService ps;
    @Inject
    protected MEventService es;
    @Inject
    private EPartService eps;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    @Inject
    private HeartBeatMng hb;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    IBrowserUpdater updaterUser = browser -> {
        final String token = this.apiBase.getToken();
        JsonObject user = new JsonObject();
        user.addProperty("userId", this.apiBase.getUserId());
        JsonObject position = new JsonObject();
        position.addProperty("partyId", this.apiBase.getPartyId());
        position.addProperty("postId", this.apiBase.getPostId());
        user.add("position", (JsonElement)position);
        final String userInfo = user.toString();
        browser.addLoadListener((LoadListener)new LoadAdapter(){

            public void onDocumentLoadedInMainFrame(LoadEvent event) {
                WebAddon.this.addToken(event.getBrowser(), userInfo, token);
            }
        });
        this.addToken(browser, userInfo, token);
    };

    @PostConstruct
    private void init() {
        this.serviceWB.injectServiceLogin((WebLoginInterface)this.serviceLogin);
        this.serviceWB.injectServiceMsg((WebMsgInterface)this.serviceMsg);
        this.addBrowserUpdater();
        this.ctxt.set(WebBrowserService.class, (Object)this.serviceWB);
        this.ctxt.set(WebTopicHandler.class, (Object)this.handler);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("ui.navigate.custom_pane", event -> Platform.runLater(() -> this.navigateCustom(event)));
        this.es.subscribe("change.style", event -> this.changeWebStyle(event));
        super.loadDone();
    }

    public void addToken(Browser browser, String userInfo, String token) {
        browser.executeJavaScript("localStorage");
        WebStorage webStorage = browser.getLocalWebStorage();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("set jxbrowser " + browser + " " + webStorage + " " + userInfo + " " + token);
        }
        webStorage.setItem("currentUser", userInfo);
        webStorage.setItem("access_token_name", "cms_s_token");
        webStorage.setItem("cms_s_token", token == null ? "token" : token);
    }

    private void addBrowserUpdater() {
        this.serviceWB.addBrowserUpdater(this.updaterUser);
        this.serviceWB.update();
    }

    private void onPush(MEvent event) {
        if (event.getObj() instanceof StaticRiskReport) {
            PUnifyRiskService.GetStaticRiskPush push = ((StaticRiskReport)StaticRiskReport.class.cast(event.getObj())).getReport();
            this.logger.info((Object)push);
            String partyId = push.getExt();
            JsonObject msg = new JsonObject();
            msg.addProperty("partyId", partyId);
            this.logger.info("receive static risk caculate push :" + partyId);
            this.sendMsgToWeb("cms.tmx.metrics.part.staticRisk", "staticRiskCaculate", msg.toString());
        }
    }

    private void sendMsgToWeb(String partId, String topic, String jsonParam) {
        MPart findPart = this.eps.findPart(partId);
        if (findPart != null && findPart.getObject() instanceof WebBrowserPart) {
            WebBrowserPart part = (WebBrowserPart)WebBrowserPart.class.cast(findPart.getObject());
            String script = "window.$EVENT.emit('" + topic + "', " + jsonParam + ")";
            this.logger.info("script \uff1a" + script);
            part.getBrowser().executeJavaScript(script);
        }
    }

    private synchronized void navigateCustom(MEvent event) {
        String name = event.getStr("part_name");
        String id = event.getStr("id");
        String trueId = "cms.tmx.metrics.part.customizePane&_&" + id;
        MPart truePart = this.ps.findPart(trueId);
        if (truePart != null && truePart.isToBeRendered()) {
            this.ps.activate(truePart);
            return;
        }
        MPart part = this.ps.findPart("cms.tmx.metrics.part.customizePane");
        MPart newPart = this.ps.createPart(part.getElementId());
        if (newPart == null) {
            this.createDesc(this.ms, this.app, part, "cms.tmx.app.ps.right".equals(part.getParent().getElementId()));
            newPart = this.ps.createPart(part.getElementId());
        }
        if (newPart != null) {
            newPart.setElementId(String.valueOf(part.getElementId()) + "&_&" + id);
            newPart.setLabel(name);
            part.getParent().getChildren().add(newPart);
            if (newPart != null && newPart.getObject() instanceof CustomizePanePart) {
                newPart.setLabel(event.getStr("part_name"));
                CustomizePanePart p = (CustomizePanePart)((Object)CustomizePanePart.class.cast(newPart.getObject()));
                p.setId(event.getStr("id"));
            }
            newPart.setToBeRendered(true);
            newPart.setVisible(true);
            this.ps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
    }

    private void createDesc(EModelService ms, MApplication app, MPart part, boolean closeable) {
        MPartDescriptor desc = (MPartDescriptor)ms.createModelElement(MPartDescriptor.class);
        desc.setElementId(part.getElementId());
        desc.setContributorURI(part.getContributorURI());
        desc.setContributionURI(part.getContributionURI());
        desc.setLabel(part.getLabel());
        desc.setCloseable(closeable);
        desc.setIconURI(part.getIconURI());
        desc.setTooltip(part.getTooltip());
        desc.getTags().addAll(part.getTags());
        desc.getVariables().addAll(part.getVariables());
        desc.getProperties().putAll(part.getProperties());
        desc.getPersistedState().putAll(part.getPersistedState());
        desc.getBindingContexts().addAll(part.getBindingContexts());
        app.getDescriptors().add(desc);
    }

    private void changeWebStyle(MEvent event) {
        PartStackImpl stack;
        List children;
        List findElements = this.ms.findElements((MUIElement)this.app, "cms.tmx.app.ps.right", MPartStack.class, null);
        if (!findElements.isEmpty() && findElements.get(1) instanceof PartStackImpl && !(children = (stack = (PartStackImpl)PartStackImpl.class.cast(findElements.get(1))).getChildren()).isEmpty()) {
            for (MStackElement item : children) {
                WebBrowserPart browserPart;
                Browser browser;
                if (!(item instanceof MPart) || !(((MPart)item).getObject() instanceof WebBrowserPart) || (browser = (browserPart = (WebBrowserPart)WebBrowserPart.class.cast(((MPart)item).getObject())).getBrowser()) == null) continue;
                browser.executeJavaScript("window.changeThemeStyle('" + event.getObj() + "')");
            }
        }
    }
}

