/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.metrics.addons;

import cms.tmx.core.MConfService;
import cms.tmx.core.MCrontabService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.javafx.MxModel;
import cms.tmx.web.api.core.HttpClientService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HeartBeatMng
extends MxModel {
    private static final int MIN_SERVER_HEART_BEAT_INTERVAL = 1000;
    private static final int DEFAULT_SERVER_HEART_BEAT_INTERVAL = 10000;
    private BooleanProperty connected = new SimpleBooleanProperty(true);
    @Inject
    private MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private HttpClientService service;
    @Inject
    private MCrontabService crontab;
    @Inject
    private MConfService cs;
    private ScheduledFuture<?> metricsHB;
    private int interval;

    @PostConstruct
    public void init() {
        this.interval = this.cs.getValueAsInt("server.hb.interval", 10000);
        if (this.interval < 1000) {
            this.interval = 1000;
        }
    }

    @PreDestroy
    private void close() {
        if (this.metricsHB != null) {
            this.metricsHB.cancel(true);
        }
    }

    private void afterLogin(MEvent event) {
        this.metricsHB = this.ses.scheduleWithFixedDelay(() -> this.heartBeat(), this.interval, this.interval, TimeUnit.MILLISECONDS);
    }

    private synchronized void heartBeat() {
        boolean bRet = this.doHeartBeat();
        if (bRet) {
            this.logger.debug("[web service] hb ok");
            if (!this.isConnected()) {
                this.es.postEvent("server.web.reconnected", null);
            }
            this.setConnected(true);
        } else {
            this.logger.error("[web service] hb fail");
            if (this.isConnected()) {
                this.es.postEvent("server.web.disconnected", null);
            }
            this.setConnected(false);
        }
    }

    private boolean doHeartBeat() {
        try {
            this.service.doGet("/check/status", null, true, 3);
            return true;
        }
        catch (MException mException) {
            return false;
        }
    }

    public final BooleanProperty connectedProperty() {
        return this.connected;
    }

    public final boolean isConnected() {
        return this.connectedProperty().get();
    }

    public final void setConnected(boolean connected) {
        this.connectedProperty().set(connected);
    }
}

